/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.comparator.HypervolumeContributionComparator;
import org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.Hypervolume;

public class HypervolumeArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> comparator = new HypervolumeContributionComparator();
    Hypervolume<S> hypervolume;

    public HypervolumeArchive(int maxSize, Hypervolume<S> hypervolume) {
        super(maxSize);
        this.hypervolume = hypervolume;
    }

    @Override
    public void prune() {
        if (this.solutions().size() > this.maximumSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.solutions(), this.comparator);
            this.solutions().remove(worst);
        }
    }

    @Override
    public Comparator<S> comparator() {
        return this.comparator;
    }

    @Override
    public void computeDensityEstimator() {
        this.hypervolume.computeHypervolumeContribution(this.archive.solutions(), this.archive.solutions());
    }
}

