/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.densityestimator.impl.KnnDensityEstimator;

public class KNNDistanceArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> knnDistanceComparator;
    private DensityEstimator<S> knnDensityEstimator;

    public KNNDistanceArchive(int maxSize, int k) {
        super(maxSize);
        this.knnDensityEstimator = new KnnDensityEstimator(k);
        this.knnDistanceComparator = Comparator.comparing(this.knnDensityEstimator::getValue).reversed();
    }

    @Override
    public void prune() {
        if (this.solutions().size() > this.maximumSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.solutions(), this.knnDistanceComparator);
            this.solutions().remove(worst);
        }
    }

    @Override
    public Comparator<S> comparator() {
        return this.knnDistanceComparator;
    }

    @Override
    public void computeDensityEstimator() {
        this.knnDensityEstimator.compute(this.solutions());
    }
}

