/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;

public class ObjectiveComparator<S extends Solution<?>>
implements Comparator<S>,
Serializable {
    private final int objectiveId;
    private final Ordering order;

    public ObjectiveComparator(int objectiveId) {
        this.objectiveId = objectiveId;
        this.order = Ordering.ASCENDING;
    }

    public ObjectiveComparator(int objectiveId, Ordering order) {
        this.objectiveId = objectiveId;
        this.order = order;
    }

    @Override
    public int compare(S solution1, S solution2) {
        Check.notNull(solution1);
        Check.notNull(solution2);
        Check.that(solution1.objectives().length > this.objectiveId, "The solution1 has " + solution1.objectives().length + " objectives and the objective to sort is" + this.objectiveId);
        Check.that(solution2.objectives().length > this.objectiveId, "The solution2 has " + solution2.objectives().length + " objectives and the objective to sort is" + this.objectiveId);
        double objective1 = solution1.objectives()[this.objectiveId];
        double objective2 = solution2.objectives()[this.objectiveId];
        int result = this.order == Ordering.ASCENDING ? Double.compare(objective1, objective2) : Double.compare(objective2, objective1);
        return result;
    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }
}

