/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.densityestimator.impl.CrowdingDistanceDensityEstimator;
import org.uma.jmetal.util.ranking.Ranking;
import org.uma.jmetal.util.ranking.impl.FastNonDominatedSortRanking;

public class RankingAndCrowdingDistanceComparator<S extends Solution<?>>
implements Comparator<S>,
Serializable {
    private final Comparator<S> rankComparator = Comparator.comparing(ranking::getRank);
    private final Comparator<S> crowdingDistanceComparator;

    public RankingAndCrowdingDistanceComparator(Ranking<S> ranking) {
        CrowdingDistanceDensityEstimator crowdingDistanceDensityEstimator = new CrowdingDistanceDensityEstimator();
        this.crowdingDistanceComparator = crowdingDistanceDensityEstimator.getComparator();
    }

    public RankingAndCrowdingDistanceComparator() {
        this(new FastNonDominatedSortRanking());
    }

    @Override
    public int compare(S solution1, S solution2) {
        int result = this.rankComparator.compare(solution1, solution2);
        if (result == 0) {
            result = this.crowdingDistanceComparator.compare(solution1, solution2);
        }
        return result;
    }
}

