/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.densityestimator.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.errorchecking.Check;

public class CrowdingDistanceDensityEstimator<S extends Solution<?>>
implements DensityEstimator<S> {
    private final String attributeId = this.getClass().getName();

    @Override
    public void compute(List<S> solutionList) {
        int size = solutionList.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ((Solution)solutionList.get(0)).attributes().put(this.attributeId, Double.POSITIVE_INFINITY);
            return;
        }
        if (size == 2) {
            ((Solution)solutionList.get(0)).attributes().put(this.attributeId, Double.POSITIVE_INFINITY);
            ((Solution)solutionList.get(1)).attributes().put(this.attributeId, Double.POSITIVE_INFINITY);
            return;
        }
        ArrayList<S> front = new ArrayList<S>(solutionList);
        for (int i = 0; i < size; ++i) {
            ((Solution)front.get(i)).attributes().put(this.attributeId, 0.0);
        }
        int numberOfObjectives = ((Solution)solutionList.get(0)).objectives().length;
        for (int i = 0; i < numberOfObjectives; ++i) {
            front.sort(new ObjectiveComparator(i));
            double minObjective = ((Solution)front.get(0)).objectives()[i];
            double maxObjective = ((Solution)front.get(front.size() - 1)).objectives()[i];
            if (minObjective == maxObjective) continue;
            ((Solution)front.get(0)).attributes().put(this.attributeId, Double.POSITIVE_INFINITY);
            ((Solution)front.get(size - 1)).attributes().put(this.attributeId, Double.POSITIVE_INFINITY);
            for (int j = 1; j < size - 1; ++j) {
                double distance = ((Solution)front.get(j + 1)).objectives()[i] - ((Solution)front.get(j - 1)).objectives()[i];
                distance /= maxObjective - minObjective;
                ((Solution)front.get(j)).attributes().put(this.attributeId, distance += ((Double)((Solution)front.get(j)).attributes().get(this.attributeId)).doubleValue());
            }
        }
    }

    @Override
    public Double getValue(S solution) {
        Check.notNull(solution);
        Double result = 0.0;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Double)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Comparator<S> getComparator() {
        return Comparator.comparing(this::getValue).reversed();
    }
}

