/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.measure.impl;

import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.PullMeasure;
import org.uma.jmetal.util.measure.PushMeasure;
import org.uma.jmetal.util.measure.impl.SimplePushMeasure;

public class CountingMeasure
extends SimplePushMeasure<Long>
implements PullMeasure<Long>,
PushMeasure<Long> {
    long count = 0L;
    private final Map<PushMeasure<?>, MeasureListener<?>> linkedMeasures = new WeakHashMap();

    public CountingMeasure(String name, String description, long initialCount) {
        super(name, description);
        this.count = initialCount;
    }

    public CountingMeasure(String name, String description) {
        this(name, description, 0L);
    }

    public CountingMeasure(long initialCount) {
        this("Counter", "Generic counting measure which should be renamed/redescribed when it is used to count specific occurrences.", initialCount);
    }

    public CountingMeasure() {
        this(0L);
    }

    public synchronized void increment() {
        this.increment(1L);
    }

    public synchronized void increment(long amount) {
        if (amount != 0L) {
            this.count += amount;
            this.push(this.count);
        }
    }

    @Override
    public synchronized Long get() {
        return this.count;
    }

    public <T> void link(PushMeasure<T> measure) {
        if (!this.linkedMeasures.containsKey(measure)) {
            MeasureListener listener = new MeasureListener<T>(){

                @Override
                public void measureGenerated(T value) {
                    CountingMeasure.this.increment();
                }
            };
            measure.register(listener);
            this.linkedMeasures.put(measure, listener);
        }
    }

    public <T> void unlink(PushMeasure<T> measure) {
        MeasureListener<?> listener = this.linkedMeasures.get(measure);
        if (listener != null) {
            measure.unregister(listener);
            this.linkedMeasures.remove(measure);
        }
    }

    protected void finalize() throws Throwable {
        LinkedList remainingMeasures = new LinkedList(this.linkedMeasures.keySet());
        for (PushMeasure pushMeasure : remainingMeasures) {
            this.unlink(pushMeasure);
        }
        super.finalize();
    }

    public synchronized void reset() {
        this.reset(0L);
    }

    public synchronized void reset(long value) {
        this.increment(value - this.count);
    }
}

