/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.measure.impl;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.PullMeasure;
import org.uma.jmetal.util.measure.PushMeasure;
import org.uma.jmetal.util.measure.impl.SimplePullMeasure;
import org.uma.jmetal.util.measure.impl.SimplePushMeasure;

public class MeasureFactory {
    private final Logger log = Logger.getLogger(MeasureFactory.class.getName());

    public <Value> PullMeasure<Value> createPullFromPush(final PushMeasure<Value> push, Value initialValue) {
        final Object[] cache = new Object[]{initialValue};
        final MeasureListener listener = new MeasureListener<Value>(){

            @Override
            public void measureGenerated(Value value) {
                cache[0] = value;
            }
        };
        push.register(listener);
        return new PullMeasure<Value>(){

            @Override
            public String getName() {
                return push.getName();
            }

            @Override
            public String getDescription() {
                return push.getDescription();
            }

            @Override
            public Value get() {
                return cache[0];
            }

            protected void finalize() throws Throwable {
                push.unregister(listener);
                super.finalize();
            }
        };
    }

    public <Value> PushMeasure<Value> createPushFromPull(PullMeasure<Value> pull, final long period) {
        SimplePushMeasure push = new SimplePushMeasure(pull.getName(), pull.getDescription());
        final WeakReference<PullMeasure<Value>> weakPull = new WeakReference<PullMeasure<Value>>(pull);
        final WeakReference weakPush = new WeakReference(push);
        final Value initialValue = pull.get();
        Thread thread = new Thread(new Runnable(){
            private Value lastValue;
            {
                this.lastValue = initialValue;
            }

            @Override
            public void run() {
                boolean isThreadNeeded = true;
                long alreadyConsumed = 0L;
                while (isThreadNeeded) {
                    if (alreadyConsumed > period) {
                        long realConsumption = alreadyConsumed;
                        long missed = alreadyConsumed / period;
                        MeasureFactory.this.log.warning("Too much time consumed in the last measuring (" + realConsumption + ">" + period + "), ignore the " + missed + " pushes missed and consider it has consumed " + (alreadyConsumed %= period));
                    }
                    try {
                        Thread.sleep(period - alreadyConsumed);
                    }
                    catch (InterruptedException e) {
                        throw new JMetalException("Error in run method: ", e);
                    }
                    long measureStart = System.currentTimeMillis();
                    PullMeasure pull = (PullMeasure)weakPull.get();
                    SimplePushMeasure push = (SimplePushMeasure)weakPush.get();
                    if (pull == null || push == null) {
                        isThreadNeeded = false;
                    } else {
                        Object value = pull.get();
                        if (!(value == this.lastValue || value != null && value.equals(this.lastValue))) {
                            this.lastValue = value;
                            push.push(value);
                        }
                    }
                    pull = null;
                    push = null;
                    long measureEnd = System.currentTimeMillis();
                    alreadyConsumed = measureEnd - measureStart;
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        return push;
    }

    public Map<String, PullMeasure<?>> createPullsFromGetters(final Object object) {
        HashMap measures = new HashMap();
        Class<?> clazz = object.getClass();
        for (final Method method : clazz.getMethods()) {
            if (method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE) || method.getName().equals("getClass") || !method.getName().matches("get[^a-z].*")) continue;
            String key = method.getName().substring(3);
            measures.put(key, new SimplePullMeasure<Object>(key){

                @Override
                public Object get() {
                    try {
                        return method.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return measures;
    }

    public Map<String, PullMeasure<?>> createPullsFromFields(final Object object) {
        HashMap measures = new HashMap();
        Class<?> clazz = object.getClass();
        for (final Field field : clazz.getFields()) {
            String key = field.getName();
            measures.put(key, new SimplePullMeasure<Object>(key){

                @Override
                public Object get() {
                    try {
                        return field.get(object);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new RuntimeException();
                    }
                }
            });
        }
        return measures;
    }
}

