/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.neighborhood.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.neighborhood.Neighborhood;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class AdaptiveRandomNeighborhood<S>
implements Neighborhood<S> {
    private int solutionListSize;
    private int numberOfRandomNeighbours;
    private List<List<Integer>> neighbours;
    private BoundedRandomGenerator<Integer> randomGenerator;

    public AdaptiveRandomNeighborhood(int solutionListSize, int numberOfRandomNeighbours) {
        this(solutionListSize, numberOfRandomNeighbours, (a2, b) -> JMetalRandom.getInstance().nextInt((int)a2, (int)b));
    }

    public AdaptiveRandomNeighborhood(int solutionListSize, int numberOfRandomNeighbours, BoundedRandomGenerator<Integer> randomGenerator) {
        if (numberOfRandomNeighbours < 0) {
            throw new JMetalException("The number of neighbors is negative: " + numberOfRandomNeighbours);
        }
        if (solutionListSize <= numberOfRandomNeighbours) {
            throw new JMetalException("The population size: " + solutionListSize + " is less or equal to the number of requested neighbors: " + numberOfRandomNeighbours);
        }
        this.solutionListSize = solutionListSize;
        this.numberOfRandomNeighbours = numberOfRandomNeighbours;
        this.randomGenerator = randomGenerator;
        this.createNeighborhoods();
        this.addRandomNeighbors();
    }

    private void createNeighborhoods() {
        this.neighbours = new ArrayList<List<Integer>>(this.solutionListSize);
        for (int i = 0; i < this.solutionListSize; ++i) {
            this.neighbours.add(new ArrayList());
            this.neighbours.get(i).add(i);
        }
    }

    private void addRandomNeighbors() {
        for (int i = 0; i < this.solutionListSize; ++i) {
            while (this.neighbours.get(i).size() <= this.numberOfRandomNeighbours) {
                int random = this.randomGenerator.getRandomValue(0, this.solutionListSize - 1);
                this.neighbours.get(i).add(random);
            }
        }
    }

    private List<S> getIthNeighborhood(List<S> solutionList, int index) {
        ArrayList<S> neighborhood = new ArrayList<S>();
        for (int i = 0; i < this.numberOfRandomNeighbours + 1; ++i) {
            int neighboursIndex = this.neighbours.get(index).get(i);
            neighborhood.add(solutionList.get(neighboursIndex));
        }
        return neighborhood;
    }

    public void recompute() {
        this.createNeighborhoods();
        this.addRandomNeighbors();
    }

    @Override
    public List<S> getNeighbors(List<S> solutionList, int solutionIndex) {
        if (solutionList == null) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.size() != this.solutionListSize) {
            throw new JMetalException("The solution list size: " + solutionList.size() + " is different to the value: " + this.solutionListSize);
        }
        if (solutionIndex < 0) {
            throw new JMetalException("The solution position value is negative: " + solutionIndex);
        }
        if (solutionIndex >= solutionList.size()) {
            throw new JMetalException("The solution position value: " + solutionIndex + " is equal or greater than the solution list size: " + solutionList.size());
        }
        return this.getIthNeighborhood(solutionList, solutionIndex);
    }
}

