/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observable.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;

public class DefaultObservable<D>
implements Observable<D> {
    private Set<Observer<D>> observers = new HashSet<Observer<D>>();
    private boolean dataHasChanged = false;
    private String name;

    public DefaultObservable(String name) {
        this.name = name;
    }

    @Override
    public synchronized void register(Observer<D> observer) {
        this.observers.add(observer);
        JMetalLogger.logger.info("DefaultObservable " + this.name + ": " + observer + " registered");
    }

    @Override
    public synchronized void unregister(Observer<D> observer) {
        this.observers.remove(observer);
    }

    @Override
    public synchronized void notifyObservers(D data) {
        if (this.dataHasChanged) {
            this.observers.forEach(observer -> observer.update(this, data));
        }
        this.clearChanged();
    }

    @Override
    public synchronized int numberOfRegisteredObservers() {
        return this.observers.size();
    }

    @Override
    public synchronized void setChanged() {
        this.dataHasChanged = true;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.dataHasChanged;
    }

    @Override
    public synchronized void clearChanged() {
        this.dataHasChanged = false;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public Collection<Observer<D>> getObservers() {
        return this.observers;
    }
}

