/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observer.impl;

import java.util.Map;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;

public class FitnessObserver
implements Observer<Map<String, Object>> {
    private Integer frequency;

    public FitnessObserver(Integer frequency) {
        this.frequency = frequency;
    }

    public FitnessObserver() {
        this(1);
    }

    @Override
    public void update(Observable<Map<String, Object>> observable, Map<String, Object> data) {
        Solution solution = (Solution)data.get("BEST_SOLUTION");
        Integer evaluations = (Integer)data.get("EVALUATIONS");
        if (solution != null && evaluations != null) {
            if (evaluations % this.frequency == 0) {
                StringBuilder objectiveValues = new StringBuilder();
                double[] dArray = solution.objectives();
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double objective = dArray[i];
                    objectiveValues.append(objective).append(" ");
                }
                JMetalLogger.logger.info("Evaluations: " + evaluations + ". Fitness: " + objectiveValues);
            }
        } else {
            JMetalLogger.logger.warning(this.getClass().getName() + ": The algorithm has not registered yet any info related to the EVALUATIONS and BEST_SOLUTION keys");
        }
    }

    public String getName() {
        return "Print objectives observer";
    }

    public String toString() {
        return this.getName();
    }
}

