/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observer.impl;

import java.util.List;
import java.util.Map;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.chartcontainer.ChartForDynamicProblemsContainer;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;

public class RunTimeForDynamicProblemsChartObserver<S extends Solution<?>>
implements Observer<Map<String, Object>> {
    private ChartForDynamicProblemsContainer<S> chart;
    private Integer evaluations;

    public RunTimeForDynamicProblemsChartObserver(String legend, int delay) {
        this.chart = new ChartForDynamicProblemsContainer(legend, delay);
        this.chart.setFrontChart(0, 1);
        ((XYStyler)this.chart.getFrontChart().getStyler()).setLegendPosition(Styler.LegendPosition.InsideNE);
        this.chart.initChart();
    }

    public void setReferencePointList(List<List<Double>> referencePointList) {
        this.chart.setReferencePoint(referencePointList);
    }

    @Override
    public void update(Observable<Map<String, Object>> observable, Map<String, Object> data) {
        this.evaluations = (Integer)data.get("EVALUATIONS");
        List population = (List)data.get("POPULATION");
        if (this.evaluations != null && population != null) {
            if (this.chart != null) {
                this.chart.getFrontChart().setTitle("Evaluation: " + this.evaluations);
                this.chart.updateFrontCharts(population);
                this.chart.refreshCharts();
            }
        } else {
            JMetalLogger.logger.warning(this.getClass().getName() + " : insufficient for generating real time information. Either EVALUATIONS or POPOULATION keys have not been registered yet by the algorithm");
        }
    }

    public ChartForDynamicProblemsContainer<S> getChart() {
        return this.chart;
    }

    public String getName() {
        return "Runtime chart observer";
    }

    public String toString() {
        return this.getName();
    }
}

