/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.comparator;

import java.util.Comparator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.point.Point;

public class PointDimensionComparator
implements Comparator<Point> {
    private final int index;

    public PointDimensionComparator(int index) {
        Check.valueIsNotNegative(index);
        this.index = index;
    }

    @Override
    public int compare(Point pointOne, Point pointTwo) {
        Check.notNull(pointOne);
        Check.notNull(pointTwo);
        Check.that(this.index < pointOne.dimension(), "The index value " + this.index + " is out of range (0,  " + (pointOne.dimension() - 1) + ")");
        Check.that(this.index < pointTwo.dimension(), "The index value " + this.index + " is out of range (0,  " + (pointTwo.dimension() - 1) + ")");
        return Double.compare(pointOne.value(this.index), pointTwo.value(this.index));
    }
}

