/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.sequencegenerator.impl;

import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;

public class IntegerBoundedSequenceGenerator
implements SequenceGenerator<Integer> {
    private int index;
    private int size;

    public IntegerBoundedSequenceGenerator(int size) {
        Check.that(size > 0, "Size " + size + " is not a positive number greater than zero");
        this.size = size;
        this.index = 0;
    }

    @Override
    public Integer getValue() {
        return this.index;
    }

    @Override
    public void generateNext() {
        ++this.index;
        if (this.index == this.size) {
            this.index = 0;
        }
    }

    @Override
    public int getSequenceLength() {
        return this.size;
    }
}

