/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds;

import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.NonDominatedSortingFactory;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.DominanceHelper;

public final class CornerSort {
    private static final NonDominatedSortingFactory INSTANCE = (n, n2) -> new NonDominatedSorting(n, n2){

        @Override
        public String getName() {
            return "Corner Sort";
        }

        @Override
        protected void closeImpl() {
        }

        private int findBestPoint(double[][] dArray, int n, int n2, int n3, int n4) {
            int n5 = n2;
            double[] dArray2 = dArray[this.indices[n5]];
            double d = dArray2[n4];
            for (int i = n2 + 1; i < n3; ++i) {
                double[] dArray3 = dArray[this.indices[i]];
                double d2 = dArray3[n4];
                if (!(d > d2) && (d != d2 || !DominanceHelper.strictlyDominates(dArray3, dArray2, n))) continue;
                dArray2 = dArray3;
                n5 = i;
                d = d2;
            }
            return n5;
        }

        private int moveDominatedToTail(double[][] dArray, int n, int n2, int n3) {
            double[] dArray2 = dArray[this.indices[n2]];
            ++n2;
            while (n2 < n3) {
                int n4 = this.indices[n2];
                if (DominanceHelper.strictlyDominates(dArray2, dArray[n4], n)) {
                    this.indices[n2] = this.indices[--n3];
                    this.indices[n3] = n4;
                    continue;
                }
                ++n2;
            }
            return n3;
        }

        private int peelCurrentRank(double[][] dArray, int[] nArray, int n, int n2, int n3, int n4) {
            int n5 = n2;
            int n6 = n3;
            int n7 = 0;
            while (n5 < n6) {
                int n8 = this.findBestPoint(dArray, n, n5, n6, n7);
                int n9 = this.indices[n8];
                this.indices[n8] = this.indices[n5];
                this.indices[n5] = n9;
                nArray[n9] = n4;
                n6 = this.moveDominatedToTail(dArray, n, n5, n6);
                n5 = ++n2;
                n7 = (n7 + 1) % n;
            }
            return n6;
        }

        private void fillNonMeaningfulRanks(int[] nArray, int n, int n2, int n3) {
            int n4 = n3 + 1;
            for (int i = n; i < n2; ++i) {
                nArray[this.indices[i]] = n4;
            }
        }

        @Override
        protected void sortChecked(double[][] dArray, int[] nArray, int n) {
            int n2 = dArray.length;
            int n3 = dArray[0].length;
            ArrayHelper.fillIdentity(this.indices, n2);
            int n4 = 0;
            for (int i = 0; n4 < n2 && i <= n; ++i) {
                n4 = this.peelCurrentRank(dArray, nArray, n3, n4, n2, i);
            }
            this.fillNonMeaningfulRanks(nArray, n4, n2, n);
        }
    };

    private CornerSort() {
    }

    public static NonDominatedSortingFactory getInstance() {
        return INSTANCE;
    }
}

