/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds;

import java.util.Arrays;
import java.util.Objects;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;

public abstract class NonDominatedSorting
implements AutoCloseable {
    private boolean closeWasCalled = false;
    private final int maximumPoints;
    private final int maximumDimension;
    protected ArraySorter sorter;
    protected int[] indices;

    protected NonDominatedSorting(int n, int n2) {
        this.maximumPoints = n;
        this.maximumDimension = n2;
        this.sorter = new ArraySorter(n);
        this.indices = new int[n];
    }

    public abstract String getName();

    public final int getMaximumPoints() {
        return this.maximumPoints;
    }

    public final int getMaximumDimension() {
        return this.maximumDimension;
    }

    @Override
    public final void close() {
        if (this.closeWasCalled) {
            throw new IllegalStateException("close() has already been called");
        }
        this.closeWasCalled = true;
        this.closeImpl();
        this.sorter = null;
        this.indices = null;
    }

    public final void sort(double[][] dArray, int[] nArray) {
        this.sort(dArray, nArray, nArray == null ? 0 : nArray.length);
    }

    public final void sort(double[][] dArray, int[] nArray, int n) {
        this.requirePointsAreNonNull(dArray);
        Objects.requireNonNull(nArray, "The array of ranks must not be null");
        this.checkNumbersOfPoints(dArray.length, nArray.length);
        if (dArray.length == 0) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Maximal meaningful rank must be non-negative");
        }
        int n2 = this.checkAndGetDimension(dArray);
        if (n2 == 0) {
            Arrays.fill(nArray, 0);
        } else if (n2 == 1) {
            int n3;
            int n4 = dArray.length;
            ArrayHelper.fillIdentity(this.indices, n4);
            this.sorter.sort(dArray, this.indices, 0, n4, 0);
            double d = Double.NaN;
            int n5 = -1;
            for (n3 = 0; n5 <= n && n3 < n4; ++n3) {
                int n6 = this.indices[n3];
                double d2 = dArray[n6][0];
                if (d2 != d) {
                    d = d2;
                }
                nArray[n6] = ++n5;
            }
            while (n3 < n4) {
                nArray[this.indices[n3]] = n5;
                ++n3;
            }
        } else {
            this.sortChecked(dArray, nArray, n);
            this.filterMaximumMeaningfulRank(nArray, n);
        }
    }

    protected abstract void closeImpl();

    protected abstract void sortChecked(double[][] var1, int[] var2, int var3);

    private void requirePointsAreNonNull(double[][] dArray) {
        Objects.requireNonNull(dArray, "The array of points must not be null");
        for (double[] dArray2 : dArray) {
            Objects.requireNonNull(dArray2, "The points to be sorted must not be null");
            for (double d : dArray2) {
                if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                throw new IllegalArgumentException("Coordinates of points to be sorted must not be NaN or Inf");
            }
        }
    }

    private void filterMaximumMeaningfulRank(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            nArray[i] = n + 1;
        }
    }

    private int checkAndGetDimension(double[][] dArray) {
        int n = dArray[0].length;
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i].length == n) continue;
            throw new IllegalArgumentException("All points to be sorted must have equal dimension");
        }
        if (n > this.maximumDimension) {
            throw new IllegalArgumentException("The dimension of points to be sorted, " + n + ", must not exceed the maximum dimension, " + this.maximumDimension + ", which this instance of NonDominatedSorting can handle");
        }
        return n;
    }

    private void checkNumbersOfPoints(int n, int n2) {
        if (n > this.maximumPoints) {
            throw new IllegalArgumentException("The number of points to be sorted, " + n + ", must not exceed the maximum number of points, " + this.maximumPoints + ", which this instance of NonDominatedSorting can handle");
        }
        if (n != n2) {
            throw new IllegalArgumentException("The number of points, " + n + ", must coincide with the length of the array for ranks, which is " + n2);
        }
    }
}

