/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.fnds;

import java.util.Arrays;
import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.util.DominanceHelper;

public class OriginalVersion
extends NonDominatedSorting {
    private int[] queue;
    private int[] howManyIDominate;
    private int[] howManyDominateMe;
    private int[][] whoIDominate;

    public OriginalVersion(int n, int n2) {
        super(n, n2);
        this.queue = new int[n];
        this.howManyIDominate = new int[n];
        this.howManyDominateMe = new int[n];
        this.whoIDominate = new int[n][n - 1];
    }

    @Override
    public String getName() {
        return "Fast Non-Dominated Sorting (original version)";
    }

    @Override
    protected void closeImpl() {
        this.queue = null;
        this.howManyIDominate = null;
        this.howManyDominateMe = null;
        this.whoIDominate = null;
    }

    private void pushToDominateList(int n, int n2) {
        int n3 = n2;
        this.howManyDominateMe[n3] = this.howManyDominateMe[n3] + 1;
        int n4 = this.howManyIDominate[n];
        this.whoIDominate[n][n4] = n2;
        this.howManyIDominate[n] = ++n4;
    }

    private void comparePointWithOthers(int n, double[][] dArray, int n2, int n3) {
        double[] dArray2 = dArray[n];
        int n4 = dArray2.length;
        block4: for (int i = n2; i < n3; ++i) {
            int n5 = DominanceHelper.dominanceComparison(dArray2, dArray[i], n4);
            switch (n5) {
                case -1: {
                    this.pushToDominateList(n, i);
                    continue block4;
                }
                case 1: {
                    this.pushToDominateList(i, n);
                }
            }
        }
    }

    private void comparePoints(double[][] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.comparePointWithOthers(i, dArray, i + 1, n);
        }
    }

    private int enqueueZeroRanks(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.howManyDominateMe[i] != 0) continue;
            nArray[i] = 0;
            this.queue[n2] = i;
            ++n2;
        }
        return n2;
    }

    private int decreaseWhomIDominate(int n, int[] nArray, int n2, int n3) {
        int[] nArray2 = this.whoIDominate[n];
        int n4 = nArray[n] + 1;
        for (int i = this.howManyIDominate[n] - 1; i >= 0; --i) {
            int n5;
            int n6 = n5 = nArray2[i];
            this.howManyDominateMe[n6] = this.howManyDominateMe[n6] - 1;
            if (this.howManyDominateMe[n6] != 0) continue;
            nArray[n5] = n4;
            if (n4 >= n3) continue;
            this.queue[n2] = n5;
            ++n2;
        }
        return n2;
    }

    private void markNotRankedAsMeaningless(int n, int[] nArray, int n2) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != -1) continue;
            nArray[i] = n2 + 1;
        }
    }

    private void assignRanks(int[] nArray, int n, int n2) {
        int n3 = this.enqueueZeroRanks(n, nArray);
        for (int i = 0; n3 > i; ++i) {
            int n4 = this.queue[i];
            n3 = this.decreaseWhomIDominate(n4, nArray, n3, n2);
        }
        this.markNotRankedAsMeaningless(n, nArray, n2);
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2 = nArray.length;
        Arrays.fill(this.howManyDominateMe, 0);
        Arrays.fill(this.howManyIDominate, 0);
        this.comparePoints(dArray, n2);
        Arrays.fill(nArray, -1);
        this.assignRanks(nArray, n2, n);
    }
}

