/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.jfb.hybrid;

import java.util.Arrays;
import ru.ifmo.nds.jfb.HybridAlgorithmWrapper;
import ru.ifmo.nds.jfb.JFBBase;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;
import ru.ifmo.nds.util.DominanceHelper;

public final class ENS
extends HybridAlgorithmWrapper {
    private final int threshold3D;
    private final int thresholdAll;

    public ENS(int n, int n2) {
        this.threshold3D = n;
        this.thresholdAll = n2;
    }

    @Override
    public boolean supportsMultipleThreads() {
        return true;
    }

    @Override
    public String getName() {
        return "ENS (threshold 3D = " + this.threshold3D + ", threshold all = " + this.thresholdAll + ")";
    }

    @Override
    public HybridAlgorithmWrapper.Instance create(int[] nArray, int[] nArray2, double[][] dArray, double[][] dArray2) {
        return new Instance(nArray, nArray2, dArray, this.threshold3D, this.thresholdAll);
    }

    private static final class Instance
    extends HybridAlgorithmWrapper.Instance {
        private static final int STORAGE_MULTIPLE = 5;
        private final int[] space;
        private final int[] ranks;
        private final int[] indices;
        private final double[][] points;
        private final double[][] exPoints;
        private final int threshold3D;
        private final int thresholdAll;

        private Instance(int[] nArray, int[] nArray2, double[][] dArray, int n, int n2) {
            this.ranks = nArray;
            this.indices = nArray2;
            this.points = dArray;
            this.exPoints = new double[dArray.length][];
            this.space = new int[5 * nArray2.length];
            this.threshold3D = n;
            this.thresholdAll = n2;
        }

        private boolean notHookCondition(int n, int n2) {
            switch (n2) {
                case 1: {
                    return true;
                }
                case 2: {
                    return n >= this.threshold3D;
                }
            }
            return n >= this.thresholdAll;
        }

        private boolean checkIfDominatesA(int n, int n2, int n3) {
            int n4 = this.space[n];
            if (this.ranks[n3] > n4) {
                return true;
            }
            int n5 = this.space[n + 2];
            double[] dArray = this.points[n3];
            while (n5 != -1) {
                int n6 = this.space[n5];
                if (DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.points[n6], dArray, n2)) {
                    this.ranks[n3] = 1 + n4;
                    return true;
                }
                n5 = this.space[n5 + 1];
            }
            return false;
        }

        private void initNewSliceA(int n, int n2, int n3, int n4, int n5) {
            this.space[n2] = n4;
            this.space[n2 + 1] = n3;
            this.space[n2 + 2] = n5;
            if (n != -1) {
                this.space[n + 1] = n2;
            }
        }

        @Override
        public int helperAHook(int n, int n2, int n3, int n4) {
            if (this.notHookCondition(n2 - n, n3)) {
                return -1;
            }
            int n5 = n * 5;
            int n6 = n5 + 3 * (n2 - n);
            int n7 = n5 - 3;
            int n8 = -1;
            int n9 = n2;
            int n10 = n6;
            for (int i = n; i < n2; ++i) {
                int n11;
                int n12 = this.indices[i];
                if (n8 == -1 || this.checkIfDominatesA(n8, n3, n12)) {
                    if (this.ranks[n12] <= n4) {
                        this.initNewSliceA(-1, n7 += 3, n8, this.ranks[n12], n10);
                        this.space[n10] = n12;
                        this.space[n10 + 1] = -1;
                        n8 = n7;
                        n10 += 2;
                        continue;
                    }
                    if (n9 <= i) continue;
                    n9 = i;
                    continue;
                }
                int n13 = n8;
                while ((n11 = this.space[n13 + 1]) != -1 && !this.checkIfDominatesA(n11, n3, n12)) {
                    n13 = n11;
                }
                this.space[n10] = n12;
                int n14 = this.ranks[n12];
                if (n14 == this.space[n13]) {
                    this.space[n10 + 1] = this.space[n13 + 2];
                    this.space[n13 + 2] = n10;
                } else {
                    this.initNewSliceA(n13, n7 += 3, n11, n14, n10);
                    this.space[n10 + 1] = -1;
                }
                n10 += 2;
            }
            return JFBBase.kickOutOverflowedRanks(this.indices, this.ranks, n4, n9, n2);
        }

        private boolean checkWhetherDominates(int n, int n2, double[] dArray, int n3) {
            while (n2 > n) {
                if (!DominanceHelper.strictlyDominatesAssumingLexicographicallySmaller(this.exPoints[--n2], dArray, n3)) continue;
                return true;
            }
            return false;
        }

        private int helperBSingleRank(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            int n9;
            int n10 = n5;
            int n11 = n8 - n2;
            for (n9 = n2; n9 < n3; ++n9) {
                this.exPoints[n11 + n9] = this.points[this.indices[n9]];
            }
            int n12 = n2;
            for (n9 = n4; n9 < n5; ++n9) {
                int n13 = this.indices[n9];
                if (this.ranks[n13] > n || !this.checkWhetherDominates(n8, (n12 = ArrayHelper.findWhereNotSmaller(this.indices, n12, n3, n13)) + n11, this.points[n13], n6)) continue;
                this.ranks[n13] = n + 1;
                if (n10 <= n9) continue;
                n10 = n9;
            }
            Arrays.fill((Object[])this.exPoints, n8, n8 + n3 - n2, null);
            return n == n7 && n10 < n5 ? JFBBase.kickOutOverflowedRanks(this.indices, this.ranks, n7, n10, n5) : n5;
        }

        private int transplantRanksAndCheckWhetherAllAreSame(int n, int n2, int n3, int n4) {
            int n5 = -this.ranks[this.indices[n]];
            boolean bl = true;
            this.space[n3] = n5;
            this.space[n4] = n3;
            int n6 = n3;
            int n7 = n4;
            for (int i = n + 1; i < n2; ++i) {
                int n8 = -this.ranks[this.indices[i]];
                bl &= n5 == n8;
                this.space[++n6] = n8;
                this.space[++n7] = n6;
            }
            return bl ? n5 : 1;
        }

        private static int distributePointsBetweenSlices(int[] nArray, int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            int n7;
            int n8 = n3 - 2;
            int n9 = 0;
            int n10 = 1;
            int n11 = n - 1;
            for (n7 = n; n7 < n2; ++n7) {
                n6 = nArray[n7];
                n5 = nArray[n6];
                if (n10 != n5) {
                    n10 = n5;
                    if (n8 >= n3) {
                        nArray[n8] = n9;
                        n9 = 0;
                    }
                    nArray[++n11] = n5;
                    n8 += 2;
                }
                ++n9;
                nArray[n6] = n8;
            }
            nArray[n8] = n9;
            n6 = n4;
            for (n7 = n3; n7 <= n8; n7 += 2) {
                n5 = nArray[n7];
                nArray[n7] = n6;
                nArray[n7 + 1] = n6;
                n6 += n5;
            }
            return n8;
        }

        private int findRankInSlices(int n, int n2, int n3, int n4, int n5) {
            int n6 = n2;
            int n7 = (n6 - n >>> 1) + n5;
            int n8 = this.ranks[n3];
            double[] dArray = this.points[n3];
            while (n6 >= n) {
                int n9;
                int n10 = this.space[n6];
                int n11 = this.space[n6 + 1];
                if (n10 < n11 && (n9 = -this.space[n7]) >= n8) {
                    if (!this.checkWhetherDominates(n10, n11, dArray, n4)) break;
                    n8 = n9 + 1;
                }
                n6 -= 2;
                --n7;
            }
            this.ranks[n3] = n8;
            return this.ranks[n3];
        }

        @Override
        public int helperBHook(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            int n8 = n2 - n;
            if (this.notHookCondition(n8 + n4 - n3, n5)) {
                return -1;
            }
            int n9 = n6 * 5;
            int n10 = n9 + n8;
            int n11 = n10 + n8;
            int n12 = this.transplantRanksAndCheckWhetherAllAreSame(n, n2, n10, n9);
            if (n12 != 1) {
                return this.helperBSingleRank(-n12, n, n2, n3, n4, n5, n7, n6);
            }
            ArraySorter.sortIndicesByValues(this.space, this.space, n9, n9 + n8);
            int n13 = Instance.distributePointsBetweenSlices(this.space, n9, n9 + n8, n11, n6);
            int n14 = n4;
            int n15 = n;
            int n16 = n10;
            for (int i = n3; i < n4; ++i) {
                int n17;
                int n18;
                int n19 = this.indices[i];
                while (n15 < n2 && (n18 = this.indices[n15]) < n19) {
                    n17 = this.space[n16] + 1;
                    int n20 = this.space[n17];
                    this.exPoints[n20] = this.points[n18];
                    this.space[n17] = n20 + 1;
                    ++n15;
                    ++n16;
                }
                n17 = this.findRankInSlices(n11, n13, n19, n5, n9);
                if (n17 <= n7 || n14 <= i) continue;
                n14 = i;
            }
            Arrays.fill((Object[])this.exPoints, n6, n6 + n2 - n, null);
            return JFBBase.kickOutOverflowedRanks(this.indices, this.ranks, n7, n14, n4);
        }
    }
}

