/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.jfb.hybrid;

import ru.ifmo.nds.jfb.HybridAlgorithmWrapper;
import ru.ifmo.nds.jfb.JFBBase;
import ru.ifmo.nds.ndt.Split;
import ru.ifmo.nds.ndt.SplitBuilder;
import ru.ifmo.nds.ndt.TreeRankNode;

public final class NDT
extends HybridAlgorithmWrapper {
    private final int threshold3D;
    private final int thresholdAll;
    private final int treeThreshold;

    public NDT(int n, int n2, int n3) {
        this.threshold3D = n;
        this.thresholdAll = n2;
        this.treeThreshold = n3;
    }

    @Override
    public boolean supportsMultipleThreads() {
        return true;
    }

    @Override
    public String getName() {
        return "NDT (threshold 3D = " + this.threshold3D + ", threshold all = " + this.thresholdAll + ", tree threshold = " + this.treeThreshold + ")";
    }

    @Override
    public HybridAlgorithmWrapper.Instance create(int[] nArray, int[] nArray2, double[][] dArray, double[][] dArray2) {
        return new Instance(nArray, nArray2, dArray, dArray2, this.threshold3D, this.thresholdAll, this.treeThreshold);
    }

    private static final class Instance
    extends HybridAlgorithmWrapper.Instance {
        private SplitBuilder splitBuilder;
        private double[][] points;
        private int[] indices;
        private int[] ranks;
        private double[][] localPoints;
        private final int threshold3D;
        private final int thresholdAll;
        private final int threshold;

        private Instance(int[] nArray, int[] nArray2, double[][] dArray, double[][] dArray2, int n, int n2, int n3) {
            this.ranks = nArray;
            this.indices = nArray2;
            this.points = dArray;
            this.threshold3D = n;
            this.thresholdAll = n2;
            this.threshold = n3;
            int n4 = nArray2.length;
            int n5 = dArray2.length;
            this.splitBuilder = new SplitBuilder(dArray2, n4, this.threshold);
            this.localPoints = new double[n4][n5];
        }

        private boolean notHookCondition(int n, int n2) {
            switch (n2) {
                case 1: {
                    return true;
                }
                case 2: {
                    return n >= this.threshold3D;
                }
            }
            return n >= this.thresholdAll;
        }

        @Override
        public int helperAHook(int n, int n2, int n3, int n4) {
            int n5;
            if (this.notHookCondition(n2 - n, n3)) {
                return -1;
            }
            Split split = this.splitBuilder.result(n, n2, this.indices, n3 + 1);
            for (n5 = n; n5 < n2; ++n5) {
                System.arraycopy(this.points[this.indices[n5]], 1, this.localPoints[n5], 1, n3);
            }
            n5 = n2;
            TreeRankNode treeRankNode = this.threshold == 1 ? TreeRankNode.EMPTY_1 : TreeRankNode.EMPTY;
            for (int i = n; i < n2; ++i) {
                int n6 = this.indices[i];
                this.ranks[n6] = treeRankNode.evaluateRank(this.localPoints[i], this.ranks[n6], split, n3);
                if (this.ranks[n6] <= n4) {
                    treeRankNode = treeRankNode.add(this.localPoints[i], this.ranks[n6], split, this.threshold);
                    continue;
                }
                if (n5 <= i) continue;
                n5 = i;
            }
            return JFBBase.kickOutOverflowedRanks(this.indices, this.ranks, n4, n5, n2);
        }

        @Override
        public int helperBHook(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            int n8;
            if (this.notHookCondition(n2 - n + n4 - n3, n5)) {
                return -1;
            }
            Split split = this.splitBuilder.result(n, n2, this.indices, n5 + 1);
            for (n8 = n; n8 < n2; ++n8) {
                System.arraycopy(this.points[this.indices[n8]], 1, this.localPoints[n8], 1, n5);
            }
            for (n8 = n3; n8 < n4; ++n8) {
                System.arraycopy(this.points[this.indices[n8]], 1, this.localPoints[n8], 1, n5);
            }
            n8 = n4;
            TreeRankNode treeRankNode = this.threshold == 1 ? TreeRankNode.EMPTY_1 : TreeRankNode.EMPTY;
            int n9 = n;
            for (int i = n3; i < n4; ++i) {
                int n10;
                int n11 = this.indices[i];
                while (n9 < n2 && (n10 = this.indices[n9]) < n11) {
                    treeRankNode = treeRankNode.add(this.localPoints[n9], this.ranks[n10], split, this.threshold);
                    ++n9;
                }
                this.ranks[n11] = treeRankNode.evaluateRank(this.localPoints[i], this.ranks[n11], split, n5);
                if (n8 <= i || this.ranks[n11] <= n7) continue;
                n8 = i;
            }
            return JFBBase.kickOutOverflowedRanks(this.indices, this.ranks, n7, n8, n4);
        }
    }
}

