/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.mnds;

import java.util.Arrays;
import java.util.BitSet;
import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;

public final class BitSetImplementation
extends NonDominatedSorting {
    private double[][] points;
    private int[] ranks;
    private BitSet[] pointBitSets;
    private BitSet scanBitSet;

    public BitSetImplementation(int n, int n2) {
        super(n, n2);
        this.points = new double[n][];
        this.ranks = new int[n];
        this.pointBitSets = new BitSet[n];
        this.scanBitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            this.pointBitSets[i] = new BitSet(i);
        }
    }

    @Override
    public String getName() {
        return "MNDS-BitSet";
    }

    @Override
    protected void closeImpl() {
        this.points = null;
        this.ranks = null;
        this.scanBitSet = null;
        this.pointBitSets = null;
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = nArray.length;
        int n5 = dArray[0].length;
        ArrayHelper.fillIdentity(this.indices, n4);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n4, n5);
        int n6 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
        for (n3 = 1; n3 < n6; ++n3) {
            this.pointBitSets[n3].set(0, n3);
        }
        for (n3 = 1; n3 < n5; ++n3) {
            ArrayHelper.fillIdentity(this.indices, n4);
            this.sorter.sortComparingByIndicesIfEqual(this.points, this.indices, 0, n6, n3);
            this.scanBitSet.clear();
            for (int i = 0; i < n6; ++i) {
                n2 = this.indices[i];
                this.pointBitSets[n2].and(this.scanBitSet);
                this.scanBitSet.set(n2);
            }
        }
        this.ranks[0] = 0;
        for (n3 = 1; n3 < n6; ++n3) {
            BitSet bitSet = this.pointBitSets[n3];
            n2 = 0;
            int n7 = bitSet.nextSetBit(0);
            while (n7 >= 0) {
                int n8 = this.ranks[n7];
                if (n8 >= n2) {
                    n2 = n8 + 1;
                }
                n7 = bitSet.nextSetBit(n7 + 1);
            }
            this.ranks[n3] = n2;
        }
        Arrays.fill((Object[])this.points, 0, n4, null);
        for (n3 = 0; n3 < n4; ++n3) {
            this.pointBitSets[n3].clear();
            nArray[n3] = this.ranks[nArray[n3]];
        }
    }
}

