/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.ndt;

import java.util.Arrays;
import ru.ifmo.nds.NonDominatedSorting;
import ru.ifmo.nds.ndt.Split;
import ru.ifmo.nds.ndt.SplitBuilder;
import ru.ifmo.nds.ndt.TreeNode;
import ru.ifmo.nds.util.ArrayHelper;
import ru.ifmo.nds.util.ArraySorter;

public class ENS_NDT
extends NonDominatedSorting {
    private SplitBuilder splitBuilder;
    private TreeNode[] levels;
    private int[] ranks;
    private double[][] transposedPoints;
    private double[][] points;
    private final int threshold;

    public ENS_NDT(int n, int n2, int n3) {
        super(n, n2);
        this.threshold = n3;
        this.levels = new TreeNode[n];
        this.ranks = new int[n];
        this.transposedPoints = new double[n2][];
        for (int i = 1; i < n2; ++i) {
            this.transposedPoints[i] = new double[n];
        }
        this.splitBuilder = new SplitBuilder(this.transposedPoints, n, n3);
        this.points = new double[n][];
    }

    @Override
    public String getName() {
        return "ENS-NDT (Objects, threshold = " + this.threshold + ")";
    }

    @Override
    protected void closeImpl() {
        this.splitBuilder = null;
        this.levels = null;
        this.ranks = null;
        this.transposedPoints = null;
        this.points = null;
    }

    @Override
    protected void sortChecked(double[][] dArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        ArrayHelper.fillIdentity(this.indices, n4);
        this.sorter.lexicographicalSort(dArray, this.indices, 0, n4, n5);
        int n6 = ArraySorter.retainUniquePoints(dArray, this.indices, this.points, nArray);
        Arrays.fill(this.ranks, 0, n6, 0);
        TreeNode treeNode = this.threshold == 1 ? TreeNode.EMPTY_1 : TreeNode.EMPTY;
        for (int i = 0; i < n6; ++i) {
            this.levels[i] = treeNode;
            for (n3 = 1; n3 < n5; ++n3) {
                this.transposedPoints[n3][i] = this.points[i][n3];
            }
        }
        Split split = this.splitBuilder.result(n6, n5);
        n3 = 1;
        this.levels[0] = this.levels[0].add(this.points[0], split, this.threshold);
        for (n2 = 1; n2 < n6; ++n2) {
            double[] dArray2 = this.points[n2];
            if (this.levels[0].dominates(dArray2, split)) {
                int n7;
                int n8 = 0;
                int n9 = n3;
                while (n9 - n8 > 1) {
                    n7 = n8 + n9 >>> 1;
                    if (this.levels[n7].dominates(dArray2, split)) {
                        n8 = n7;
                        continue;
                    }
                    n9 = n7;
                }
                this.ranks[n2] = n7 = n8 + 1;
                if (n7 > n) continue;
                this.levels[n7] = this.levels[n7].add(dArray2, split, this.threshold);
                if (n7 != n3) continue;
                ++n3;
                continue;
            }
            this.levels[0] = this.levels[0].add(dArray2, split, this.threshold);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = this.ranks[nArray[n2]];
            this.points[n2] = null;
        }
    }
}

