/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util;

import ru.ifmo.nds.util.RankQueryStructureInt;
import ru.ifmo.nds.util.veb.VanEmdeBoasSet;

public final class VanEmdeBoasRankQueryStructureInt
extends RankQueryStructureInt {
    private final EmptyOrSingleHandle smallHandle;

    public VanEmdeBoasRankQueryStructureInt(int n) {
        VanEmdeBoasRangeHandle vanEmdeBoasRangeHandle = new VanEmdeBoasRangeHandle(n);
        this.smallHandle = new EmptyOrSingleHandle(vanEmdeBoasRangeHandle);
    }

    @Override
    public String getName() {
        return "van Emde Boas Tree";
    }

    @Override
    public int maximumPoints() {
        return this.smallHandle.forTwoOrMore.values.length;
    }

    @Override
    public boolean supportsMultipleThreads() {
        return false;
    }

    @Override
    public RankQueryStructureInt.RangeHandle createHandle(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.smallHandle.clear();
        return this.smallHandle;
    }

    private static final class VanEmdeBoasRangeHandle
    extends RankQueryStructureInt.RangeHandle {
        private final VanEmdeBoasSet set;
        private final int[] values;

        VanEmdeBoasRangeHandle(int n) {
            int n2 = 0;
            while (n > 1 << n2) {
                ++n2;
            }
            this.set = VanEmdeBoasSet.create(n2);
            this.values = new int[n];
        }

        void clear() {
            this.set.clear();
        }

        @Override
        public RankQueryStructureInt.RangeHandle put(int n, int n2) {
            this.set.setEnsuringMonotonicity(n, 0, n2, this.values);
            return this;
        }

        @Override
        public int getMaximumWithKeyAtMost(int n, int n2) {
            return (n = this.set.prevInclusively(n)) == -1 ? -1 : this.values[n];
        }
    }

    private static final class EmptyOrSingleHandle
    extends RankQueryStructureInt.RangeHandle {
        private final VanEmdeBoasRangeHandle forTwoOrMore;
        private int key = Integer.MAX_VALUE;
        private int value = Integer.MIN_VALUE;

        private EmptyOrSingleHandle(VanEmdeBoasRangeHandle vanEmdeBoasRangeHandle) {
            this.forTwoOrMore = vanEmdeBoasRangeHandle;
        }

        @Override
        public RankQueryStructureInt.RangeHandle put(int n, int n2) {
            if (n < this.key) {
                if (n2 < this.value) {
                    this.forTwoOrMore.put(this.key, this.value);
                    return this.forTwoOrMore.put(n, n2);
                }
                this.key = n;
                this.value = n2;
            } else if (n == this.key) {
                if (this.value < n2) {
                    this.value = n2;
                }
            } else if (n2 > this.value) {
                this.forTwoOrMore.put(this.key, this.value);
                return this.forTwoOrMore.put(n, n2);
            }
            return this;
        }

        @Override
        public int getMaximumWithKeyAtMost(int n, int n2) {
            return n >= this.key ? this.value : -1;
        }

        void clear() {
            this.forTwoOrMore.clear();
            this.key = Integer.MAX_VALUE;
            this.value = Integer.MIN_VALUE;
        }
    }
}

