/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.nds.util.veb;

import java.util.Arrays;
import ru.ifmo.nds.util.veb.EmptyBitSet;
import ru.ifmo.nds.util.veb.VanEmdeBoasSet;

final class AnyAnyBitSet
extends VanEmdeBoasSet {
    private final int loBits;
    private final int loMask;
    private final VanEmdeBoasSet[] clusters;
    private final VanEmdeBoasSet summary;
    private final int limit;
    private final int clusterLimit;
    private int min;
    private int max;

    AnyAnyBitSet(int n) {
        this.min = this.limit = 1 << n;
        this.max = -1;
        this.loBits = n / 2;
        this.clusterLimit = 1 << this.loBits;
        this.loMask = (1 << this.loBits) - 1;
        this.clusters = new VanEmdeBoasSet[1 << n - this.loBits];
        Arrays.fill(this.clusters, EmptyBitSet.INSTANCE);
        this.summary = VanEmdeBoasSet.create(n - this.loBits);
    }

    @Override
    public boolean isEmpty() {
        return this.max == -1;
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public int max() {
        return this.max;
    }

    @Override
    public int prev(int n) {
        int n2;
        if (n <= this.min) {
            return -1;
        }
        if (n > this.max) {
            return this.max;
        }
        int n3 = this.hi(n);
        int n4 = this.clusters[n3].prev(n2 = this.lo(n));
        if (n4 == -1) {
            return (n3 = this.summary.prev(n3)) < 0 ? this.min : this.join(n3, this.clusters[n3].max());
        }
        return this.join(n3, n4);
    }

    @Override
    public int prevInclusively(int n) {
        int n2;
        if (n <= this.min) {
            return this.min | n - this.min >> 31;
        }
        if (n >= this.max) {
            return this.max;
        }
        int n3 = this.hi(n);
        int n4 = this.clusters[n3].prevInclusively(n2 = this.lo(n));
        if (n4 == -1) {
            return (n3 = this.summary.prev(n3)) < 0 ? this.min : this.join(n3, this.clusters[n3].max());
        }
        return this.join(n3, n4);
    }

    @Override
    public int next(int n) {
        int n2;
        if (n >= this.max) {
            return this.limit;
        }
        if (n < this.min) {
            return this.min;
        }
        int n3 = this.hi(n);
        int n4 = this.clusters[n3].next(n2 = this.lo(n));
        if (n4 >= this.clusterLimit) {
            return (n3 = this.summary.next(n3)) >= this.clusters.length ? this.max : this.join(n3, this.clusters[n3].min());
        }
        return this.join(n3, n4);
    }

    @Override
    public void add(int n) {
        if (this.max < 0) {
            this.min = this.max = n;
        } else if (this.min == this.max && n != this.min) {
            if (n < this.min) {
                this.min = n;
            } else {
                this.max = n;
            }
        } else if (n != this.min && n != this.max) {
            int n2;
            if (n < this.min) {
                n2 = this.min;
                this.min = n;
                n = n2;
            }
            if (n > this.max) {
                n2 = this.max;
                this.max = n;
                n = n2;
            }
            n2 = this.lo(n);
            int n3 = this.hi(n);
            VanEmdeBoasSet vanEmdeBoasSet = this.clusters[n3];
            if (vanEmdeBoasSet == EmptyBitSet.INSTANCE) {
                this.clusters[n3] = vanEmdeBoasSet = VanEmdeBoasSet.create(this.loBits);
            }
            if (vanEmdeBoasSet.isEmpty()) {
                this.summary.add(n3);
            }
            vanEmdeBoasSet.add(n2);
        }
    }

    @Override
    public void remove(int n) {
        if (n == this.min) {
            if (n == this.max) {
                this.min = this.limit;
                this.max = -1;
            } else {
                int n2 = this.next(this.min);
                if (n2 != this.max) {
                    this.remove(n2);
                }
                this.min = n2;
            }
        } else if (n == this.max) {
            int n3 = this.prev(this.max);
            if (n3 != this.min) {
                this.remove(n3);
            }
            this.max = n3;
        } else if (this.min < n && n < this.max) {
            int n4 = this.lo(n);
            int n5 = this.hi(n);
            VanEmdeBoasSet vanEmdeBoasSet = this.clusters[n5];
            vanEmdeBoasSet.remove(n4);
            if (vanEmdeBoasSet.isEmpty()) {
                this.summary.remove(n5);
            }
        }
    }

    @Override
    public void clear() {
        this.min = this.limit;
        this.max = -1;
        int n = this.summary.min();
        while (n < this.clusters.length) {
            this.clusters[n].clear();
            n = this.summary.next(n);
        }
        this.summary.clear();
    }

    private boolean cleanupMidMax(int n, int n2, int n3, int[] nArray) {
        if (!this.summary.isEmpty()) {
            int n4;
            int n5 = n4 = n == -1 ? this.summary.min() : this.summary.next(n);
            while (n4 < this.clusters.length) {
                VanEmdeBoasSet vanEmdeBoasSet = this.clusters[n4];
                vanEmdeBoasSet.cleanupUpwards(n2 + (n4 << this.loBits), n3, nArray);
                if (!vanEmdeBoasSet.isEmpty()) {
                    return false;
                }
                this.summary.remove(n4);
                n4 = this.summary.next(n4);
            }
        }
        return nArray[n2 + this.max] <= n3;
    }

    @Override
    public void setEnsuringMonotonicity(int n, int n2, int n3, int[] nArray) {
        if (this.min == this.max) {
            if (n < this.min) {
                nArray[n2 + n] = n3;
                this.min = n;
                if (nArray[n2 + this.max] <= n3) {
                    this.max = n;
                }
            } else if (n == this.min) {
                int n4 = n2 + n;
                if (nArray[n4] < n3) {
                    nArray[n4] = n3;
                }
            } else if (nArray[n2 + this.min] < n3) {
                nArray[n2 + n] = n3;
                this.max = n;
            }
        } else if (this.max == -1) {
            this.min = n;
            this.max = n;
            nArray[n2 + n] = n3;
        } else if (n < this.min) {
            nArray[n2 + n] = n3;
            int n5 = this.min;
            this.min = n;
            if (nArray[n2 + n5] > n3) {
                int n6 = this.hi(n5);
                int n7 = this.lo(n5);
                VanEmdeBoasSet vanEmdeBoasSet = this.clusters[n6];
                if (vanEmdeBoasSet == EmptyBitSet.INSTANCE) {
                    this.clusters[n6] = vanEmdeBoasSet = VanEmdeBoasSet.create(this.loBits);
                }
                vanEmdeBoasSet.add(n7);
                this.summary.add(n6);
            } else if (this.cleanupMidMax(-1, n2, n3, nArray)) {
                this.max = this.min;
            }
        } else if (n == this.min) {
            int n8 = n2 + n;
            if (nArray[n8] < n3) {
                nArray[n8] = n3;
                if (this.cleanupMidMax(-1, n2, n3, nArray)) {
                    this.max = this.min;
                }
            }
        } else if (this.max <= n) {
            if (nArray[n2 + this.max] < n3) {
                nArray[n2 + n] = n3;
                if (this.max != n) {
                    int n9 = this.max;
                    this.max = n;
                    this.add(n9);
                }
            }
        } else if (this.summary.isEmpty()) {
            if (nArray[n2 + this.min] < n3) {
                nArray[n2 + n] = n3;
                if (nArray[n2 + this.max] > n3) {
                    int n10 = this.hi(n);
                    int n11 = this.lo(n);
                    this.summary.add(n10);
                    VanEmdeBoasSet vanEmdeBoasSet = this.clusters[n10];
                    if (vanEmdeBoasSet == EmptyBitSet.INSTANCE) {
                        this.clusters[n10] = vanEmdeBoasSet = VanEmdeBoasSet.create(this.loBits);
                    }
                    vanEmdeBoasSet.add(n11);
                } else {
                    this.max = n;
                }
            }
        } else {
            int n12 = this.hi(n);
            int n13 = this.lo(n);
            VanEmdeBoasSet vanEmdeBoasSet = this.clusters[n12];
            if (vanEmdeBoasSet.min() > n13) {
                int n14;
                int n15 = this.summary.prev(n12);
                int n16 = n14 = n15 == -1 ? this.min : this.join(n15, this.clusters[n15].max());
                if (nArray[n2 + n14] >= n3) {
                    return;
                }
            } else {
                int n17 = vanEmdeBoasSet.prevInclusively(n13);
                if (nArray[n2 + (n12 << this.loBits) + n17] >= n3) {
                    return;
                }
            }
            if (vanEmdeBoasSet.isEmpty()) {
                if (vanEmdeBoasSet == EmptyBitSet.INSTANCE) {
                    this.clusters[n12] = vanEmdeBoasSet = VanEmdeBoasSet.create(this.loBits);
                }
                this.summary.add(n12);
            }
            vanEmdeBoasSet.setEnsuringMonotonicity(n & this.loMask, n2 + (n12 << this.loBits), n3, nArray);
            nArray[n2 + n] = n3;
            if (vanEmdeBoasSet.max() == n13 && this.cleanupMidMax(n12, n2, n3, nArray)) {
                this.max = n;
                vanEmdeBoasSet.remove(n13);
                if (vanEmdeBoasSet.isEmpty()) {
                    this.summary.remove(n12);
                }
            }
        }
    }

    @Override
    void cleanupUpwards(int n, int n2, int[] nArray) {
        if (nArray[n + this.max] <= n2) {
            this.clear();
        } else if (nArray[n + this.min] <= n2) {
            if (!this.summary.isEmpty()) {
                int n3 = this.summary.min();
                while (n3 < this.clusters.length) {
                    VanEmdeBoasSet vanEmdeBoasSet = this.clusters[n3];
                    vanEmdeBoasSet.cleanupUpwards(n + (n3 << this.loBits), n2, nArray);
                    if (!vanEmdeBoasSet.isEmpty()) {
                        int n4 = vanEmdeBoasSet.min();
                        this.min = n4 + (n3 << this.loBits);
                        vanEmdeBoasSet.remove(n4);
                        if (vanEmdeBoasSet.isEmpty()) {
                            this.summary.remove(n3);
                        }
                        return;
                    }
                    this.summary.remove(n3);
                    n3 = this.summary.next(n3);
                }
            }
            this.min = this.max;
        }
    }

    private int hi(int n) {
        return n >>> this.loBits;
    }

    private int lo(int n) {
        return n & this.loMask;
    }

    private int join(int n, int n2) {
        return n << this.loBits ^ n2;
    }
}

