/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class RandomSample {
    public static int[] drawSortedSample(int n, int N, Random r) throws IllegalArgumentException {
        if (n > (int)(0.2 * (double)N)) {
            return RandomSample.drawSortedDenseSample(n, N, r);
        }
        return RandomSample.drawSortedSparseSample(n, N, r);
    }

    public static int[] drawSortedDenseSample(int n, int N, Random r) throws IllegalArgumentException {
        if (n > N || n < 0 || N < 0) {
            throw new IllegalArgumentException("drawSortedDenseSample: cannot sample" + n + " points from " + N + " points.");
        }
        int[] vals = new int[n];
        double toBeSkipped = N - n;
        double toProcess = N;
        while (n > 1) {
            double rv = 1.0 - r.nextDouble();
            double p = toBeSkipped / toProcess;
            while (rv < p) {
                p = p * (toBeSkipped -= 1.0) / (toProcess -= 1.0);
            }
            vals[vals.length - n] = N - (int)toProcess;
            toProcess -= 1.0;
            --n;
        }
        if (vals.length > 0) {
            vals[vals.length - 1] = N - (int)toProcess + (int)(toProcess * r.nextDouble());
        }
        return vals;
    }

    public static int[] drawSortedSparseSample(int n, int N, Random r) throws IllegalArgumentException {
        if (n > N || n < 0 || N < 0) {
            throw new IllegalArgumentException("drawSortedSparseSample: cannot sample" + n + " points from " + N + " points.");
        }
        int[] unsorted = RandomSample.drawSparseSample(n, N, r);
        return RandomSample.radixSortOfPositiveIntegers(unsorted);
    }

    public static int[] radixSortOfPositiveIntegers(int[] a2) {
        int n = a2.length;
        int[] aa = new int[n];
        int[] counts = new int[257];
        int shiftRight = 24;
        for (int s = 0; s < 32; s = (int)((byte)(s + 8))) {
            int i;
            byte shiftLeft = (byte)(24 - s);
            Arrays.fill(counts, 0);
            for (i = 0; i < n; ++i) {
                int n2 = (a2[i] << shiftLeft >>> 24) + 1;
                counts[n2] = counts[n2] + 1;
            }
            for (i = 0; i < 255; ++i) {
                int n3 = i + 1;
                counts[n3] = counts[n3] + counts[i];
            }
            for (i = 0; i < n; ++i) {
                int n4 = a2[i] << shiftLeft >>> 24;
                int n5 = counts[n4];
                counts[n4] = n5 + 1;
                aa[n5] = a2[i];
            }
            int[] temp = a2;
            a2 = aa;
            aa = temp;
        }
        return a2;
    }

    public static int[] drawSparseSample(int n, int N, Random r) throws IllegalArgumentException {
        if (n > N || n < 0 || N < 0) {
            throw new IllegalArgumentException("drawSparseSample: cannot sample" + n + " points from " + N + " points.");
        }
        int[] vals = new int[n];
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(2 * n);
        int selected = 0;
        for (int i = N; i > N - n; --i) {
            Integer index_rand = r.nextInt(i);
            Integer iObj = i - 1;
            Integer stored_at_index_from_end = (Integer)map.remove(iObj);
            if (index_rand.equals(iObj)) {
                vals[selected++] = stored_at_index_from_end != null ? stored_at_index_from_end : iObj;
                continue;
            }
            Integer stored_at_index_rand = map.put(index_rand, stored_at_index_from_end != null ? stored_at_index_from_end : iObj);
            vals[selected++] = stored_at_index_rand != null ? stored_at_index_rand : index_rand;
        }
        return vals;
    }
}

