/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.FieldRef;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.VectorInstance;

public class VectorDictionary
implements Serializable {
    private static final long serialVersionUID = -5538024467333813123L;
    protected int m_numberOfVectors;
    protected List<FieldRef> m_vectorFields = new ArrayList<FieldRef>();
    protected Map<String, VectorInstance> m_vectorInstances = new HashMap<String, VectorInstance>();

    public static VectorDictionary getVectorDictionary(Element container, MiningSchema ms) throws Exception {
        Node vecNode;
        VectorDictionary vectDict = null;
        NodeList vecL = container.getElementsByTagName("VectorDictionary");
        if (vecL.getLength() > 0 && (vecNode = vecL.item(0)).getNodeType() == 1) {
            vectDict = new VectorDictionary((Element)vecNode, ms);
        }
        return vectDict;
    }

    public double[] incomingInstanceToVectorFieldVals(double[] incoming) throws Exception {
        double[] newInst = new double[this.m_vectorFields.size()];
        for (int i = 0; i < this.m_vectorFields.size(); ++i) {
            FieldRef fr = this.m_vectorFields.get(i);
            newInst[i] = fr.getResult(incoming);
        }
        return newInst;
    }

    public VectorDictionary(Element vectNode, MiningSchema ms) throws Exception {
        NodeList vecFieldsL = vectNode.getElementsByTagName("VectorFields");
        if (vecFieldsL.getLength() == 0) {
            throw new Exception("[VectorDictionary] there are no VectorFields defined!!");
        }
        Instances fullStructure = ms.getFieldsAsInstances();
        ArrayList<Attribute> fieldDefs = new ArrayList<Attribute>();
        for (int i = 0; i < fullStructure.numAttributes(); ++i) {
            fieldDefs.add(fullStructure.attribute(i));
        }
        Node fieldsNode = vecFieldsL.item(0);
        NodeList fieldRefsL = ((Element)fieldsNode).getElementsByTagName("FieldRef");
        for (int i = 0; i < fieldRefsL.getLength(); ++i) {
            Element fieldR = (Element)fieldRefsL.item(i);
            String fieldName = fieldR.getAttribute("field");
            Attribute a2 = fullStructure.attribute(fieldName);
            if (a2 == null) {
                throw new Exception("[VectorDictionary] can't find field '" + fieldName + "' in the mining schema/derived fields!");
            }
            FieldMetaInfo.Optype fieldOpt = a2.isNumeric() ? FieldMetaInfo.Optype.CONTINUOUS : FieldMetaInfo.Optype.CATEGORICAL;
            FieldRef fr = new FieldRef(fieldR, fieldOpt, fieldDefs);
            this.m_vectorFields.add(fr);
        }
        NodeList vecInstL = vectNode.getElementsByTagName("VectorInstance");
        if (vecInstL.getLength() == 0) {
            throw new Exception("[VectorDictionary] no VectorInstances defined!");
        }
        for (int i = 0; i < vecInstL.getLength(); ++i) {
            Element vecInstEl = (Element)vecInstL.item(i);
            VectorInstance temp = new VectorInstance(vecInstEl, this.m_vectorFields);
            String id = temp.getID();
            if (this.m_vectorInstances.get(id) != null) {
                throw new Exception("[VectorDictionary] : There is already a vector with ID " + id + " in the dictionary!");
            }
            this.m_vectorInstances.put(id, temp);
        }
    }

    public VectorInstance getVector(String ID2) {
        return this.m_vectorInstances.get(ID2);
    }
}

