/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextSupport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import weka.core.Attribute;
import weka.core.Copyright;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.PluginManager;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.WekaEnumeration;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.WekaPackageManager;
import weka.core.converters.FileSourcedConverter;
import weka.core.logging.Logger;
import weka.core.xml.KOML;
import weka.core.xml.XStream;
import weka.gui.AttributeSelectionPanel;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;
import weka.gui.HierarchyPropertyParser;
import weka.gui.LookAndFeel;
import weka.gui.WekaFileChooser;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanConnection;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.BeansProperties;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.FlowRunner;
import weka.gui.beans.KFIgnore;
import weka.gui.beans.KFStep;
import weka.gui.beans.Loader;
import weka.gui.beans.LogPanel;
import weka.gui.beans.MetaBean;
import weka.gui.beans.Note;
import weka.gui.beans.StartUpListener;
import weka.gui.beans.Startable;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;
import weka.gui.beans.xml.XMLBeans;
import weka.gui.visualize.PrintablePanel;

public class KnowledgeFlowApp
extends JPanel
implements PropertyChangeListener,
BeanCustomizer.ModifyListener {
    private static final long serialVersionUID = -7064906770289728431L;
    protected Map<String, String> m_pluginPerspectiveLookup = new HashMap<String, String>();
    protected Map<String, KFPerspective> m_perspectiveCache = new HashMap<String, KFPerspective>();
    private static Vector<Vector<?>> TOOLBARS = new Vector();
    FontMetrics m_fontM;
    protected static final int NONE = 0;
    protected static final int MOVING = 1;
    protected static final int CONNECTING = 2;
    protected static final int ADDING = 3;
    protected static final int SELECTING = 4;
    protected static final int PASTING = 5;
    private int m_mode = 0;
    protected static final String USERCOMPONENTS_XML_EXTENSION = ".xml";
    private Object m_toolBarBean;
    private final int m_gridSpacing = 40;
    protected int m_untitledCount = 1;
    private BeanLayout m_beanLayout = null;
    private int m_layoutZoom = 100;
    private boolean m_allowMultipleTabs = true;
    private final Vector<Object> m_userComponents = new Vector();
    private boolean m_firstUserComponentOpp = true;
    protected JButton m_pointerB;
    protected JButton m_saveB;
    protected JButton m_saveBB;
    protected JButton m_loadB;
    protected JButton m_stopB;
    protected JButton m_playB;
    protected JButton m_playBB;
    protected JButton m_helpB;
    protected JButton m_newB;
    protected JButton m_togglePerspectivesB;
    protected JButton m_templatesB;
    protected JButton m_groupB;
    protected JButton m_cutB;
    protected JButton m_copyB;
    protected JButton m_pasteB;
    protected JButton m_deleteB;
    protected JButton m_noteB;
    protected JButton m_selectAllB;
    protected JButton m_undoB;
    protected JButton m_zoomInB;
    protected JButton m_zoomOutB;
    protected JToggleButton m_snapToGridB;
    private BeanInstance m_editElement;
    private EventSetDescriptor m_sourceEventSetDescriptor;
    private int m_oldX;
    private int m_oldY;
    private int m_startX;
    private int m_startY;
    protected WekaFileChooser m_FileChooser = new WekaFileChooser(new File(System.getProperty("user.dir")));
    protected KFLogPanel m_logPanel = null;
    protected JToolBar m_perspectiveToolBar = new JToolBar(0);
    protected JPanel m_configAndPerspectives;
    protected boolean m_configAndPerspectivesVisible = true;
    private final ButtonGroup m_perspectiveGroup = new ButtonGroup();
    protected JPanel m_perspectiveHolder;
    protected List<KFPerspective> m_perspectives = new ArrayList<KFPerspective>();
    protected Thread m_perspectiveDataLoadThread = null;
    protected AttributeSelectionPanel m_perspectiveConfigurer;
    protected MainKFPerspective m_mainKFPerspective;
    protected BeanContextSupport m_bcSupport = new BeanContextSupport();
    public static final String FILE_EXTENSION = ".kf";
    public static final String FILE_EXTENSION_XML = ".kfml";
    protected FileFilter m_KfFilter = new ExtensionFileFilter(".kf", "Binary KnowledgeFlow configuration files (*.kf)");
    protected FileFilter m_KOMLFilter = new ExtensionFileFilter(".komlkf", "XML KnowledgeFlow configuration files (*.komlkf)");
    protected FileFilter m_XStreamFilter = new ExtensionFileFilter(".xstreamkf", "XML KnowledgeFlow configuration files (*.xstreamkf)");
    protected FileFilter m_XMLFilter = new ExtensionFileFilter(".kfml", "XML KnowledgeFlow layout files (*.kfml)");
    protected int m_ScrollBarIncrementLayout = 20;
    protected int m_ScrollBarIncrementComponents = 50;
    protected int m_FlowWidth = 2560;
    protected int m_FlowHeight = 1440;
    protected String m_PreferredExtension = ".kf";
    protected boolean m_UserComponentsInXML = false;
    protected Environment m_flowEnvironment = new Environment();
    protected JTree m_componentTree;
    protected DefaultMutableTreeNode m_userCompNode;
    protected StringBuffer m_pasteBuffer;
    private static KnowledgeFlowApp m_knowledgeFlow;
    private static Memory m_Memory;
    public static Vector<StartUpListener> s_startupListeners;
    private boolean m_showFileMenu = true;

    public static void addToPluginBeanProps(File beanPropsFile) throws Exception {
        BeansProperties.addToPluginBeanProps(beanPropsFile);
    }

    public static void removeFromPluginBeanProps(File beanPropsFile) throws Exception {
        BeansProperties.removeFromPluginBeanProps(beanPropsFile);
    }

    public static synchronized void loadProperties() {
        BeansProperties.loadProperties();
    }

    public static void reInitialize() {
        KnowledgeFlowApp.loadProperties();
        KnowledgeFlowApp.init();
    }

    private static void init() {
        Logger.log(Logger.Level.INFO, "[KnowledgeFlow] Initializing KF...");
        if (!XMLBeans.SUPPRESS_PROPERTY_WARNINGS.contains("visual.iconPath")) {
            XMLBeans.SUPPRESS_PROPERTY_WARNINGS.add("visual.iconPath");
        }
        if (!XMLBeans.SUPPRESS_PROPERTY_WARNINGS.contains("visual.animatedIconPath")) {
            XMLBeans.SUPPRESS_PROPERTY_WARNINGS.add("visual.animatedIconPath");
        }
        try {
            Vector newV;
            TOOLBARS = new Vector();
            TreeMap<Integer, Vector> wrapList = new TreeMap<Integer, Vector>();
            Properties GEOProps = GenericPropertiesCreator.getGlobalOutputProperties();
            if (GEOProps == null) {
                GenericPropertiesCreator creator = new GenericPropertiesCreator();
                if (creator.useDynamic()) {
                    creator.execute(false);
                    GEOProps = creator.getOutputProperties();
                } else {
                    GEOProps = Utils.readProperties("weka/gui/GenericObjectEditor.props");
                }
            }
            Enumeration<?> en = GEOProps.propertyNames();
            while (en.hasMoreElements()) {
                String geoKey = (String)en.nextElement();
                String beanCompName = BeansProperties.BEAN_PROPERTIES.getProperty(geoKey);
                if (beanCompName == null) continue;
                newV = new Vector();
                String toolBarNameAlias = BeansProperties.BEAN_PROPERTIES.getProperty(geoKey + ".alias");
                String toolBarName = toolBarNameAlias != null ? toolBarNameAlias : geoKey.substring(geoKey.lastIndexOf(46) + 1, geoKey.length());
                String order = BeansProperties.BEAN_PROPERTIES.getProperty(geoKey + ".order");
                Integer intOrder = order != null ? new Integer(order) : new Integer(0);
                newV.addElement(toolBarName);
                newV.addElement(beanCompName);
                String rootPackage = geoKey.substring(0, geoKey.lastIndexOf(46));
                newV.addElement(rootPackage);
                String wekaAlgs = GEOProps.getProperty(geoKey);
                Hashtable<String, String> roots = GenericObjectEditor.sortClassesByRoot(wekaAlgs);
                Hashtable<String, HierarchyPropertyParser> hpps = new Hashtable<String, HierarchyPropertyParser>();
                Enumeration<String> enm = roots.keys();
                while (enm.hasMoreElements()) {
                    String root = enm.nextElement();
                    String classes = roots.get(root);
                    HierarchyPropertyParser hpp = new HierarchyPropertyParser();
                    hpp.build(classes, ", ");
                    hpps.put(root, hpp);
                }
                newV.addElement(hpps);
                StringTokenizer st = new StringTokenizer(wekaAlgs, ", ");
                while (st.hasMoreTokens()) {
                    String current = st.nextToken().trim();
                    newV.addElement(current);
                }
                wrapList.put(intOrder, newV);
            }
            for (Integer key : wrapList.keySet()) {
                newV = (Vector)wrapList.get(key);
                if (newV == null) continue;
                TOOLBARS.addElement(newV);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the generic objecte editor. An example file is included with the Weka distribution.\nThis file should be named \"GenericObjectEditor.props\" and\nshould be placed either in your user home (which is set\nto \"" + System.getProperties().getProperty("user.home") + "\")\nor the directory that java was started from\n", "KnowledgeFlow", 0);
        }
        try {
            String standardToolBarNames = BeansProperties.BEAN_PROPERTIES.getProperty("weka.gui.beans.KnowledgeFlow.standardToolBars");
            StringTokenizer st = new StringTokenizer(standardToolBarNames, ", ");
            while (st.hasMoreTokens()) {
                String tempBarName = st.nextToken().trim();
                Vector<String> newV = new Vector<String>();
                newV.addElement(tempBarName);
                newV.addElement("null");
                String toolBarContents = BeansProperties.BEAN_PROPERTIES.getProperty("weka.gui.beans.KnowledgeFlow." + tempBarName);
                StringTokenizer st2 = new StringTokenizer(toolBarContents, ", ");
                while (st2.hasMoreTokens()) {
                    String tempBeanName = st2.nextToken().trim();
                    newV.addElement(tempBeanName);
                }
                TOOLBARS.addElement(newV);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "KnowledgeFlow", 0);
        }
    }

    public void setEnvironment(Environment env) {
        this.m_flowEnvironment = env;
        this.setEnvironment();
    }

    private void setEnvironment() {
        Vector<Object> beans = BeanInstance.getBeanInstances(this.m_mainKFPerspective.getCurrentTabIndex());
        for (int i = 0; i < beans.size(); ++i) {
            Object temp = ((BeanInstance)beans.elementAt(i)).getBean();
            if (!(temp instanceof EnvironmentHandler)) continue;
            ((EnvironmentHandler)temp).setEnvironment(this.m_flowEnvironment);
        }
    }

    public KnowledgeFlowApp(boolean showFileMenu) {
        if (BeansProperties.BEAN_PROPERTIES == null) {
            KnowledgeFlowApp.loadProperties();
            KnowledgeFlowApp.init();
        }
        this.m_showFileMenu = showFileMenu;
        JWindow temp = new JWindow();
        temp.setVisible(true);
        temp.getGraphics().setFont(new Font(null, 0, 9));
        this.m_fontM = temp.getGraphics().getFontMetrics();
        temp.setVisible(false);
        try {
            this.m_ScrollBarIncrementLayout = Integer.parseInt(BeansProperties.BEAN_PROPERTIES.getProperty("ScrollBarIncrementLayout", "" + this.m_ScrollBarIncrementLayout));
            this.m_ScrollBarIncrementComponents = Integer.parseInt(BeansProperties.BEAN_PROPERTIES.getProperty("ScrollBarIncrementComponents", "" + this.m_ScrollBarIncrementComponents));
            this.m_FlowWidth = Integer.parseInt(BeansProperties.BEAN_PROPERTIES.getProperty("FlowWidth", "" + this.m_FlowWidth));
            this.m_FlowHeight = Integer.parseInt(BeansProperties.BEAN_PROPERTIES.getProperty("FlowHeight", "" + this.m_FlowHeight));
            this.m_PreferredExtension = BeansProperties.BEAN_PROPERTIES.getProperty("PreferredExtension", this.m_PreferredExtension);
            this.m_UserComponentsInXML = Boolean.valueOf(BeansProperties.BEAN_PROPERTIES.getProperty("UserComponentsInXML", "" + this.m_UserComponentsInXML));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_KfFilter);
        if (KOML.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        if (XStream.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_XStreamFilter);
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        if (this.m_PreferredExtension.equals(FILE_EXTENSION_XML)) {
            this.m_FileChooser.setFileFilter(this.m_XMLFilter);
        } else if (KOML.isPresent() && this.m_PreferredExtension.equals(".komlkf")) {
            this.m_FileChooser.setFileFilter(this.m_KOMLFilter);
        } else if (XStream.isPresent() && this.m_PreferredExtension.equals(".xstreamkf")) {
            this.m_FileChooser.setFileFilter(this.m_XStreamFilter);
        } else {
            this.m_FileChooser.setFileFilter(this.m_KfFilter);
        }
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_bcSupport.setDesignTime(true);
        this.m_perspectiveHolder = new JPanel();
        this.m_perspectiveHolder.setLayout(new BorderLayout());
        this.m_mainKFPerspective = new MainKFPerspective();
        this.m_perspectives.add(this.m_mainKFPerspective);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_perspectiveHolder, "Center");
        this.m_perspectiveHolder.add((Component)this.m_mainKFPerspective, "Center");
        if (this.m_pluginPerspectiveLookup.size() > 0) {
            String titleM = this.m_mainKFPerspective.getPerspectiveTitle();
            Icon icon = this.m_mainKFPerspective.getPerspectiveIcon();
            JToggleButton tBut = new JToggleButton(titleM, icon, true);
            tBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KFPerspective current = (KFPerspective)((Object)KnowledgeFlowApp.this.m_perspectiveHolder.getComponent(0));
                    current.setActive(false);
                    KnowledgeFlowApp.this.m_perspectiveHolder.remove(0);
                    KnowledgeFlowApp.this.m_perspectiveHolder.add((Component)((JComponent)((Object)KnowledgeFlowApp.this.m_perspectives.get(0))), "Center");
                    KnowledgeFlowApp.this.m_perspectives.get(0).setActive(true);
                    KnowledgeFlowApp.this.revalidate();
                    KnowledgeFlowApp.this.repaint();
                    KnowledgeFlowApp.this.notifyIsDirty();
                }
            });
            this.m_perspectiveToolBar.add(tBut);
            this.m_perspectiveGroup.add(tBut);
            this.setupUserPerspectives();
        }
        if (this.m_pluginPerspectiveLookup.size() > 0) {
            this.m_configAndPerspectives = new JPanel();
            this.m_configAndPerspectives.setLayout(new BorderLayout());
            this.m_configAndPerspectives.add((Component)this.m_perspectiveToolBar, "Center");
            try {
                String toolBarIsVisible;
                Properties visible = Utils.readProperties(BeansProperties.VISIBLE_PERSPECTIVES_PROPERTIES_FILE);
                Enumeration<?> keys = visible.propertyNames();
                if (keys.hasMoreElements() && (toolBarIsVisible = visible.getProperty("weka.gui.beans.KnowledgeFlow.PerspectiveToolBarVisisble")) != null && toolBarIsVisible.length() > 0) {
                    this.m_configAndPerspectivesVisible = toolBarIsVisible.equalsIgnoreCase("yes");
                }
            }
            catch (Exception ex) {
                System.err.println("Problem reading visible perspectives property file");
                ex.printStackTrace();
            }
            if (this.m_configAndPerspectivesVisible) {
                this.add((Component)this.m_configAndPerspectives, "North");
            }
            JButton configB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/cog.png")));
            configB.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 1));
            configB.setToolTipText("Enable/disable perspectives");
            this.m_configAndPerspectives.add((Component)configB, "West");
            configB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Utils.getDontShowDialog("weka.gui.beans.KnowledgeFlow.PerspectiveInfo")) {
                        JCheckBox dontShow = new JCheckBox("Do not show this message again");
                        Object[] stuff = new Object[]{"Perspectives are environments that take over the\nKnowledge Flow UI and provide major additional functionality.\nMany perspectives will operate on a set of instances. Instances\nCan be sent to a perspective by placing a DataSource on the\nlayout canvas, configuring it and then selecting \"Send to perspective\"\nfrom the contextual popup menu that appears when you right-click on\nit. Several perspectives are built in to the Knowledge Flow, others\ncan be installed via the package manager.\n", dontShow};
                        JOptionPane.showMessageDialog(KnowledgeFlowApp.this, stuff, "Perspective information", 0);
                        if (dontShow.isSelected()) {
                            try {
                                Utils.setDontShowDialog("weka.gui.beans.KnowledgeFlow.PerspectiveInfo");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    KnowledgeFlowApp.this.popupPerspectiveConfigurer();
                }
            });
        }
        for (String pName : this.m_perspectiveCache.keySet()) {
            this.m_perspectiveCache.get(pName).setMainKFPerspective(this.m_mainKFPerspective);
        }
        this.loadUserComponents();
        this.clearLayout();
    }

    public MainKFPerspective getMainPerspective() {
        return this.m_mainKFPerspective;
    }

    private void popupPerspectiveConfigurer() {
        if (this.m_perspectiveConfigurer == null) {
            this.m_perspectiveConfigurer = new AttributeSelectionPanel(true, true, true, true);
        }
        if (this.m_firstUserComponentOpp) {
            this.installWindowListenerForSavingUserStuff();
            this.m_firstUserComponentOpp = false;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        final ArrayList<String> pClasses = new ArrayList<String>();
        TreeSet<String> sortedPerspectives = new TreeSet<String>();
        for (String clName : this.m_pluginPerspectiveLookup.keySet()) {
            sortedPerspectives.add(clName);
        }
        for (String clName : sortedPerspectives) {
            pClasses.add(clName);
            String pName = this.m_pluginPerspectiveLookup.get(clName);
            atts.add(new Attribute(pName));
        }
        Instances perspectiveInstances = new Instances("Perspectives", atts, 1);
        boolean[] selectedPerspectives = new boolean[perspectiveInstances.numAttributes()];
        for (String selected : BeansProperties.VISIBLE_PERSPECTIVES) {
            String pName = this.m_pluginPerspectiveLookup.get(selected);
            if (pName == null) continue;
            int index = perspectiveInstances.attribute(pName).index();
            selectedPerspectives[index] = true;
        }
        this.m_perspectiveConfigurer.setInstances(perspectiveInstances);
        try {
            this.m_perspectiveConfigurer.setSelectedAttributes(selectedPerspectives);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        final JDialog d = new JDialog((Window)((JFrame)this.getTopLevelAncestor()), "Manage Perspectives", Dialog.ModalityType.DOCUMENT_MODAL);
        d.setLayout(new BorderLayout());
        JPanel holder = new JPanel();
        holder.setLayout(new BorderLayout());
        holder.add((Component)this.m_perspectiveConfigurer, "Center");
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        holder.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected;
                BeansProperties.VISIBLE_PERSPECTIVES = new TreeSet<String>();
                for (int element : selected = KnowledgeFlowApp.this.m_perspectiveConfigurer.getSelectedAttributes()) {
                    String selectedClassName = (String)pClasses.get(element);
                    if (KnowledgeFlowApp.this.m_perspectiveCache.get(selectedClassName) == null) {
                        try {
                            Object p = WekaPackageClassLoaderManager.objectForName(selectedClassName);
                            if (p instanceof KFPerspective && p instanceof JPanel) {
                                String title = ((KFPerspective)p).getPerspectiveTitle();
                                Logger.log(Logger.Level.INFO, "[KnowledgeFlow] loaded perspective: " + title);
                                ((KFPerspective)p).setLoaded(true);
                                ((KFPerspective)p).setMainKFPerspective(KnowledgeFlowApp.this.m_mainKFPerspective);
                                KnowledgeFlowApp.this.m_perspectiveCache.put(selectedClassName, (KFPerspective)p);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    BeansProperties.VISIBLE_PERSPECTIVES.add(selectedClassName);
                }
                KnowledgeFlowApp.this.setupUserPerspectives();
                d.dispose();
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
            }
        });
        d.getContentPane().add((Component)holder, "Center");
        d.pack();
        d.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
        d.setVisible(true);
    }

    private void setupUserPerspectives() {
        for (int i = this.m_perspectiveToolBar.getComponentCount() - 1; i > 0; --i) {
            this.m_perspectiveToolBar.remove(i);
            this.m_perspectives.remove(i);
        }
        int index = 1;
        for (String c : BeansProperties.VISIBLE_PERSPECTIVES) {
            KFPerspective toAdd = this.m_perspectiveCache.get(c);
            if (!(toAdd instanceof JComponent)) continue;
            toAdd.setLoaded(true);
            this.m_perspectives.add(toAdd);
            String titleM = toAdd.getPerspectiveTitle();
            Icon icon = toAdd.getPerspectiveIcon();
            JToggleButton tBut = null;
            tBut = icon != null ? new JToggleButton(titleM, icon, false) : new JToggleButton(titleM, false);
            tBut.setToolTipText(toAdd.getPerspectiveTipText());
            final int theIndex = index++;
            tBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.setActivePerspective(theIndex);
                }
            });
            this.m_perspectiveToolBar.add(tBut);
            this.m_perspectiveGroup.add(tBut);
        }
        KFPerspective current = (KFPerspective)((Object)this.m_perspectiveHolder.getComponent(0));
        if (current != this.m_mainKFPerspective) {
            current.setActive(false);
            this.m_perspectiveHolder.remove(0);
            this.m_perspectiveHolder.add(this.m_mainKFPerspective);
            ((JToggleButton)this.m_perspectiveToolBar.getComponent(0)).setSelected(true);
        }
        this.revalidate();
        this.repaint();
        this.notifyIsDirty();
    }

    protected void setActivePerspective(int theIndex) {
        if (theIndex < 0 || theIndex > this.m_perspectives.size() - 1) {
            return;
        }
        KFPerspective current = (KFPerspective)((Object)this.m_perspectiveHolder.getComponent(0));
        current.setActive(false);
        this.m_perspectiveHolder.remove(0);
        this.m_perspectiveHolder.add((Component)((JComponent)((Object)this.m_perspectives.get(theIndex))), "Center");
        this.m_perspectives.get(theIndex).setActive(true);
        ((JToggleButton)this.m_perspectiveToolBar.getComponent(theIndex)).setSelected(true);
        this.revalidate();
        this.repaint();
        this.notifyIsDirty();
    }

    private void snapSelectedToGrid() {
        Vector<Object> v = this.m_mainKFPerspective.getSelectedBeans();
        if (v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                BeanInstance b = (BeanInstance)v.get(i);
                int x = b.getX();
                int y = b.getY();
                b.setXY(this.snapToGrid(x), this.snapToGrid(y));
            }
            this.revalidate();
            this.m_beanLayout.repaint();
            this.notifyIsDirty();
            this.m_mainKFPerspective.setEditedStatus(true);
        }
    }

    private int snapToGrid(int val) {
        int r = val % 40;
        val /= 40;
        if (r > 20) {
            ++val;
        }
        return val *= 40;
    }

    private void configureBeanLayout(final BeanLayout layout) {
        layout.setLayout(null);
        layout.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                layout.requestFocusInWindow();
                double z = (double)KnowledgeFlowApp.this.m_layoutZoom / 100.0;
                double px = me.getX();
                double py = me.getY();
                py /= z;
                px /= z;
                if (KnowledgeFlowApp.this.m_toolBarBean == null && (me.getModifiers() & 0x10) == 16 && KnowledgeFlowApp.this.m_mode == 0) {
                    BeanInstance bi = BeanInstance.findInstance(new Point((int)px, (int)py), KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                    JComponent bc = null;
                    if (bi != null) {
                        bc = (JComponent)bi.getBean();
                    }
                    if (bc != null) {
                        KnowledgeFlowApp.this.m_editElement = bi;
                        KnowledgeFlowApp.this.m_oldX = (int)px;
                        KnowledgeFlowApp.this.m_oldY = (int)py;
                        KnowledgeFlowApp.this.m_mode = 1;
                    }
                    if (KnowledgeFlowApp.this.m_mode != 1) {
                        KnowledgeFlowApp.this.m_mode = 4;
                        KnowledgeFlowApp.this.m_oldX = (int)px;
                        KnowledgeFlowApp.this.m_oldY = (int)py;
                        KnowledgeFlowApp.this.m_startX = KnowledgeFlowApp.this.m_oldX;
                        KnowledgeFlowApp.this.m_startY = KnowledgeFlowApp.this.m_oldY;
                        Graphics2D gx = (Graphics2D)layout.getGraphics();
                        gx.setXORMode(Color.white);
                        gx.dispose();
                        KnowledgeFlowApp.this.m_mode = 4;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                layout.requestFocusInWindow();
                if (KnowledgeFlowApp.this.m_editElement != null && KnowledgeFlowApp.this.m_mode == 1) {
                    if (KnowledgeFlowApp.this.m_snapToGridB.isSelected()) {
                        int x = KnowledgeFlowApp.this.snapToGrid(KnowledgeFlowApp.this.m_editElement.getX());
                        int y = KnowledgeFlowApp.this.snapToGrid(KnowledgeFlowApp.this.m_editElement.getY());
                        KnowledgeFlowApp.this.m_editElement.setXY(x, y);
                        KnowledgeFlowApp.this.snapSelectedToGrid();
                    }
                    KnowledgeFlowApp.this.m_editElement = null;
                    KnowledgeFlowApp.this.revalidate();
                    layout.repaint();
                    KnowledgeFlowApp.this.m_mode = 0;
                }
                if (KnowledgeFlowApp.this.m_mode == 4) {
                    KnowledgeFlowApp.this.revalidate();
                    layout.repaint();
                    KnowledgeFlowApp.this.m_mode = 0;
                    double z = (double)KnowledgeFlowApp.this.m_layoutZoom / 100.0;
                    double px = me.getX();
                    double py = me.getY();
                    KnowledgeFlowApp.this.highlightSubFlow(KnowledgeFlowApp.this.m_startX, KnowledgeFlowApp.this.m_startY, (int)(px /= z), (int)(py /= z));
                }
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void mouseClicked(MouseEvent me) {
                BeanInstance bi;
                double z;
                block26: {
                    block25: {
                        block27: {
                            layout.requestFocusInWindow();
                            Point p = me.getPoint();
                            Point np = new Point();
                            z = (double)KnowledgeFlowApp.this.m_layoutZoom / 100.0;
                            np.setLocation(p.getX() / z, p.getY() / z);
                            bi = BeanInstance.findInstance(np, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                            if (KnowledgeFlowApp.this.m_mode != 3 && KnowledgeFlowApp.this.m_mode != 0) break block26;
                            if (bi == null) break block27;
                            JComponent bc = (JComponent)bi.getBean();
                            if (me.getClickCount() == 2 && !(bc instanceof MetaBean)) {
                                try {
                                    Class<?> clazz = Introspector.getBeanInfo(bc.getClass()).getBeanDescriptor().getCustomizerClass();
                                    if (clazz == null) break block25;
                                    if (bc instanceof BeanCommon) {
                                        if (!((BeanCommon)((Object)bc)).isBusy() && !KnowledgeFlowApp.this.m_mainKFPerspective.getExecuting()) {
                                            KnowledgeFlowApp.this.popupCustomizer(clazz, bc);
                                        }
                                        break block25;
                                    }
                                    KnowledgeFlowApp.this.popupCustomizer(clazz, bc);
                                }
                                catch (IntrospectionException introspectionException) {
                                    introspectionException.printStackTrace();
                                }
                                break block25;
                            } else {
                                void var8_14;
                                if ((me.getModifiers() & 0x10) != 16 || me.isAltDown()) {
                                    KnowledgeFlowApp.this.doPopup(me.getPoint(), bi, (int)(p.getX() / z), (int)(p.getY() / z));
                                    return;
                                }
                                Vector<Object> vector = KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans();
                                if (!me.isShiftDown()) {
                                    Vector vector2 = new Vector();
                                }
                                var8_14.add(bi);
                                KnowledgeFlowApp.this.m_mainKFPerspective.setSelectedBeans((Vector<Object>)var8_14);
                                return;
                            }
                        }
                        if ((me.getModifiers() & 0x10) != 16 || me.isAltDown()) {
                            double px = me.getX();
                            double py = me.getY();
                            py /= z;
                            px /= z;
                            if (!KnowledgeFlowApp.this.m_mainKFPerspective.getExecuting()) {
                                KnowledgeFlowApp.this.rightClickCanvasPopup((int)px, (int)py);
                                KnowledgeFlowApp.this.revalidate();
                                KnowledgeFlowApp.this.repaint();
                                KnowledgeFlowApp.this.notifyIsDirty();
                            }
                            return;
                        }
                        if (KnowledgeFlowApp.this.m_toolBarBean != null) {
                            double x = me.getX();
                            double y = me.getY();
                            x /= z;
                            y /= z;
                            if (KnowledgeFlowApp.this.m_snapToGridB.isSelected()) {
                                x = KnowledgeFlowApp.this.snapToGrid((int)x);
                                y = KnowledgeFlowApp.this.snapToGrid((int)y);
                            }
                            KnowledgeFlowApp.this.addUndoPoint();
                            if (KnowledgeFlowApp.this.m_toolBarBean instanceof StringBuffer) {
                                KnowledgeFlowApp.this.pasteFromClipboard((int)x, (int)y, (StringBuffer)KnowledgeFlowApp.this.m_toolBarBean, false);
                                KnowledgeFlowApp.this.m_mode = 0;
                                KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(0));
                                KnowledgeFlowApp.this.m_toolBarBean = null;
                            } else {
                                KnowledgeFlowApp.this.addComponent((int)x, (int)y);
                            }
                            KnowledgeFlowApp.this.m_componentTree.clearSelection();
                            KnowledgeFlowApp.this.m_mainKFPerspective.setEditedStatus(true);
                        }
                    }
                    KnowledgeFlowApp.this.revalidate();
                    KnowledgeFlowApp.this.repaint();
                    KnowledgeFlowApp.this.notifyIsDirty();
                }
                double px = me.getX();
                double py = me.getY();
                px /= z;
                py /= z;
                if (KnowledgeFlowApp.this.m_mode == 5 && KnowledgeFlowApp.this.m_pasteBuffer.length() > 0) {
                    KnowledgeFlowApp.this.pasteFromClipboard((int)px, (int)py, KnowledgeFlowApp.this.m_pasteBuffer, true);
                    KnowledgeFlowApp.this.m_mode = 0;
                    KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (KnowledgeFlowApp.this.m_mode == 2) {
                    layout.repaint();
                    Vector<Object> beanInstances = BeanInstance.getBeanInstances(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                    for (int i = 0; i < beanInstances.size(); ++i) {
                        JComponent bean = (JComponent)((BeanInstance)beanInstances.elementAt(i)).getBean();
                        if (!(bean instanceof Visible)) continue;
                        ((Visible)((Object)bean)).getVisual().setDisplayConnectors(false);
                    }
                    if (bi != null) {
                        boolean doConnection = false;
                        if (!(bi.getBean() instanceof BeanCommon)) {
                            doConnection = true;
                        } else if (((BeanCommon)bi.getBean()).connectionAllowed(KnowledgeFlowApp.this.m_sourceEventSetDescriptor)) {
                            doConnection = true;
                        }
                        if (doConnection) {
                            KnowledgeFlowApp.this.addUndoPoint();
                            if (bi.getBean() instanceof MetaBean) {
                                BeanConnection.doMetaConnection(KnowledgeFlowApp.this.m_editElement, bi, KnowledgeFlowApp.this.m_sourceEventSetDescriptor, layout, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                            } else {
                                new BeanConnection(KnowledgeFlowApp.this.m_editElement, bi, KnowledgeFlowApp.this.m_sourceEventSetDescriptor, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                            }
                            KnowledgeFlowApp.this.m_mainKFPerspective.setEditedStatus(true);
                        }
                        layout.repaint();
                    }
                    KnowledgeFlowApp.this.m_mode = 0;
                    KnowledgeFlowApp.this.m_editElement = null;
                    KnowledgeFlowApp.this.m_sourceEventSetDescriptor = null;
                }
                if (KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans().size() > 0) {
                    KnowledgeFlowApp.this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
                }
            }
        });
        layout.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                double z = (double)KnowledgeFlowApp.this.m_layoutZoom / 100.0;
                double px = me.getX();
                double py = me.getY();
                px /= z;
                py /= z;
                if (KnowledgeFlowApp.this.m_editElement != null && KnowledgeFlowApp.this.m_mode == 1) {
                    int deltaX = (int)px - KnowledgeFlowApp.this.m_oldX;
                    int deltaY = (int)py - KnowledgeFlowApp.this.m_oldY;
                    KnowledgeFlowApp.this.m_editElement.setXY(KnowledgeFlowApp.this.m_editElement.getX() + deltaX, KnowledgeFlowApp.this.m_editElement.getY() + deltaY);
                    if (KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans().size() > 0) {
                        Vector<Object> v = KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans();
                        for (int i = 0; i < v.size(); ++i) {
                            BeanInstance b = (BeanInstance)v.get(i);
                            if (b == KnowledgeFlowApp.this.m_editElement) continue;
                            b.setXY(b.getX() + deltaX, b.getY() + deltaY);
                        }
                    }
                    layout.repaint();
                    KnowledgeFlowApp.this.m_oldX = (int)px;
                    KnowledgeFlowApp.this.m_oldY = (int)py;
                    KnowledgeFlowApp.this.m_mainKFPerspective.setEditedStatus(true);
                }
                if (KnowledgeFlowApp.this.m_mode == 4) {
                    layout.repaint();
                    KnowledgeFlowApp.this.m_oldX = (int)px;
                    KnowledgeFlowApp.this.m_oldY = (int)py;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                double z = (double)KnowledgeFlowApp.this.m_layoutZoom / 100.0;
                double px = e.getX();
                double py = e.getY();
                px /= z;
                py /= z;
                if (KnowledgeFlowApp.this.m_mode == 2) {
                    layout.repaint();
                    KnowledgeFlowApp.this.m_oldX = (int)px;
                    KnowledgeFlowApp.this.m_oldY = (int)py;
                }
            }
        });
    }

    private void setUpLogPanel(final LogPanel logPanel) {
        String date = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        logPanel.logMessage("Weka Knowledge Flow was written by Mark Hall");
        logPanel.logMessage("Weka Knowledge Flow");
        logPanel.logMessage("(c) 2002-" + Copyright.getToYear() + " " + Copyright.getOwner() + ", " + Copyright.getAddress());
        logPanel.logMessage("web: " + Copyright.getURL());
        logPanel.logMessage(date);
        logPanel.statusMessage("@!@[KnowledgeFlow]|Welcome to the Weka Knowledge Flow");
        logPanel.getStatusTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (logPanel.getStatusTable().rowAtPoint(e.getPoint()) == 0 && ((e.getModifiers() & 0x10) != 16 || e.isAltDown())) {
                    System.gc();
                    Runtime currR = Runtime.getRuntime();
                    long freeM = currR.freeMemory();
                    long totalM = currR.totalMemory();
                    long maxM = currR.maxMemory();
                    logPanel.logMessage("[KnowledgeFlow] Memory (free/total/max.) in bytes: " + String.format("%,d", freeM) + " / " + String.format("%,d", totalM) + " / " + String.format("%,d", maxM));
                    logPanel.statusMessage("@!@[KnowledgeFlow]|Memory (free/total/max.) in bytes: " + String.format("%,d", freeM) + " / " + String.format("%,d", totalM) + " / " + String.format("%,d", maxM));
                }
            }
        });
    }

    private Image loadImage(String path) {
        Image pic = null;
        URL imageURL = this.getClass().getClassLoader().getResource(path);
        if (imageURL == null) {
            Logger.log(Logger.Level.WARNING, "Unable to load " + path);
        } else {
            pic = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        return pic;
    }

    private void runFlow(boolean sequential) {
        if (this.m_mainKFPerspective.getNumTabs() > 0) {
            RunThread runThread = new RunThread(sequential);
            this.m_mainKFPerspective.setExecutionThread(runThread);
            runThread.start();
        }
    }

    private void stopFlow() {
        RunThread running;
        if (this.m_mainKFPerspective.getCurrentTabIndex() >= 0 && (running = this.m_mainKFPerspective.getExecutionThread()) != null) {
            running.stopAllFlows();
        }
    }

    private void processPackage(String tempBeanCompName, HierarchyPropertyParser hpp, DefaultMutableTreeNode parentNode, Map<String, DefaultMutableTreeNode> nodeTextIndex) {
        String[] children;
        if (hpp.isLeafReached()) {
            hpp.goToParent();
            return;
        }
        for (String element : children = hpp.childrenValues()) {
            hpp.goToChild(element);
            InvisibleNode child = null;
            if (hpp.isLeafReached()) {
                String algName = hpp.fullValue();
                Object visibleCheck = this.instantiateBean(true, tempBeanCompName, algName);
                if (visibleCheck != null) {
                    BeanVisual bv;
                    if (visibleCheck instanceof BeanContextChild) {
                        this.m_bcSupport.add(visibleCheck);
                    }
                    ImageIcon scaledForTree = null;
                    if (visibleCheck instanceof Visible && (bv = ((Visible)visibleCheck).getVisual()) != null) {
                        scaledForTree = new ImageIcon(bv.scale(0.33));
                    }
                    String toolTip = "";
                    try {
                        Object wrappedA = WekaPackageClassLoaderManager.objectForName(algName);
                        toolTip = KnowledgeFlowApp.getGlobalInfo(wrappedA);
                    }
                    catch (Exception wrappedA) {
                        // empty catch block
                    }
                    JTreeLeafDetails leafData = new JTreeLeafDetails(tempBeanCompName, algName, scaledForTree);
                    if (toolTip != null && toolTip.length() > 0) {
                        leafData.setToolTipText(toolTip);
                    }
                    child = new InvisibleNode(leafData);
                    nodeTextIndex.put(algName.toLowerCase() + " " + (toolTip != null ? toolTip.toLowerCase() : ""), child);
                }
            } else {
                child = new InvisibleNode(element);
            }
            if (child != null) {
                parentNode.add(child);
            }
            this.processPackage(tempBeanCompName, hpp, child, nodeTextIndex);
        }
        hpp.goToParent();
    }

    private Object instantiateBean(boolean wekawrapper, String tempBeanCompName, String algName) {
        Object tempBean;
        if (wekawrapper) {
            try {
                tempBean = WekaPackageClassLoaderManager.objectForName(tempBeanCompName);
            }
            catch (Exception ex) {
                Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Failed to instantiate :" + tempBeanCompName + "KnowledgeFlowApp.instantiateBean()");
                return null;
            }
            if (tempBean instanceof WekaWrapper) {
                Class<?> c = null;
                try {
                    c = WekaPackageClassLoaderManager.forName(algName);
                    for (Annotation a2 : c.getAnnotations()) {
                        if (!(a2 instanceof KFIgnore)) continue;
                        return null;
                    }
                }
                catch (Exception ex) {
                    Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Can't find class called: " + algName);
                    return null;
                }
                try {
                    Object o = c.newInstance();
                    ((WekaWrapper)tempBean).setWrappedAlgorithm(o);
                }
                catch (Exception ex) {
                    Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Failed to configure " + tempBeanCompName + " with " + algName);
                    return null;
                }
            }
        } else {
            try {
                tempBean = WekaPackageClassLoaderManager.objectForName(tempBeanCompName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Failed to instantiate :" + tempBeanCompName + "KnowledgeFlowApp.instantiateBean()");
                return null;
            }
        }
        return tempBean;
    }

    private void popupHelp() {
        final JButton tempB = this.m_helpB;
        try {
            String line;
            tempB.setEnabled(false);
            InputStream inR = this.getClass().getClassLoader().getResourceAsStream("weka/gui/beans/README_KnowledgeFlow");
            StringBuffer helpHolder = new StringBuffer();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inR));
            while ((line = lnr.readLine()) != null) {
                helpHolder.append(line + "\n");
            }
            lnr.close();
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            JTextArea ta = new JTextArea(helpHolder.toString());
            ta.setFont(new Font("Monospaced", 0, 12));
            ta.setEditable(false);
            JScrollPane sp = new JScrollPane(ta);
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    tempB.setEnabled(true);
                    jf.dispose();
                }
            });
            jf.setSize(600, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            tempB.setEnabled(true);
        }
    }

    public void closeAllTabs() {
        for (int i = this.m_mainKFPerspective.getNumTabs() - 1; i >= 0; --i) {
            this.m_mainKFPerspective.removeTab(i);
        }
    }

    public void clearLayout() {
        this.stopFlow();
        if (this.m_mainKFPerspective.getNumTabs() == 0 || this.getAllowMultipleTabs()) {
            this.m_mainKFPerspective.addTab("Untitled" + this.m_untitledCount++);
        }
        if (!this.getAllowMultipleTabs()) {
            BeanConnection.setConnections(new Vector<BeanConnection>(), this.m_mainKFPerspective.getCurrentTabIndex());
            BeanInstance.setBeanInstances(new Vector<Object>(), this.m_mainKFPerspective.getBeanLayout(this.m_mainKFPerspective.getCurrentTabIndex()), this.m_mainKFPerspective.getCurrentTabIndex());
        }
    }

    private void createTemplateMenuPopup() {
        PopupMenu templatesMenu = new PopupMenu();
        for (int i = 0; i < BeansProperties.TEMPLATE_PATHS.size(); ++i) {
            String mE = BeansProperties.TEMPLATE_DESCRIPTIONS.get(i);
            final String path = BeansProperties.TEMPLATE_PATHS.get(i);
            MenuItem m = new MenuItem(mE);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ee) {
                    try {
                        ClassLoader resourceClassLoader = WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().findClassloaderForResource(path);
                        InputStream inR = resourceClassLoader.getResourceAsStream(path);
                        KnowledgeFlowApp.this.m_mainKFPerspective.addTab("Untitled" + KnowledgeFlowApp.this.m_untitledCount++);
                        XMLBeans xml = new XMLBeans(KnowledgeFlowApp.this.m_beanLayout, KnowledgeFlowApp.this.m_bcSupport, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                        InputStreamReader isr = new InputStreamReader(inR);
                        Vector v = (Vector)xml.read(isr);
                        Vector beans = (Vector)v.get(0);
                        Vector connections = (Vector)v.get(1);
                        isr.close();
                        KnowledgeFlowApp.this.integrateFlow(beans, connections, false, false);
                        KnowledgeFlowApp.this.notifyIsDirty();
                        KnowledgeFlowApp.this.revalidate();
                    }
                    catch (Exception ex) {
                        KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentLogPanel().logMessage("Problem loading template: " + ex.getMessage());
                    }
                }
            });
            templatesMenu.add(m);
        }
        this.m_templatesB.add(templatesMenu);
        templatesMenu.show(this.m_templatesB, 0, 0);
    }

    private void doPopup(Point pt, final BeanInstance bi, int x, int y) {
        final JComponent bc = (JComponent)bi.getBean();
        final int xx = x;
        final int yy = y;
        int menuItemCount = 0;
        PopupMenu beanContextMenu = new PopupMenu();
        boolean executing = this.m_mainKFPerspective.getExecuting();
        MenuItem edit = new MenuItem("Edit:");
        edit.setEnabled(false);
        beanContextMenu.insert(edit, menuItemCount);
        ++menuItemCount;
        if (this.m_mainKFPerspective.getSelectedBeans().size() > 0) {
            MenuItem copyItem = new MenuItem("Copy");
            copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.copyToClipboard();
                    KnowledgeFlowApp.this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
                }
            });
            beanContextMenu.add(copyItem);
            copyItem.setEnabled(!executing);
            ++menuItemCount;
        }
        if (bc instanceof MetaBean) {
            MenuItem ungroupItem = new MenuItem("Ungroup");
            ungroupItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i;
                    bi.removeBean(KnowledgeFlowApp.this.m_beanLayout, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                    Vector<Object> group = ((MetaBean)bc).getBeansInSubFlow();
                    Vector<BeanConnection> associatedConnections = ((MetaBean)bc).getAssociatedConnections();
                    ((MetaBean)bc).restoreBeans(xx, yy);
                    for (i = 0; i < group.size(); ++i) {
                        BeanInstance tbi = (BeanInstance)group.elementAt(i);
                        KnowledgeFlowApp.this.addComponent(tbi, false);
                        tbi.addBean(KnowledgeFlowApp.this.m_beanLayout, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                    }
                    for (i = 0; i < associatedConnections.size(); ++i) {
                        BeanConnection tbc = associatedConnections.elementAt(i);
                        tbc.setHidden(false);
                    }
                    KnowledgeFlowApp.this.m_beanLayout.repaint();
                    KnowledgeFlowApp.this.m_mainKFPerspective.setEditedStatus(true);
                    KnowledgeFlowApp.this.notifyIsDirty();
                }
            });
            ungroupItem.setEnabled(!executing);
            beanContextMenu.add(ungroupItem);
            ++menuItemCount;
            MenuItem addToUserTabItem = new MenuItem("Add to user tab");
            addToUserTabItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.addToUserTreeNode(bi, true);
                    KnowledgeFlowApp.this.notifyIsDirty();
                }
            });
            addToUserTabItem.setEnabled(!executing);
            beanContextMenu.add(addToUserTabItem);
            ++menuItemCount;
        }
        MenuItem deleteItem = new MenuItem("Delete");
        deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanConnection.removeConnections(bi, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                bi.removeBean(KnowledgeFlowApp.this.m_beanLayout, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                if (bc instanceof BeanCommon) {
                    String key = ((BeanCommon)((Object)bc)).getCustomName() + "$" + bc.hashCode();
                    KnowledgeFlowApp.this.m_logPanel.statusMessage(key + "|remove");
                }
                if (KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans().size() > 0) {
                    KnowledgeFlowApp.this.deleteSelectedBeans();
                }
                KnowledgeFlowApp.this.revalidate();
                KnowledgeFlowApp.this.m_mainKFPerspective.setEditedStatus(true);
                KnowledgeFlowApp.this.notifyIsDirty();
                KnowledgeFlowApp.this.m_selectAllB.setEnabled(BeanInstance.getBeanInstances(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()).size() > 0);
            }
        });
        deleteItem.setEnabled(!executing);
        if (bc instanceof BeanCommon && ((BeanCommon)((Object)bc)).isBusy()) {
            deleteItem.setEnabled(false);
        }
        beanContextMenu.add(deleteItem);
        ++menuItemCount;
        if (bc instanceof BeanCommon) {
            MenuItem nameItem = new MenuItem("Set name");
            nameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String oldName = ((BeanCommon)((Object)bc)).getCustomName();
                    String name = JOptionPane.showInputDialog(KnowledgeFlowApp.this, "Enter a name for this component", oldName);
                    if (name != null) {
                        ((BeanCommon)((Object)bc)).setCustomName(name);
                        KnowledgeFlowApp.this.m_mainKFPerspective.setEditedStatus(true);
                    }
                }
            });
            if (bc instanceof BeanCommon && ((BeanCommon)((Object)bc)).isBusy()) {
                nameItem.setEnabled(false);
            }
            nameItem.setEnabled(!executing);
            beanContextMenu.add(nameItem);
            ++menuItemCount;
        }
        try {
            Vector<Object> compInfo = new Vector<BeanInfo>(1);
            Vector<Object> associatedBeans = null;
            if (bc instanceof MetaBean) {
                compInfo = ((MetaBean)bc).getBeanInfoSubFlow();
                associatedBeans = ((MetaBean)bc).getBeansInSubFlow();
                ((MetaBean)bc).getBeansInOutputs();
                ((MetaBean)bc).getBeanInfoOutputs();
            } else {
                compInfo.add(Introspector.getBeanInfo(bc.getClass()));
            }
            final Vector<Object> tempAssociatedBeans = associatedBeans;
            if (compInfo == null) {
                Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Error in doPopup()");
            } else {
                for (int zz = 0; zz < compInfo.size(); ++zz) {
                    final int tt = zz;
                    final Class<?> custClass = ((BeanInfo)compInfo.elementAt(zz)).getBeanDescriptor().getCustomizerClass();
                    if (custClass != null) {
                        boolean customizationEnabled;
                        MenuItem custItem = null;
                        boolean bl = customizationEnabled = !executing;
                        if (!(bc instanceof MetaBean)) {
                            custItem = new MenuItem("Configure...");
                            if (bc instanceof BeanCommon) {
                                customizationEnabled = !executing && !((BeanCommon)((Object)bc)).isBusy();
                            }
                        } else {
                            String custName = custClass.getName();
                            BeanInstance tbi = (BeanInstance)associatedBeans.elementAt(zz);
                            if (tbi.getBean() instanceof BeanCommon) {
                                custName = ((BeanCommon)tbi.getBean()).getCustomName();
                            } else {
                                custName = tbi.getBean() instanceof WekaWrapper ? ((WekaWrapper)tbi.getBean()).getWrappedAlgorithm().getClass().getName() : custName.substring(0, custName.indexOf("Customizer"));
                                custName = custName.substring(custName.lastIndexOf(46) + 1, custName.length());
                            }
                            custItem = new MenuItem("Configure: " + custName);
                            if (tbi.getBean() instanceof BeanCommon) {
                                customizationEnabled = !executing && !((BeanCommon)tbi.getBean()).isBusy();
                            }
                        }
                        custItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (bc instanceof MetaBean) {
                                    KnowledgeFlowApp.this.popupCustomizer(custClass, (JComponent)((BeanInstance)tempAssociatedBeans.elementAt(tt)).getBean());
                                } else {
                                    KnowledgeFlowApp.this.popupCustomizer(custClass, bc);
                                }
                                KnowledgeFlowApp.this.notifyIsDirty();
                            }
                        });
                        custItem.setEnabled(customizationEnabled);
                        beanContextMenu.add(custItem);
                        ++menuItemCount;
                        continue;
                    }
                    Logger.log(Logger.Level.INFO, "[KnowledgeFlow] No customizer class");
                }
                Vector<EventSetDescriptor[]> esdV = new Vector<EventSetDescriptor[]>();
                for (int i = 0; i < compInfo.size(); ++i) {
                    EventSetDescriptor[] temp = ((BeanInfo)compInfo.elementAt(i)).getEventSetDescriptors();
                    if (temp == null || temp.length <= 0) continue;
                    esdV.add(temp);
                }
                if (esdV.size() > 0) {
                    MenuItem connections = new MenuItem("Connections:");
                    connections.setEnabled(false);
                    beanContextMenu.insert(connections, menuItemCount);
                    ++menuItemCount;
                }
                final Vector<Object> finalOutputs = associatedBeans;
                for (int j = 0; j < esdV.size(); ++j) {
                    EventSetDescriptor[] esds;
                    final int fj = j;
                    String sourceBeanName = "";
                    if (bc instanceof MetaBean) {
                        Object sourceBean = ((BeanInstance)associatedBeans.elementAt(j)).getBean();
                        if (sourceBean instanceof BeanCommon) {
                            sourceBeanName = ((BeanCommon)sourceBean).getCustomName();
                        } else {
                            sourceBeanName = sourceBean instanceof WekaWrapper ? ((WekaWrapper)sourceBean).getWrappedAlgorithm().getClass().getName() : sourceBean.getClass().getName();
                            sourceBeanName = sourceBeanName.substring(sourceBeanName.lastIndexOf(46) + 1, sourceBeanName.length());
                        }
                        sourceBeanName = sourceBeanName + ": ";
                    }
                    for (final EventSetDescriptor esd : esds = (EventSetDescriptor[])esdV.elementAt(j)) {
                        MenuItem evntItem = new MenuItem(sourceBeanName + esd.getName());
                        boolean ok = true;
                        evntItem.setEnabled(!executing);
                        if (bc instanceof EventConstraints) {
                            ok = ((EventConstraints)((Object)bc)).eventGeneratable(esd.getName());
                        }
                        if (ok) {
                            evntItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    KnowledgeFlowApp.this.connectComponents(esd, bc instanceof MetaBean ? (BeanInstance)finalOutputs.elementAt(fj) : bi, xx, yy);
                                    KnowledgeFlowApp.this.notifyIsDirty();
                                }
                            });
                        } else {
                            evntItem.setEnabled(false);
                        }
                        beanContextMenu.add(evntItem);
                        ++menuItemCount;
                    }
                }
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
        if (bc instanceof UserRequestAcceptor || bc instanceof Startable) {
            Enumeration<String> req = null;
            if (bc instanceof UserRequestAcceptor) {
                req = ((UserRequestAcceptor)((Object)bc)).enumerateRequests();
            }
            if (req != null && req.hasMoreElements()) {
                MenuItem actions2 = new MenuItem("Actions:");
                actions2.setEnabled(false);
                beanContextMenu.insert(actions2, menuItemCount);
                ++menuItemCount;
            }
            while (req != null && req.hasMoreElements()) {
                String tempS = req.nextElement();
                this.insertUserOrStartableMenuItem(bc, false, tempS, beanContextMenu);
                ++menuItemCount;
            }
        }
        if (bc instanceof Loader && this.m_perspectives.size() > 1 && this.m_perspectiveDataLoadThread == null) {
            final weka.core.converters.Loader theLoader = ((Loader)bc).getLoader();
            boolean ok = true;
            if (theLoader instanceof FileSourcedConverter) {
                String fileName = ((FileSourcedConverter)((Object)theLoader)).retrieveFile().getPath();
                Environment env = this.m_mainKFPerspective.getEnvironmentSettings();
                try {
                    fileName = env.substitute(fileName);
                }
                catch (Exception finalOutputs) {
                    // empty catch block
                }
                File tempF = new File(fileName);
                String fileNameFixedPathSep = fileName.replace(File.separatorChar, '/');
                if (!tempF.isFile() && this.getClass().getClassLoader().getResource(fileNameFixedPathSep) == null) {
                    ok = false;
                }
            }
            if (ok) {
                beanContextMenu.addSeparator();
                ++menuItemCount;
                if (this.m_perspectives.size() > 2) {
                    MenuItem sendToAllPerspectives = new MenuItem("Send to all perspectives");
                    ++menuItemCount;
                    sendToAllPerspectives.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            KnowledgeFlowApp.this.loadDataAndSendToPerspective(theLoader, 0, true);
                        }
                    });
                    beanContextMenu.add(sendToAllPerspectives);
                }
                Menu sendToPerspective = new Menu("Send to perspective...");
                beanContextMenu.add(sendToPerspective);
                ++menuItemCount;
                for (int i = 1; i < this.m_perspectives.size(); ++i) {
                    final int pIndex = i;
                    if (!this.m_perspectives.get(i).acceptsInstances()) continue;
                    String pName = this.m_perspectives.get(i).getPerspectiveTitle();
                    MenuItem pI = new MenuItem(pName);
                    pI.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            KnowledgeFlowApp.this.loadDataAndSendToPerspective(theLoader, pIndex, false);
                        }
                    });
                    sendToPerspective.add(pI);
                }
            }
        }
        if (menuItemCount > 0) {
            double z = (double)this.m_layoutZoom / 100.0;
            double px = (double)x * z;
            double py = (double)y * z;
            this.m_beanLayout.add(beanContextMenu);
            beanContextMenu.show(this.m_beanLayout, (int)px, (int)py);
        }
    }

    private synchronized void loadDataAndSendToPerspective(final weka.core.converters.Loader loader, final int perspectiveIndex, final boolean sendToAll) {
        if (this.m_perspectiveDataLoadThread == null) {
            this.m_perspectiveDataLoadThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Environment env = KnowledgeFlowApp.this.m_mainKFPerspective.getEnvironmentSettings();
                        if (loader instanceof EnvironmentHandler) {
                            ((EnvironmentHandler)((Object)loader)).setEnvironment(env);
                        }
                        loader.reset();
                        KnowledgeFlowApp.this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|Sending data to perspective(s)...");
                        Instances data = loader.getDataSet();
                        if (data != null) {
                            int i;
                            if (!KnowledgeFlowApp.this.m_configAndPerspectivesVisible) {
                                KnowledgeFlowApp.this.add((Component)KnowledgeFlowApp.this.m_configAndPerspectives, "North");
                                KnowledgeFlowApp.this.m_configAndPerspectivesVisible = true;
                            }
                            for (i = 0; i < KnowledgeFlowApp.this.m_perspectives.size(); ++i) {
                                KnowledgeFlowApp.this.m_perspectiveToolBar.getComponent(i).setEnabled(false);
                            }
                            if (sendToAll) {
                                for (i = 1; i < KnowledgeFlowApp.this.m_perspectives.size(); ++i) {
                                    if (!KnowledgeFlowApp.this.m_perspectives.get(i).acceptsInstances()) continue;
                                    KnowledgeFlowApp.this.m_perspectives.get(i).setInstances(data);
                                }
                            } else {
                                KFPerspective currentP = (KFPerspective)((Object)KnowledgeFlowApp.this.m_perspectiveHolder.getComponent(0));
                                if (currentP != KnowledgeFlowApp.this.m_perspectives.get(perspectiveIndex)) {
                                    KnowledgeFlowApp.this.m_perspectives.get(perspectiveIndex).setInstances(data);
                                    currentP.setActive(false);
                                    KnowledgeFlowApp.this.m_perspectiveHolder.remove(0);
                                    KnowledgeFlowApp.this.m_perspectiveHolder.add((Component)((JComponent)((Object)KnowledgeFlowApp.this.m_perspectives.get(perspectiveIndex))), "Center");
                                    KnowledgeFlowApp.this.m_perspectives.get(perspectiveIndex).setActive(true);
                                    ((JToggleButton)KnowledgeFlowApp.this.m_perspectiveToolBar.getComponent(perspectiveIndex)).setSelected(true);
                                    KnowledgeFlowApp.this.revalidate();
                                    KnowledgeFlowApp.this.repaint();
                                    KnowledgeFlowApp.this.notifyIsDirty();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] problem loading data for perspective(s) : " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    finally {
                        for (int i = 0; i < KnowledgeFlowApp.this.m_perspectives.size(); ++i) {
                            KnowledgeFlowApp.this.m_perspectiveToolBar.getComponent(i).setEnabled(true);
                        }
                        KnowledgeFlowApp.this.m_perspectiveDataLoadThread = null;
                        KnowledgeFlowApp.this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|OK");
                    }
                }
            };
            this.m_perspectiveDataLoadThread.setPriority(1);
            this.m_perspectiveDataLoadThread.start();
        }
    }

    private void insertUserOrStartableMenuItem(final JComponent bc, final boolean startable, String tempS, PopupMenu beanContextMenu) {
        boolean disabled = false;
        boolean confirmRequest = false;
        if (tempS.charAt(0) == '$') {
            tempS = tempS.substring(1, tempS.length());
            disabled = true;
        }
        if (tempS.charAt(0) == '?') {
            tempS = tempS.substring(1, tempS.length());
            confirmRequest = true;
        }
        final String tempS2 = tempS;
        MenuItem custItem = new MenuItem(tempS2);
        if (confirmRequest) {
            custItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = JOptionPane.showConfirmDialog(KnowledgeFlowApp.this, tempS2, "Confirm action", 0);
                    if (result == 0) {
                        Thread startPointThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    if (startable) {
                                        ((Startable)((Object)bc)).start();
                                    } else if (bc instanceof UserRequestAcceptor) {
                                        ((UserRequestAcceptor)((Object)bc)).performRequest(tempS2);
                                    }
                                    KnowledgeFlowApp.this.notifyIsDirty();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        };
                        startPointThread.setPriority(1);
                        startPointThread.start();
                    }
                }
            });
        } else {
            custItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread startPointThread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                if (startable) {
                                    ((Startable)((Object)bc)).start();
                                } else if (bc instanceof UserRequestAcceptor) {
                                    ((UserRequestAcceptor)((Object)bc)).performRequest(tempS2);
                                }
                                KnowledgeFlowApp.this.notifyIsDirty();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    };
                    startPointThread.setPriority(1);
                    startPointThread.start();
                }
            });
        }
        if (disabled) {
            custItem.setEnabled(false);
        }
        beanContextMenu.add(custItem);
    }

    @Override
    public void setModifiedStatus(Object source, boolean modified) {
        if (source instanceof BeanCustomizer && modified) {
            this.m_mainKFPerspective.setEditedStatus(modified);
        }
    }

    private void popupCustomizer(Class<?> custClass, JComponent bc) {
        try {
            final Object customizer = custClass.newInstance();
            if (customizer instanceof EnvironmentHandler) {
                ((EnvironmentHandler)customizer).setEnvironment(this.m_flowEnvironment);
            }
            if (customizer instanceof BeanCustomizer) {
                ((BeanCustomizer)customizer).setModifiedListener(this);
            }
            ((Customizer)customizer).setObject(bc);
            final JDialog d = new JDialog((Window)((Frame)this.getTopLevelAncestor()), Dialog.ModalityType.DOCUMENT_MODAL);
            d.setLayout(new BorderLayout());
            d.getContentPane().add((Component)((JComponent)customizer), "Center");
            if (customizer instanceof CustomizerCloseRequester) {
                ((CustomizerCloseRequester)customizer).setParentWindow(d);
            }
            d.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (customizer instanceof CustomizerClosingListener) {
                        ((CustomizerClosingListener)customizer).customizerClosing();
                    }
                    d.dispose();
                }
            });
            d.pack();
            d.setLocationRelativeTo(this);
            d.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addToUserTreeNode(BeanInstance meta, boolean installListener) {
        DefaultTreeModel model = (DefaultTreeModel)this.m_componentTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        if (this.m_userCompNode == null) {
            this.m_userCompNode = new InvisibleNode("User");
            model.insertNodeInto(this.m_userCompNode, root, 0);
        }
        Vector<Object> beanHolder = new Vector<Object>();
        beanHolder.add(meta);
        try {
            StringBuffer serialized = this.copyToBuffer(beanHolder);
            String displayName = "";
            ImageIcon scaledIcon = null;
            if (meta.getBean() instanceof Visible) {
                scaledIcon = new ImageIcon(((Visible)meta.getBean()).getVisual().scale(0.33));
                displayName = ((Visible)meta.getBean()).getVisual().getText();
            }
            Vector<Object> metaDetails = new Vector<Object>();
            metaDetails.add(displayName);
            metaDetails.add(serialized);
            metaDetails.add(scaledIcon);
            SerializedObject so = new SerializedObject(metaDetails);
            Vector copy = (Vector)so.getObject();
            JTreeLeafDetails metaLeaf = new JTreeLeafDetails(displayName, copy, (Icon)scaledIcon);
            InvisibleNode newUserComp = new InvisibleNode(metaLeaf);
            model.insertNodeInto(newUserComp, this.m_userCompNode, 0);
            this.m_userComponents.add(copy);
            if (installListener && this.m_firstUserComponentOpp) {
                try {
                    this.installWindowListenerForSavingUserStuff();
                    this.m_firstUserComponentOpp = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPasteBuffer(StringBuffer b) {
        this.m_pasteBuffer = b;
        if (this.m_pasteBuffer != null && this.m_pasteBuffer.length() > 0) {
            this.m_pasteB.setEnabled(true);
        }
    }

    public StringBuffer getPasteBuffer() {
        return this.m_pasteBuffer;
    }

    public StringBuffer copyToBuffer(Vector<Object> selectedBeans) throws Exception {
        Vector<BeanConnection> associatedConnections = BeanConnection.getConnections(this.m_mainKFPerspective.getCurrentTabIndex());
        Vector<Vector<Object>> v = new Vector<Vector<Object>>();
        v.setSize(2);
        v.set(0, selectedBeans);
        v.set(1, associatedConnections);
        XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport, this.m_mainKFPerspective.getCurrentTabIndex());
        StringWriter sw = new StringWriter();
        xml.write(sw, v);
        return sw.getBuffer();
    }

    private boolean copyToClipboard() {
        Vector<Object> selectedBeans = this.m_mainKFPerspective.getSelectedBeans();
        if (selectedBeans == null || selectedBeans.size() == 0) {
            return false;
        }
        try {
            this.m_pasteBuffer = this.copyToBuffer(selectedBeans);
        }
        catch (Exception ex) {
            this.m_logPanel.logMessage("[KnowledgeFlow] problem copying beans: " + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
        this.m_pasteB.setEnabled(true);
        this.revalidate();
        this.repaint();
        this.notifyIsDirty();
        return true;
    }

    protected boolean pasteFromBuffer(int x, int y, StringBuffer pasteBuffer, boolean addUndoPoint) {
        if (addUndoPoint) {
            this.addUndoPoint();
        }
        StringReader sr = new StringReader(pasteBuffer.toString());
        try {
            int i;
            XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport, this.m_mainKFPerspective.getCurrentTabIndex());
            Vector v = (Vector)xml.read(sr);
            Vector beans = (Vector)v.get(0);
            Vector connections = (Vector)v.get(1);
            for (int i2 = 0; i2 < beans.size(); ++i2) {
                BeanInstance b = (BeanInstance)beans.get(i2);
                if (!(b.getBean() instanceof MetaBean)) continue;
                Vector<Object> subFlow = ((MetaBean)b.getBean()).getSubFlow();
                for (int j = 0; j < subFlow.size(); ++j) {
                    BeanInstance subB = (BeanInstance)subFlow.get(j);
                    subB.removeBean(this.m_beanLayout, this.m_mainKFPerspective.getCurrentTabIndex());
                    if (!(subB.getBean() instanceof Visible)) continue;
                    ((Visible)subB.getBean()).getVisual().removePropertyChangeListener(this);
                }
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            boolean adjust = false;
            for (i = 0; i < beans.size(); ++i) {
                BeanInstance b = (BeanInstance)beans.get(i);
                if (b.getX() < minX) {
                    minX = b.getX();
                    adjust = true;
                }
                if (b.getY() >= minY) continue;
                minY = b.getY();
                adjust = true;
            }
            if (adjust) {
                int deltaX = x - minX;
                int deltaY = y - minY;
                for (int i3 = 0; i3 < beans.size(); ++i3) {
                    BeanInstance b = (BeanInstance)beans.get(i3);
                    b.setXY(b.getX() + deltaX, b.getY() + deltaY);
                }
            }
            this.integrateFlow(beans, connections, false, false);
            for (i = 0; i < beans.size(); ++i) {
                this.checkForDuplicateName((BeanInstance)beans.get(i));
            }
            this.setEnvironment();
            this.notifyIsDirty();
            this.m_mainKFPerspective.setSelectedBeans(beans);
        }
        catch (Exception e) {
            this.m_logPanel.logMessage("[KnowledgeFlow] problem pasting beans: " + e.getMessage());
            e.printStackTrace();
        }
        this.revalidate();
        this.notifyIsDirty();
        return true;
    }

    private boolean pasteFromClipboard(int x, int y, StringBuffer pasteBuffer, boolean addUndoPoint) {
        return this.pasteFromBuffer(x, y, pasteBuffer, addUndoPoint);
    }

    private void deleteSelectedBeans() {
        Vector<Object> v = this.m_mainKFPerspective.getSelectedBeans();
        if (v.size() > 0) {
            this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
        }
        this.addUndoPoint();
        for (int i = 0; i < v.size(); ++i) {
            BeanInstance b = (BeanInstance)v.get(i);
            BeanConnection.removeConnections(b, this.m_mainKFPerspective.getCurrentTabIndex());
            b.removeBean(this.m_beanLayout, this.m_mainKFPerspective.getCurrentTabIndex());
            if (!(b instanceof BeanCommon)) continue;
            String key = ((BeanCommon)((Object)b)).getCustomName() + "$" + b.hashCode();
            this.m_logPanel.statusMessage(key + "|remove");
        }
        this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
        this.revalidate();
        this.notifyIsDirty();
        this.m_selectAllB.setEnabled(BeanInstance.getBeanInstances(this.m_mainKFPerspective.getCurrentTabIndex()).size() > 0);
    }

    private void addUndoPoint() {
        try {
            Stack<File> undo = this.m_mainKFPerspective.getUndoBuffer();
            File tempFile = File.createTempFile("knowledgeFlow", FILE_EXTENSION_XML);
            tempFile.deleteOnExit();
            if (this.saveLayout(tempFile, this.m_mainKFPerspective.getCurrentTabIndex(), true)) {
                undo.push(tempFile);
                if (undo.size() > 20) {
                    undo.remove(0);
                }
                this.m_undoB.setEnabled(true);
            }
        }
        catch (Exception ex) {
            this.m_logPanel.logMessage("[KnowledgeFlow] a problem occurred while trying to create a undo point : " + ex.getMessage());
        }
    }

    private boolean groupable(Vector<Object> selected, Vector<Object> inputs, Vector<Object> outputs) {
        BeanInstance temp;
        int i;
        boolean groupable = true;
        if (inputs.size() == 0 || outputs.size() == 0) {
            return false;
        }
        for (i = 0; i < selected.size(); ++i) {
            temp = (BeanInstance)selected.elementAt(i);
            if (!(temp.getBean() instanceof MetaBean)) continue;
            groupable = false;
            return false;
        }
        for (i = 0; i < inputs.size(); ++i) {
            temp = (BeanInstance)inputs.elementAt(i);
            if (!(temp.getBean() instanceof Visible)) continue;
            ((Visible)temp.getBean()).getVisual().setDisplayConnectors(true, Color.red);
        }
        for (i = 0; i < outputs.size(); ++i) {
            temp = (BeanInstance)outputs.elementAt(i);
            if (!(temp.getBean() instanceof Visible)) continue;
            ((Visible)temp.getBean()).getVisual().setDisplayConnectors(true, Color.green);
        }
        return groupable;
    }

    private void rightClickCanvasPopup(final int x, final int y) {
        Vector<BeanConnection> closestConnections = BeanConnection.getClosestConnections(new Point(x, y), 10, this.m_mainKFPerspective.getCurrentTabIndex());
        PopupMenu rightClickMenu = new PopupMenu();
        int menuItemCount = 0;
        if (this.m_mainKFPerspective.getSelectedBeans().size() > 0 || closestConnections.size() > 0 || this.m_pasteBuffer != null && this.m_pasteBuffer.length() > 0) {
            if (this.m_mainKFPerspective.getSelectedBeans().size() > 0) {
                MenuItem snapItem = new MenuItem("Snap selected to grid");
                snapItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.snapSelectedToGrid();
                    }
                });
                rightClickMenu.add(snapItem);
                ++menuItemCount;
                MenuItem copyItem = new MenuItem("Copy selected");
                copyItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.copyToClipboard();
                        KnowledgeFlowApp.this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
                    }
                });
                rightClickMenu.add(copyItem);
                ++menuItemCount;
                MenuItem cutItem = new MenuItem("Cut selected");
                cutItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (KnowledgeFlowApp.this.copyToClipboard()) {
                            KnowledgeFlowApp.this.deleteSelectedBeans();
                        }
                    }
                });
                rightClickMenu.add(cutItem);
                ++menuItemCount;
                MenuItem deleteSelected = new MenuItem("Delete selected");
                deleteSelected.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.deleteSelectedBeans();
                    }
                });
                rightClickMenu.add(deleteSelected);
                ++menuItemCount;
                final Vector<Object> selected = this.m_mainKFPerspective.getSelectedBeans();
                final Vector<Object> inputs = BeanConnection.inputs(selected, this.m_mainKFPerspective.getCurrentTabIndex());
                final Vector<Object> outputs = BeanConnection.outputs(selected, this.m_mainKFPerspective.getCurrentTabIndex());
                boolean groupable = this.groupable(selected, inputs, outputs);
                if (groupable) {
                    MenuItem groupItem = new MenuItem("Group selected");
                    groupItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            KnowledgeFlowApp.this.groupSubFlow(selected, inputs, outputs);
                        }
                    });
                    rightClickMenu.add(groupItem);
                    ++menuItemCount;
                }
            }
            if (this.m_pasteBuffer != null && this.m_pasteBuffer.length() > 0) {
                rightClickMenu.addSeparator();
                ++menuItemCount;
                MenuItem pasteItem = new MenuItem("Paste");
                pasteItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.pasteFromClipboard(x, y, KnowledgeFlowApp.this.m_pasteBuffer, true);
                    }
                });
                rightClickMenu.add(pasteItem);
                ++menuItemCount;
            }
            if (closestConnections.size() > 0) {
                rightClickMenu.addSeparator();
                MenuItem deleteConnection = new MenuItem("Delete Connection:");
                deleteConnection.setEnabled(false);
                rightClickMenu.insert(deleteConnection, ++menuItemCount);
                ++menuItemCount;
                for (int i = 0; i < closestConnections.size(); ++i) {
                    final BeanConnection bc = closestConnections.elementAt(i);
                    String connName = bc.getSourceEventSetDescriptor().getName();
                    String targetName = "";
                    if (bc.getTarget().getBean() instanceof BeanCommon) {
                        targetName = ((BeanCommon)bc.getTarget().getBean()).getCustomName();
                    } else {
                        targetName = bc.getTarget().getBean().getClass().getName();
                        targetName = targetName.substring(targetName.lastIndexOf(46) + 1, targetName.length());
                    }
                    MenuItem deleteItem = new MenuItem(connName + "-->" + targetName);
                    deleteItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            KnowledgeFlowApp.this.addUndoPoint();
                            bc.remove(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                            KnowledgeFlowApp.this.m_beanLayout.revalidate();
                            KnowledgeFlowApp.this.m_beanLayout.repaint();
                            KnowledgeFlowApp.this.m_mainKFPerspective.setEditedStatus(true);
                            if (KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans().size() > 0) {
                                KnowledgeFlowApp.this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
                            }
                            KnowledgeFlowApp.this.notifyIsDirty();
                        }
                    });
                    rightClickMenu.add(deleteItem);
                    ++menuItemCount;
                }
            }
        }
        if (menuItemCount > 0) {
            rightClickMenu.addSeparator();
            ++menuItemCount;
        }
        MenuItem noteItem = new MenuItem("New note");
        noteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Note n = new Note();
                KnowledgeFlowApp.this.m_toolBarBean = n;
                KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(1));
                KnowledgeFlowApp.this.m_mode = 3;
            }
        });
        rightClickMenu.add(noteItem);
        ++menuItemCount;
        this.m_beanLayout.add(rightClickMenu);
        double z = (double)this.m_layoutZoom / 100.0;
        double px = (double)x * z;
        double py = (double)y * z;
        rightClickMenu.show(this.m_beanLayout, (int)px, (int)py);
    }

    private void connectComponents(EventSetDescriptor esd, BeanInstance bi, int x, int y) {
        if (this.m_mainKFPerspective.getSelectedBeans(this.m_mainKFPerspective.getCurrentTabIndex()).size() > 0) {
            this.m_mainKFPerspective.setSelectedBeans(this.m_mainKFPerspective.getCurrentTabIndex(), new Vector<Object>());
        }
        this.m_sourceEventSetDescriptor = esd;
        Class<?> listenerClass = esd.getListenerType();
        JComponent source = (JComponent)bi.getBean();
        int targetCount = 0;
        Vector<Object> beanInstances = BeanInstance.getBeanInstances(this.m_mainKFPerspective.getCurrentTabIndex());
        for (int i = 0; i < beanInstances.size(); ++i) {
            JComponent bean = (JComponent)((BeanInstance)beanInstances.elementAt(i)).getBean();
            boolean connectable = false;
            boolean canContinue = false;
            if (bean != source) {
                if (bean instanceof MetaBean) {
                    if (((MetaBean)bean).canAcceptConnection(listenerClass)) {
                        canContinue = true;
                    }
                } else if (listenerClass.isInstance(bean) && bean != source) {
                    canContinue = true;
                }
            }
            if (!canContinue) continue;
            if (!(bean instanceof BeanCommon)) {
                connectable = true;
            } else if (((BeanCommon)((Object)bean)).connectionAllowed(esd)) {
                connectable = true;
            }
            if (!connectable || !(bean instanceof Visible)) continue;
            ++targetCount;
            ((Visible)((Object)bean)).getVisual().setDisplayConnectors(true);
        }
        if (targetCount > 0 && source instanceof Visible) {
            ((Visible)((Object)source)).getVisual().setDisplayConnectors(true);
            this.m_editElement = bi;
            Point closest = ((Visible)((Object)source)).getVisual().getClosestConnectorPoint(new Point(x, y));
            this.m_startX = (int)closest.getX();
            this.m_startY = (int)closest.getY();
            this.m_oldX = this.m_startX;
            this.m_oldY = this.m_startY;
            Graphics2D gx = (Graphics2D)this.m_beanLayout.getGraphics();
            gx.setXORMode(Color.white);
            gx.drawLine(this.m_startX, this.m_startY, this.m_startX, this.m_startY);
            gx.dispose();
            this.m_mode = 2;
        }
        this.revalidate();
        this.repaint();
        this.notifyIsDirty();
    }

    private void checkForDuplicateName(BeanInstance comp) {
        String currentName;
        if (comp.getBean() instanceof BeanCommon && (currentName = ((BeanCommon)comp.getBean()).getCustomName()) != null && currentName.length() > 0) {
            Vector<Object> layoutBeans = BeanInstance.getBeanInstances(this.m_mainKFPerspective.getCurrentTabIndex());
            boolean exactMatch = false;
            int maxCopyNum = 1;
            for (int i = 0; i < layoutBeans.size(); ++i) {
                BeanInstance b = (BeanInstance)layoutBeans.get(i);
                if (!(b.getBean() instanceof BeanCommon)) continue;
                String compName = ((BeanCommon)b.getBean()).getCustomName();
                if (currentName.equals(compName) && b.getBean() != comp.getBean()) {
                    exactMatch = true;
                    continue;
                }
                if (!compName.startsWith(currentName)) continue;
                String num = compName.replace(currentName, "");
                try {
                    int compNum = Integer.parseInt(num);
                    if (compNum <= maxCopyNum) continue;
                    maxCopyNum = compNum;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (exactMatch) {
                currentName = currentName + "" + ++maxCopyNum;
                ((BeanCommon)comp.getBean()).setCustomName(currentName);
            }
        }
    }

    private void addComponent(BeanInstance comp, boolean repaint) {
        if (comp.getBean() instanceof Visible) {
            ((Visible)comp.getBean()).getVisual().addPropertyChangeListener(this);
        }
        if (comp.getBean() instanceof BeanCommon) {
            ((BeanCommon)comp.getBean()).setLog(this.m_logPanel);
        }
        if (comp.getBean() instanceof MetaBean) {
            int i;
            Vector<Object> list = ((MetaBean)comp.getBean()).getInputs();
            for (i = 0; i < list.size(); ++i) {
                ((BeanInstance)list.get(i)).setX(comp.getX());
                ((BeanInstance)list.get(i)).setY(comp.getY());
            }
            list = ((MetaBean)comp.getBean()).getOutputs();
            for (i = 0; i < list.size(); ++i) {
                ((BeanInstance)list.get(i)).setX(comp.getX());
                ((BeanInstance)list.get(i)).setY(comp.getY());
            }
        }
        if (comp.getBean() instanceof EnvironmentHandler) {
            ((EnvironmentHandler)comp.getBean()).setEnvironment(this.m_flowEnvironment);
        }
        this.checkForDuplicateName(comp);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (repaint) {
            this.m_beanLayout.repaint();
        }
        this.m_pointerB.setSelected(true);
        this.m_mode = 0;
        this.m_selectAllB.setEnabled(BeanInstance.getBeanInstances(this.m_mainKFPerspective.getCurrentTabIndex()).size() > 0);
    }

    private void addComponent(int x, int y) {
        if (this.m_toolBarBean instanceof MetaBean) {
            Vector<BeanConnection> associatedConnections = ((MetaBean)this.m_toolBarBean).getAssociatedConnections();
            BeanConnection.getConnections(this.m_mainKFPerspective.getCurrentTabIndex()).addAll(associatedConnections);
            ((MetaBean)this.m_toolBarBean).addPropertyChangeListenersSubFlow(this);
        }
        if (this.m_toolBarBean instanceof BeanContextChild) {
            this.m_bcSupport.add(this.m_toolBarBean);
        }
        BeanInstance bi = new BeanInstance((JComponent)this.m_beanLayout, this.m_toolBarBean, x, y, this.m_mainKFPerspective.getCurrentTabIndex());
        this.m_toolBarBean = null;
        this.addComponent(bi, true);
    }

    private void highlightSubFlow(int startX, int startY, int endX, int endY) {
        Rectangle r = new Rectangle(startX < endX ? startX : endX, startY < endY ? startY : endY, Math.abs(startX - endX), Math.abs(startY - endY));
        Vector<Object> selected = BeanInstance.findInstances(r, this.m_mainKFPerspective.getCurrentTabIndex());
        this.m_mainKFPerspective.setSelectedBeans(selected);
    }

    private void groupSubFlow(Vector<Object> selected, Vector<Object> inputs, Vector<Object> outputs) {
        int upperLeftX = Integer.MAX_VALUE;
        int upperLeftY = Integer.MAX_VALUE;
        int lowerRightX = Integer.MIN_VALUE;
        int lowerRightY = Integer.MIN_VALUE;
        for (int i = 0; i < selected.size(); ++i) {
            BeanInstance b = (BeanInstance)selected.get(i);
            if (b.getX() < upperLeftX) {
                upperLeftX = b.getX();
            }
            if (b.getY() < upperLeftY) {
                upperLeftY = b.getY();
            }
            if (b.getX() > lowerRightX) {
                lowerRightX = b.getX();
            }
            if (b.getY() <= lowerRightY) continue;
            lowerRightY = b.getY();
        }
        int bx = upperLeftX + (lowerRightX - upperLeftX) / 2;
        int by = upperLeftY + (lowerRightY - upperLeftY) / 2;
        new Rectangle(upperLeftX, upperLeftY, lowerRightX, lowerRightY);
        int result = JOptionPane.showConfirmDialog(this, "Group this sub-flow?", "Group Components", 0);
        if (result == 0) {
            Vector<BeanConnection> associatedConnections = BeanConnection.associatedConnections(selected, this.m_mainKFPerspective.getCurrentTabIndex());
            String name = JOptionPane.showInputDialog(this, "Enter a name for this group", "MyGroup");
            if (name != null) {
                Serializable temp;
                int i;
                MetaBean group = new MetaBean();
                group.setSubFlow(selected);
                group.setAssociatedConnections(associatedConnections);
                group.setInputs(inputs);
                group.setOutputs(outputs);
                if (name.length() > 0) {
                    group.setCustomName(name);
                }
                Dimension d = group.getPreferredSize();
                int dx = (int)(d.getWidth() / 2.0);
                int dy = (int)(d.getHeight() / 2.0);
                BeanInstance bi = new BeanInstance((JComponent)this.m_beanLayout, group, bx + dx, by + dy, this.m_mainKFPerspective.getCurrentTabIndex());
                for (i = 0; i < selected.size(); ++i) {
                    temp = (BeanInstance)selected.elementAt(i);
                    ((BeanInstance)temp).removeBean(this.m_beanLayout, this.m_mainKFPerspective.getCurrentTabIndex());
                    if (!(((BeanInstance)temp).getBean() instanceof Visible)) continue;
                    ((Visible)((BeanInstance)temp).getBean()).getVisual().removePropertyChangeListener(this);
                }
                for (i = 0; i < associatedConnections.size(); ++i) {
                    temp = associatedConnections.elementAt(i);
                    ((BeanConnection)temp).setHidden(true);
                }
                group.shiftBeans(bi, true);
                this.addComponent(bi, true);
            }
        }
        for (int i = 0; i < selected.size(); ++i) {
            BeanInstance temp = (BeanInstance)selected.elementAt(i);
            if (!(temp.getBean() instanceof Visible)) continue;
            ((Visible)temp.getBean()).getVisual().setDisplayConnectors(false);
        }
        this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
        this.revalidate();
        this.notifyIsDirty();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.revalidate();
        this.m_beanLayout.repaint();
    }

    private void loadLayout() {
        this.m_loadB.setEnabled(false);
        this.m_saveB.setEnabled(false);
        this.m_playB.setEnabled(false);
        this.m_playBB.setEnabled(false);
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            String flowName;
            File oFile = this.m_FileChooser.getSelectedFile();
            if (this.m_FileChooser.getFileFilter() == this.m_KfFilter) {
                if (!oFile.getName().toLowerCase().endsWith(FILE_EXTENSION)) {
                    oFile = new File(oFile.getParent(), oFile.getName() + FILE_EXTENSION);
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
                if (!oFile.getName().toLowerCase().endsWith(".komlkf")) {
                    oFile = new File(oFile.getParent(), oFile.getName() + ".koml" + "kf");
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter) {
                if (!oFile.getName().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                    oFile = new File(oFile.getParent(), oFile.getName() + FILE_EXTENSION_XML);
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_XStreamFilter && !oFile.getName().toLowerCase().endsWith(".xstreamkf")) {
                oFile = new File(oFile.getParent(), oFile.getName() + ".xstream" + "kf");
            }
            if ((flowName = oFile.getName()).lastIndexOf(46) > 0) {
                flowName = flowName.substring(0, flowName.lastIndexOf(46));
            }
            this.loadLayout(oFile, this.getAllowMultipleTabs());
        }
        this.m_loadB.setEnabled(true);
        this.m_playB.setEnabled(true);
        this.m_playBB.setEnabled(true);
        this.m_saveB.setEnabled(true);
    }

    public void loadLayout(File oFile, boolean newTab) {
        this.loadLayout(oFile, newTab, false);
    }

    protected void loadLayout(File oFile, boolean newTab, boolean isUndo) {
        if (!newTab) {
            this.stopFlow();
        }
        this.m_loadB.setEnabled(false);
        this.m_saveB.setEnabled(false);
        this.m_playB.setEnabled(false);
        this.m_playBB.setEnabled(false);
        if (newTab) {
            String flowName = oFile.getName();
            if (flowName.lastIndexOf(46) > 0) {
                flowName = flowName.substring(0, flowName.lastIndexOf(46));
            }
            this.m_mainKFPerspective.addTab(flowName);
            this.m_mainKFPerspective.setFlowFile(oFile);
            this.m_mainKFPerspective.setEditedStatus(false);
        }
        if (!isUndo) {
            File absolute = new File(oFile.getAbsolutePath());
            this.m_mainKFPerspective.getEnvironmentSettings().addVariable("Internal.knowledgeflow.directory", absolute.getParent());
        }
        try {
            Vector beans = new Vector();
            Vector connections = new Vector();
            if (KOML.isPresent() && oFile.getAbsolutePath().toLowerCase().endsWith(".komlkf")) {
                Vector v = (Vector)KOML.read(oFile.getAbsolutePath());
                beans = (Vector)v.get(0);
                connections = (Vector)v.get(1);
            } else if (XStream.isPresent() && oFile.getAbsolutePath().toLowerCase().endsWith(".xstreamkf")) {
                Vector v = (Vector)XStream.read(oFile.getAbsolutePath());
                beans = (Vector)v.get(0);
                connections = (Vector)v.get(1);
            } else if (oFile.getAbsolutePath().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport, this.m_mainKFPerspective.getCurrentTabIndex());
                Vector v = (Vector)xml.read(oFile);
                beans = (Vector)v.get(0);
                connections = (Vector)v.get(1);
            } else {
                FileInputStream is = new FileInputStream(oFile);
                ObjectInputStream ois = new ObjectInputStream(is);
                beans = (Vector)ois.readObject();
                connections = (Vector)ois.readObject();
                ois.close();
            }
            this.integrateFlow(beans, connections, true, false);
            this.setEnvironment();
            if (newTab) {
                this.m_logPanel.clearStatus();
                this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|Flow loaded.");
            }
        }
        catch (Exception ex) {
            this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|Unable to load flow (see log).");
            this.m_logPanel.logMessage("[KnowledgeFlow] Unable to load flow (" + ex.getMessage() + ").");
            ex.printStackTrace();
        }
        this.m_loadB.setEnabled(true);
        this.m_saveB.setEnabled(true);
        this.m_playB.setEnabled(true);
        this.m_playBB.setEnabled(true);
    }

    public void loadLayout(InputStream is, boolean newTab, String flowName) throws Exception {
        InputStreamReader isr = new InputStreamReader(is);
        this.loadLayout(isr, newTab, flowName);
    }

    public void loadLayout(Reader reader, boolean newTab, String flowName) throws Exception {
        if (!newTab) {
            this.stopFlow();
        }
        this.m_loadB.setEnabled(false);
        this.m_saveB.setEnabled(false);
        this.m_playB.setEnabled(false);
        this.m_playBB.setEnabled(false);
        if (newTab) {
            this.m_mainKFPerspective.addTab(flowName);
            this.m_mainKFPerspective.setEditedStatus(false);
        }
        XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport, this.m_mainKFPerspective.getCurrentTabIndex());
        Vector v = (Vector)xml.read(reader);
        Vector beans = (Vector)v.get(0);
        Vector connections = (Vector)v.get(1);
        this.integrateFlow(beans, connections, true, false);
        this.setEnvironment();
        if (newTab) {
            this.m_logPanel.clearStatus();
            this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|Flow loaded.");
        }
        this.m_loadB.setEnabled(true);
        this.m_saveB.setEnabled(true);
        this.m_playB.setEnabled(true);
        this.m_playBB.setEnabled(true);
    }

    protected void integrateFlow(Vector<Object> beans, Vector<BeanConnection> connections, boolean replace, boolean notReplaceAndSourcedFromBinary) {
        Color bckC = this.getBackground();
        this.m_bcSupport = new BeanContextSupport();
        this.m_bcSupport.setDesignTime(true);
        for (int i = 0; i < beans.size(); ++i) {
            BeanInstance tempB = (BeanInstance)beans.elementAt(i);
            if (tempB.getBean() instanceof Visible) {
                ((Visible)tempB.getBean()).getVisual().addPropertyChangeListener(this);
                ((Visible)tempB.getBean()).getVisual().setBackground(bckC);
                ((JComponent)tempB.getBean()).setBackground(bckC);
            }
            if (tempB.getBean() instanceof BeanCommon) {
                ((BeanCommon)tempB.getBean()).setLog(this.m_logPanel);
            }
            if (!(tempB.getBean() instanceof BeanContextChild)) continue;
            this.m_bcSupport.add(tempB.getBean());
        }
        if (replace) {
            BeanInstance.setBeanInstances(beans, this.m_beanLayout, this.m_mainKFPerspective.getCurrentTabIndex());
            BeanConnection.setConnections(connections, this.m_mainKFPerspective.getCurrentTabIndex());
        } else if (notReplaceAndSourcedFromBinary) {
            BeanInstance.appendBeans(this.m_beanLayout, beans, this.m_mainKFPerspective.getCurrentTabIndex());
            BeanConnection.appendConnections(connections, this.m_mainKFPerspective.getCurrentTabIndex());
        }
        this.revalidate();
        this.m_beanLayout.revalidate();
        this.m_beanLayout.repaint();
        this.notifyIsDirty();
        this.m_selectAllB.setEnabled(BeanInstance.getBeanInstances(this.m_mainKFPerspective.getCurrentTabIndex()).size() > 0);
    }

    public void setFlow(Vector<Vector<?>> v) throws Exception {
        if (this.getAllowMultipleTabs()) {
            throw new Exception("[KnowledgeFlow] setFlow() - can only set a flow in singe tab only mode");
        }
        this.m_beanLayout.removeAll();
        BeanInstance.init();
        BeanConnection.init();
        SerializedObject so = new SerializedObject(v);
        Vector copy = (Vector)so.getObject();
        Vector beans = (Vector)copy.elementAt(0);
        Vector connections = (Vector)copy.elementAt(1);
        this.m_flowEnvironment = new Environment();
        this.integrateFlow(beans, connections, true, false);
        this.revalidate();
        this.notifyIsDirty();
    }

    public Vector<Vector<?>> getFlow() throws Exception {
        Vector<Vector<Object>> v = new Vector<Vector<Object>>();
        Vector<Object> beans = BeanInstance.getBeanInstances(this.m_mainKFPerspective.getCurrentTabIndex());
        Vector<BeanConnection> connections = BeanConnection.getConnections(this.m_mainKFPerspective.getCurrentTabIndex());
        this.detachFromLayout(beans);
        v.add(beans);
        v.add(connections);
        SerializedObject so = new SerializedObject(v);
        Vector copy = (Vector)so.getObject();
        this.integrateFlow(beans, connections, true, false);
        return copy;
    }

    public String getFlowXML() throws Exception {
        Vector<Object> beans = BeanInstance.getBeanInstances(this.m_mainKFPerspective.getCurrentTabIndex());
        StringBuffer buff = this.copyToBuffer(beans);
        return buff.toString();
    }

    protected static BufferedImage createImage(JComponent component, Rectangle region) throws IOException {
        boolean opaqueValue = component.isOpaque();
        component.setOpaque(true);
        BufferedImage image = new BufferedImage(region.width, region.height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.translate(-region.getX(), -region.getY());
        component.paint(g2d);
        g2d.dispose();
        component.setOpaque(opaqueValue);
        return image;
    }

    private void detachFromLayout(Vector<Object> beans) {
        for (int i = 0; i < beans.size(); ++i) {
            BeanInstance tempB = (BeanInstance)beans.elementAt(i);
            if (!(tempB.getBean() instanceof Visible)) continue;
            ((Visible)tempB.getBean()).getVisual().removePropertyChangeListener(this);
            if (tempB.getBean() instanceof MetaBean) {
                ((MetaBean)tempB.getBean()).removePropertyChangeListenersSubFlow(this);
            }
            ((Visible)tempB.getBean()).getVisual().setBackground(Color.white);
            ((JComponent)tempB.getBean()).setBackground(Color.white);
        }
    }

    public void saveLayout(File toFile, int tabIndex) {
        this.saveLayout(toFile, tabIndex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveLayout(File sFile, int tabIndex, boolean isUndoPoint) {
        Color bckC = this.getBackground();
        Vector<Object> beans = BeanInstance.getBeanInstances(tabIndex);
        this.detachFromLayout(beans);
        this.detachFromLayout(beans);
        try {
            Vector<Vector<Object>> v;
            if (KOML.isPresent() && sFile.getAbsolutePath().toLowerCase().endsWith(".komlkf")) {
                v = new Vector<Vector<Object>>();
                v.setSize(2);
                v.set(0, beans);
                v.set(1, BeanConnection.getConnections(tabIndex));
                KOML.write(sFile.getAbsolutePath(), v);
            } else if (XStream.isPresent() && sFile.getAbsolutePath().toLowerCase().endsWith(".xstreamkf")) {
                v = new Vector();
                v.setSize(2);
                v.set(0, beans);
                v.set(1, BeanConnection.getConnections(tabIndex));
                XStream.write(sFile.getAbsolutePath(), v);
            } else if (sFile.getAbsolutePath().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                v = new Vector();
                v.setSize(2);
                v.set(0, beans);
                v.set(1, BeanConnection.getConnections(tabIndex));
                XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport, tabIndex);
                BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sFile), "UTF-8"));
                xml.write(br, v);
            } else {
                FileOutputStream os = new FileOutputStream(sFile);
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(beans);
                oos.writeObject(BeanConnection.getConnections(tabIndex));
                oos.flush();
                oos.close();
            }
        }
        catch (Exception ex) {
            this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|Unable to save flow (see log).");
            this.m_logPanel.logMessage("[KnowledgeFlow] Unable to save flow (" + ex.getMessage() + ").");
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            for (int i = 0; i < beans.size(); ++i) {
                BeanInstance tempB = (BeanInstance)beans.elementAt(i);
                if (!(tempB.getBean() instanceof Visible)) continue;
                ((Visible)tempB.getBean()).getVisual().addPropertyChangeListener(this);
                if (tempB.getBean() instanceof MetaBean) {
                    ((MetaBean)tempB.getBean()).addPropertyChangeListenersSubFlow(this);
                }
                ((Visible)tempB.getBean()).getVisual().setBackground(bckC);
                ((JComponent)tempB.getBean()).setBackground(bckC);
            }
            if (!isUndoPoint) {
                Environment e = this.m_mainKFPerspective.getEnvironmentSettings(tabIndex);
                e.addVariable("Internal.knowledgeflow.directory", new File(sFile.getAbsolutePath()).getParent());
                this.m_mainKFPerspective.setEditedStatus(tabIndex, false);
                String tabTitle = sFile.getName();
                tabTitle = tabTitle.substring(0, tabTitle.lastIndexOf(46));
                this.m_mainKFPerspective.setTabTitle(tabIndex, tabTitle);
            }
        }
        return true;
    }

    private void saveLayout(int tabIndex, boolean showDialog) {
        this.getBackground();
        File sFile = this.m_mainKFPerspective.getFlowFile(tabIndex);
        int returnVal = 0;
        boolean shownDialog = false;
        if (showDialog || sFile.getName().equals("-NONE-")) {
            returnVal = this.m_FileChooser.showSaveDialog(this);
            shownDialog = true;
        }
        if (returnVal == 0) {
            Vector<Object> beans = BeanInstance.getBeanInstances(tabIndex);
            this.detachFromLayout(beans);
            if (shownDialog) {
                sFile = this.m_FileChooser.getSelectedFile();
            }
            if (this.m_FileChooser.getFileFilter() == this.m_KfFilter) {
                if (!sFile.getName().toLowerCase().endsWith(FILE_EXTENSION)) {
                    sFile = new File(sFile.getParent(), sFile.getName() + FILE_EXTENSION);
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
                if (!sFile.getName().toLowerCase().endsWith(".komlkf")) {
                    sFile = new File(sFile.getParent(), sFile.getName() + ".koml" + "kf");
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_XStreamFilter) {
                if (!sFile.getName().toLowerCase().endsWith(".xstreamkf")) {
                    sFile = new File(sFile.getParent(), sFile.getName() + ".xstream" + "kf");
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !sFile.getName().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                sFile = new File(sFile.getParent(), sFile.getName() + FILE_EXTENSION_XML);
            }
            this.saveLayout(sFile, this.m_mainKFPerspective.getCurrentTabIndex(), false);
            this.m_mainKFPerspective.setFlowFile(tabIndex, sFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLayout(OutputStream out, int tabIndex) {
        BeanInstance tempB;
        Vector<Object> beans = BeanInstance.getBeanInstances(tabIndex);
        for (int i = 0; i < beans.size(); ++i) {
            tempB = (BeanInstance)beans.elementAt(i);
            if (!(tempB.getBean() instanceof Visible)) continue;
            ((Visible)tempB.getBean()).getVisual().removePropertyChangeListener(this);
            if (!(tempB.getBean() instanceof MetaBean)) continue;
            ((MetaBean)tempB.getBean()).removePropertyChangeListenersSubFlow(this);
        }
        try {
            Vector<Vector<Object>> v = new Vector<Vector<Object>>();
            v.setSize(2);
            v.set(0, beans);
            v.set(1, BeanConnection.getConnections(tabIndex));
            XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport, tabIndex);
            xml.write(out, v);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            for (int i = 0; i < beans.size(); ++i) {
                tempB = (BeanInstance)beans.elementAt(i);
                if (!(tempB.getBean() instanceof Visible)) continue;
                ((Visible)tempB.getBean()).getVisual().addPropertyChangeListener(this);
                if (!(tempB.getBean() instanceof MetaBean)) continue;
                ((MetaBean)tempB.getBean()).addPropertyChangeListenersSubFlow(this);
            }
        }
    }

    private void loadUserComponents() {
        Vector tempV = null;
        File sFile = new File(WekaPackageManager.WEKA_HOME.getPath() + File.separator + "knowledgeFlow" + File.separator + "userComponents");
        if (sFile.exists()) {
            try {
                FileInputStream is = new FileInputStream(sFile);
                ObjectInputStream ois = new ObjectInputStream(is);
                tempV = (Vector)ois.readObject();
                ois.close();
            }
            catch (Exception ex) {
                Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Problem reading user components.");
                ex.printStackTrace();
                return;
            }
            if (tempV.size() > 0) {
                DefaultTreeModel model = (DefaultTreeModel)this.m_componentTree.getModel();
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                if (this.m_userCompNode == null) {
                    this.m_userCompNode = new InvisibleNode("User");
                    model.insertNodeInto(this.m_userCompNode, root, 0);
                }
                for (int i = 0; i < tempV.size(); ++i) {
                    Vector tempB = (Vector)tempV.elementAt(i);
                    String displayName = (String)tempB.get(0);
                    tempB.get(1);
                    ImageIcon scaledIcon = (ImageIcon)tempB.get(2);
                    JTreeLeafDetails treeLeaf = new JTreeLeafDetails(displayName, tempB, (Icon)scaledIcon);
                    InvisibleNode newUserComp = new InvisibleNode(treeLeaf);
                    model.insertNodeInto(newUserComp, this.m_userCompNode, 0);
                    this.m_userComponents.add(tempB);
                }
            }
        }
    }

    private void installWindowListenerForSavingUserStuff() {
        ((Window)this.getTopLevelAncestor()).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Logger.log(Logger.Level.INFO, "[KnowledgeFlow] Saving user components....");
                File sFile = new File(WekaPackageManager.WEKA_HOME.getPath() + File.separator + "knowledgeFlow");
                if (!sFile.exists() && !sFile.mkdir()) {
                    Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Unable to create \"" + sFile.getPath() + "\" directory");
                }
                try {
                    String ext = "";
                    File sFile2 = new File(sFile.getAbsolutePath() + File.separator + "userComponents" + ext);
                    FileOutputStream os = new FileOutputStream(sFile2);
                    ObjectOutputStream oos = new ObjectOutputStream(os);
                    oos.writeObject(KnowledgeFlowApp.this.m_userComponents);
                    oos.flush();
                    oos.close();
                }
                catch (Exception ex) {
                    Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Unable to save user components");
                    ex.printStackTrace();
                }
                Logger.log(Logger.Level.INFO, "Saving preferences for selected perspectives...");
                sFile = new File(WekaPackageManager.PROPERTIES_DIR.toString() + File.separator + "VisiblePerspectives.props");
                try {
                    FileWriter f = new FileWriter(sFile);
                    f.write("weka.gui.beans.KnowledgeFlow.SelectedPerspectives=");
                    int i = 0;
                    for (String p : BeansProperties.VISIBLE_PERSPECTIVES) {
                        if (i > 0) {
                            f.write(",");
                        }
                        f.write(p);
                        ++i;
                    }
                    f.write("\n");
                    f.write("weka.gui.beans.KnowledgeFlow.PerspectiveToolBarVisisble=" + (KnowledgeFlowApp.this.m_configAndPerspectivesVisible ? "yes" : "no"));
                    f.write("\n");
                    f.close();
                }
                catch (Exception ex) {
                    Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Unable to save user perspectives preferences");
                    ex.printStackTrace();
                }
            }
        });
    }

    public static String getGlobalInfo(Object tempBean) {
        return Utils.getGlobalInfo(tempBean, true);
    }

    public static void createSingleton(String[] args) {
        String fileName = null;
        boolean showFileMenu = true;
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if (arg.startsWith("file=")) {
                    fileName = arg.substring("file=".length());
                    continue;
                }
                if (!arg.startsWith("showFileMenu=")) continue;
                showFileMenu = Boolean.parseBoolean(arg.substring("showFileMenu=".length()));
            }
        }
        if (m_knowledgeFlow == null) {
            m_knowledgeFlow = new KnowledgeFlowApp(showFileMenu);
        }
        for (int i = 0; i < s_startupListeners.size(); ++i) {
            s_startupListeners.elementAt(i).startUpComplete();
        }
        if (fileName != null) {
            m_knowledgeFlow.loadInitialLayout(fileName);
        }
    }

    public static void disposeSingleton() {
        m_knowledgeFlow = null;
    }

    public static KnowledgeFlowApp getSingleton() {
        return m_knowledgeFlow;
    }

    public static void addStartupListener(StartUpListener s) {
        s_startupListeners.add(s);
    }

    private void loadInitialLayout(String fileName) {
        File oFile = new File(fileName);
        if (oFile.exists() && oFile.isFile()) {
            this.m_FileChooser.setSelectedFile(oFile);
            int index = fileName.lastIndexOf(46);
            if (index != -1) {
                String extension = fileName.substring(index);
                if (FILE_EXTENSION_XML.equalsIgnoreCase(extension)) {
                    this.m_FileChooser.setFileFilter(KnowledgeFlowApp.m_knowledgeFlow.m_XMLFilter);
                } else if (FILE_EXTENSION.equalsIgnoreCase(extension)) {
                    this.m_FileChooser.setFileFilter(KnowledgeFlowApp.m_knowledgeFlow.m_KfFilter);
                }
            }
        } else {
            Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] File '" + fileName + "' does not exists.");
        }
        this.loadLayout(oFile, true);
    }

    public void setAllowMultipleTabs(boolean multiple) {
        this.m_allowMultipleTabs = multiple;
        if (!multiple) {
            this.m_newB.setEnabled(false);
            if (this.m_configAndPerspectives != null) {
                this.remove(this.m_configAndPerspectives);
            }
        }
    }

    public boolean getAllowMultipleTabs() {
        return this.m_allowMultipleTabs;
    }

    private void notifyIsDirty() {
        this.firePropertyChange("PROP_DIRTY", null, null);
    }

    public static void main(String[] args) {
        LookAndFeel.setLookAndFeel();
        try {
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].toLowerCase().endsWith(FILE_EXTENSION) && !args[i].toLowerCase().endsWith(FILE_EXTENSION_XML)) continue;
                args[i] = "file=" + args[i];
            }
            KnowledgeFlowApp.createSingleton(args);
            Image icon = Toolkit.getDefaultToolkit().getImage(m_knowledgeFlow.getClass().getClassLoader().getResource("weka/gui/weka_icon_new_48.png"));
            jf.setIconImage(icon);
            jf.getContentPane().add((Component)m_knowledgeFlow, "Center");
            jf.setDefaultCloseOperation(3);
            jf.setSize(1024, 768);
            jf.setVisible(true);
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        jf.dispose();
                        m_knowledgeFlow = null;
                        System.gc();
                        System.err.println("\n[KnowledgeFlow] displayed message:");
                        m_Memory.showOutOfMemory();
                        System.err.println("\nexiting");
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(5);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
        s_startupListeners = new Vector();
    }

    protected class RunThread
    extends Thread {
        int m_flowIndex;
        boolean m_sequential;
        boolean m_wasUserStopped = false;

        public RunThread(boolean sequential) {
            this.m_sequential = sequential;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.m_flowIndex = KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex();
            String flowName = KnowledgeFlowApp.this.m_mainKFPerspective.getTabTitle(this.m_flowIndex);
            KnowledgeFlowApp.this.m_mainKFPerspective.setExecuting(true);
            KnowledgeFlowApp.this.m_mainKFPerspective.getLogPanel(this.m_flowIndex).clearStatus();
            KnowledgeFlowApp.this.m_mainKFPerspective.getLogPanel(this.m_flowIndex).statusMessage("@!@[KnowledgeFlow]|Executing...");
            FlowRunner runner = new FlowRunner(false, false);
            runner.setStartSequentially(this.m_sequential);
            runner.setEnvironment(KnowledgeFlowApp.this.m_flowEnvironment);
            runner.setLog(KnowledgeFlowApp.this.m_logPanel);
            Vector<Object> comps = BeanInstance.getBeanInstances(this.m_flowIndex);
            runner.setFlows(comps);
            try {
                runner.run();
                runner.waitUntilFinished();
            }
            catch (InterruptedException lp) {
            }
            catch (Exception ex) {
                KnowledgeFlowApp.this.m_logPanel.logMessage("An error occurred while running the flow: " + ex.getMessage());
            }
            finally {
                if (this.m_flowIndex >= KnowledgeFlowApp.this.m_mainKFPerspective.getNumTabs() - 1 || !KnowledgeFlowApp.this.m_mainKFPerspective.getTabTitle(this.m_flowIndex).equals(flowName)) {
                    for (int i = 0; i < KnowledgeFlowApp.this.m_mainKFPerspective.getNumTabs(); ++i) {
                        String tabT = KnowledgeFlowApp.this.m_mainKFPerspective.getTabTitle(i);
                        if (tabT == null || !tabT.equals(flowName)) continue;
                        this.m_flowIndex = i;
                        break;
                    }
                }
                KnowledgeFlowApp.this.m_mainKFPerspective.setExecuting(this.m_flowIndex, false);
                KnowledgeFlowApp.this.m_mainKFPerspective.setExecutionThread(this.m_flowIndex, null);
                if (this.m_wasUserStopped) {
                    KFLogPanel lp = KnowledgeFlowApp.this.m_mainKFPerspective.getLogPanel(this.m_flowIndex);
                    lp.setMessageOnAll(false, "Stopped.");
                } else {
                    KnowledgeFlowApp.this.m_mainKFPerspective.getLogPanel(this.m_flowIndex).statusMessage("@!@[KnowledgeFlow]|OK.");
                }
            }
        }

        public void stopAllFlows() {
            Vector<Object> components = BeanInstance.getBeanInstances(this.m_flowIndex);
            if (components != null) {
                for (int i = 0; i < components.size(); ++i) {
                    Object temp = ((BeanInstance)components.elementAt(i)).getBean();
                    if (!(temp instanceof BeanCommon)) continue;
                    ((BeanCommon)temp).stop();
                }
                this.m_wasUserStopped = true;
            }
        }
    }

    protected class KFLogPanel
    extends LogPanel {
        private static final long serialVersionUID = -2224509243343105276L;

        protected KFLogPanel() {
        }

        public synchronized void setMessageOnAll(boolean mainKFLine, String message) {
            for (String key : this.m_tableIndexes.keySet()) {
                if (!mainKFLine && key.equals("[KnowledgeFlow]")) continue;
                String tm = key + "|" + message;
                this.statusMessage(tm);
            }
        }
    }

    private class CloseableTabTitle
    extends JPanel {
        private static final long serialVersionUID = -6844232025394346426L;
        private final JTabbedPane m_enclosingPane;
        private JLabel m_tabLabel;
        private TabButton m_tabButton;

        public CloseableTabTitle(JTabbedPane pane) {
            super(new FlowLayout(0, 0, 0));
            this.m_enclosingPane = pane;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.m_tabLabel = new JLabel(){
                private static final long serialVersionUID = 8515052190461050324L;

                @Override
                public String getText() {
                    int index = CloseableTabTitle.this.m_enclosingPane.indexOfTabComponent(CloseableTabTitle.this);
                    if (index >= 0) {
                        return CloseableTabTitle.this.m_enclosingPane.getTitleAt(index);
                    }
                    return null;
                }
            };
            this.add(this.m_tabLabel);
            this.m_tabLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.m_tabButton = new TabButton();
            this.add(this.m_tabButton);
        }

        public void setBold(boolean bold) {
            this.m_tabLabel.setEnabled(bold);
        }

        public void setButtonEnabled(boolean enabled) {
            this.m_tabButton.setEnabled(enabled);
        }

        private class TabButton
        extends JButton
        implements ActionListener {
            private static final long serialVersionUID = -4915800749132175968L;

            public TabButton() {
                int size = 17;
                this.setPreferredSize(new Dimension(size, size));
                this.setToolTipText("close this tab");
                this.setUI(new BasicButtonUI());
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.setBorderPainted(false);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        Component component = e.getComponent();
                        if (component instanceof AbstractButton) {
                            AbstractButton button = (AbstractButton)component;
                            button.setBorderPainted(true);
                            int i = CloseableTabTitle.this.m_enclosingPane.indexOfTabComponent(CloseableTabTitle.this);
                            if (i == KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()) {
                                button.setToolTipText("close this tab (Ctrl+W)");
                            } else {
                                button.setToolTipText("close this tab");
                            }
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        Component component = e.getComponent();
                        if (component instanceof AbstractButton) {
                            AbstractButton button = (AbstractButton)component;
                            button.setBorderPainted(false);
                        }
                    }
                });
                this.setRolloverEnabled(true);
                this.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = CloseableTabTitle.this.m_enclosingPane.indexOfTabComponent(CloseableTabTitle.this);
                if (i >= 0 && KnowledgeFlowApp.this.getAllowMultipleTabs()) {
                    KnowledgeFlowApp.this.m_mainKFPerspective.removeTab(i);
                }
            }

            @Override
            public void updateUI() {
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(Color.BLACK);
                if (!this.isEnabled()) {
                    g2.setColor(Color.GRAY);
                }
                if (this.getModel().isRollover()) {
                    g2.setColor(Color.MAGENTA);
                }
                int delta = 6;
                g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
                g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
                g2.dispose();
            }
        }
    }

    public class MainKFPerspective
    extends JPanel
    implements KFPerspective {
        private static final long serialVersionUID = 7666381888012259527L;
        protected JTabbedPane m_flowTabs = new JTabbedPane();
        protected List<BeanLayout> m_beanLayouts = new ArrayList<BeanLayout>();
        protected List<Integer> m_zoomSettings = new ArrayList<Integer>();
        protected List<KFLogPanel> m_logPanels = new ArrayList<KFLogPanel>();
        protected List<Environment> m_environmentSettings = new ArrayList<Environment>();
        protected List<File> m_filePaths = new ArrayList<File>();
        protected List<Boolean> m_editedList = new ArrayList<Boolean>();
        protected List<Boolean> m_executingList = new ArrayList<Boolean>();
        protected List<RunThread> m_executionThreads = new ArrayList<RunThread>();
        protected List<Vector<Object>> m_selectedBeans = new ArrayList<Vector<Object>>();
        protected List<Stack<File>> m_undoBufferList = new ArrayList<Stack<File>>();
        protected Map<String, DefaultMutableTreeNode> m_nodeTextIndex = new LinkedHashMap<String, DefaultMutableTreeNode>();

        @Override
        public void setActive(boolean active) {
        }

        @Override
        public void setLoaded(boolean loaded) {
        }

        @Override
        public void setMainKFPerspective(MainKFPerspective main) {
        }

        public JTabbedPane getTabbedPane() {
            return this.m_flowTabs;
        }

        public synchronized int getNumTabs() {
            return this.m_flowTabs.getTabCount();
        }

        public synchronized String getTabTitle(int index) {
            if (index < this.getNumTabs() && index >= 0) {
                return this.m_flowTabs.getTitleAt(index);
            }
            return null;
        }

        public synchronized int getCurrentTabIndex() {
            return this.m_flowTabs.getSelectedIndex();
        }

        public synchronized KFLogPanel getCurrentLogPanel() {
            if (this.getCurrentTabIndex() >= 0) {
                return this.m_logPanels.get(this.getCurrentTabIndex());
            }
            return null;
        }

        public synchronized KFLogPanel getLogPanel(int index) {
            if (index >= 0 && index < this.m_logPanels.size()) {
                return this.m_logPanels.get(index);
            }
            return null;
        }

        public synchronized BeanLayout getCurrentBeanLayout() {
            if (this.getCurrentTabIndex() >= 0) {
                return this.m_beanLayouts.get(this.getCurrentTabIndex());
            }
            return null;
        }

        public synchronized BeanLayout getBeanLayout(int index) {
            if (index >= 0 && index < this.m_logPanels.size()) {
                return this.m_beanLayouts.get(this.getCurrentTabIndex());
            }
            return null;
        }

        public synchronized int getCurrentZoomSetting() {
            if (this.getCurrentTabIndex() >= 0) {
                return this.m_zoomSettings.get(this.getCurrentTabIndex());
            }
            return 100;
        }

        public synchronized int getZoomSetting(int index) {
            if (index >= 0 && index < this.m_zoomSettings.size()) {
                return this.m_zoomSettings.get(index);
            }
            return 100;
        }

        public synchronized void setCurrentZoomSetting(int z) {
            if (this.getNumTabs() > 0) {
                this.setZoomSetting(this.getCurrentTabIndex(), z);
            }
        }

        public synchronized void setZoomSetting(int index, int z) {
            if (index < this.getNumTabs() && index >= 0) {
                this.m_zoomSettings.set(index, new Integer(z));
            }
        }

        public synchronized void setActiveTab(int index) {
            if (index < this.getNumTabs() && index >= 0) {
                Vector<Object> outputs;
                Vector<Object> inputs;
                Vector<Object> selected;
                this.m_flowTabs.setSelectedIndex(index);
                KnowledgeFlowApp.this.m_logPanel = this.m_logPanels.get(index);
                KnowledgeFlowApp.this.m_beanLayout = this.m_beanLayouts.get(index);
                KnowledgeFlowApp.this.m_layoutZoom = this.m_zoomSettings.get(index);
                KnowledgeFlowApp.this.m_flowEnvironment = this.m_environmentSettings.get(index);
                KnowledgeFlowApp.this.m_saveB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_saveBB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_playB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_playBB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_saveB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_saveBB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_zoomOutB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_zoomInB.setEnabled(!this.getExecuting());
                if (KnowledgeFlowApp.this.m_layoutZoom == 50) {
                    KnowledgeFlowApp.this.m_zoomOutB.setEnabled(false);
                }
                if (KnowledgeFlowApp.this.m_layoutZoom == 200) {
                    KnowledgeFlowApp.this.m_zoomInB.setEnabled(false);
                }
                KnowledgeFlowApp.this.m_groupB.setEnabled(false);
                if (this.getSelectedBeans().size() > 0 && !this.getExecuting() && KnowledgeFlowApp.this.groupable(selected = KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans(), inputs = BeanConnection.inputs(selected, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()), outputs = BeanConnection.outputs(selected, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()))) {
                    KnowledgeFlowApp.this.m_groupB.setEnabled(true);
                }
                KnowledgeFlowApp.this.m_cutB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_copyB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_deleteB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_selectAllB.setEnabled(BeanInstance.getBeanInstances(this.getCurrentTabIndex()).size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_pasteB.setEnabled(KnowledgeFlowApp.this.m_pasteBuffer != null && KnowledgeFlowApp.this.m_pasteBuffer.length() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_stopB.setEnabled(this.getExecuting());
                KnowledgeFlowApp.this.m_undoB.setEnabled(!this.getExecuting() && this.getUndoBuffer().size() > 0);
            }
        }

        public synchronized void setExecuting(boolean executing) {
            if (this.getNumTabs() > 0) {
                this.setExecuting(this.getCurrentTabIndex(), executing);
            }
        }

        public synchronized void setExecuting(int index, boolean executing) {
            if (index < this.getNumTabs() && index >= 0) {
                Vector<Object> outputs;
                Vector<Object> inputs;
                Vector<Object> selected;
                this.m_executingList.set(index, new Boolean(executing));
                ((CloseableTabTitle)this.m_flowTabs.getTabComponentAt(index)).setButtonEnabled(!executing);
                KnowledgeFlowApp.this.m_saveB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_saveBB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_playB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_playBB.setEnabled(!this.getExecuting());
                KnowledgeFlowApp.this.m_stopB.setEnabled(this.getExecuting());
                KnowledgeFlowApp.this.m_groupB.setEnabled(false);
                if (this.getSelectedBeans().size() > 0 && !this.getExecuting() && KnowledgeFlowApp.this.groupable(selected = KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans(), inputs = BeanConnection.inputs(selected, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()), outputs = BeanConnection.outputs(selected, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()))) {
                    KnowledgeFlowApp.this.m_groupB.setEnabled(true);
                }
                KnowledgeFlowApp.this.m_cutB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_deleteB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_selectAllB.setEnabled(BeanInstance.getBeanInstances(this.getCurrentTabIndex()).size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_copyB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_pasteB.setEnabled(KnowledgeFlowApp.this.m_pasteBuffer != null && KnowledgeFlowApp.this.m_pasteBuffer.length() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_undoB.setEnabled(!this.getExecuting() && this.getUndoBuffer().size() > 0);
            }
        }

        public synchronized boolean getExecuting() {
            return this.getExecuting(this.getCurrentTabIndex());
        }

        public synchronized boolean getExecuting(int index) {
            if (index < this.getNumTabs() && index >= 0) {
                return this.m_executingList.get(index);
            }
            return false;
        }

        public synchronized void setExecutionThread(RunThread execution) {
            if (this.getNumTabs() > 0) {
                this.setExecutionThread(this.getCurrentTabIndex(), execution);
            }
        }

        public synchronized void setExecutionThread(int index, RunThread execution) {
            if (index < this.getNumTabs() && index >= 0) {
                this.m_executionThreads.set(index, execution);
            }
        }

        public synchronized RunThread getExecutionThread() {
            return this.getExecutionThread(this.getCurrentTabIndex());
        }

        public synchronized RunThread getExecutionThread(int index) {
            if (index < this.getNumTabs() && index >= 0) {
                return this.m_executionThreads.get(index);
            }
            return null;
        }

        public synchronized File getFlowFile() {
            if (this.getNumTabs() > 0) {
                return this.getFlowFile(this.getCurrentTabIndex());
            }
            return null;
        }

        public synchronized File getFlowFile(int index) {
            if (index >= 0 && index < this.getNumTabs()) {
                return this.m_filePaths.get(index);
            }
            return null;
        }

        public synchronized void setFlowFile(File flowFile) {
            if (this.getNumTabs() > 0) {
                this.setFlowFile(this.getCurrentTabIndex(), flowFile);
            }
        }

        public synchronized void setFlowFile(int index, File flowFile) {
            if (index < this.getNumTabs() && index >= 0) {
                this.m_filePaths.set(index, flowFile);
            }
        }

        public synchronized void setTabTitle(String title) {
            if (this.getNumTabs() > 0) {
                this.setTabTitle(this.getCurrentTabIndex(), title);
            }
        }

        public synchronized void setTabTitle(int index, String title) {
            if (index < this.getNumTabs() && index >= 0) {
                this.m_flowTabs.setTitleAt(index, title);
                ((CloseableTabTitle)this.m_flowTabs.getTabComponentAt(index)).revalidate();
            }
        }

        public synchronized void setEditedStatus(boolean status) {
            if (this.getNumTabs() > 0) {
                int current = this.getCurrentTabIndex();
                this.setEditedStatus(current, status);
            }
        }

        public synchronized void setEditedStatus(int index, boolean status) {
            if (index < this.getNumTabs() && index >= 0) {
                Boolean newStatus = new Boolean(status);
                this.m_editedList.set(index, newStatus);
                ((CloseableTabTitle)this.m_flowTabs.getTabComponentAt(index)).setBold(status);
            }
        }

        public synchronized boolean getEditedStatus() {
            if (this.getNumTabs() <= 0) {
                return false;
            }
            return this.getEditedStatus(this.getCurrentTabIndex());
        }

        public synchronized boolean getEditedStatus(int index) {
            if (index < this.getNumTabs() && index >= 0) {
                return this.m_editedList.get(index);
            }
            return false;
        }

        public synchronized void setUndoBuffer(Stack<File> buffer) {
            if (this.getNumTabs() > 0) {
                this.setUndoBuffer(this.getCurrentTabIndex(), buffer);
            }
        }

        public synchronized void setUndoBuffer(int index, Stack<File> buffer) {
            if (index < this.getNumTabs() && index >= 0) {
                this.m_undoBufferList.set(index, buffer);
            }
        }

        public synchronized Stack<File> getUndoBuffer() {
            if (this.getNumTabs() > 0) {
                return this.getUndoBuffer(this.getCurrentTabIndex());
            }
            return null;
        }

        public synchronized Stack<File> getUndoBuffer(int index) {
            if (index >= 0 && index < this.getNumTabs()) {
                return this.m_undoBufferList.get(index);
            }
            return null;
        }

        public synchronized Vector<Object> getSelectedBeans() {
            if (this.getNumTabs() > 0) {
                return this.getSelectedBeans(this.getCurrentTabIndex());
            }
            return null;
        }

        public synchronized Vector<Object> getSelectedBeans(int index) {
            if (index < this.getNumTabs() && index >= 0) {
                return this.m_selectedBeans.get(index);
            }
            return null;
        }

        public synchronized void setSelectedBeans(Vector<Object> beans) {
            if (this.getNumTabs() > 0) {
                Vector<Object> outputs;
                Vector<Object> inputs;
                Vector<Object> selected;
                this.setSelectedBeans(this.getCurrentTabIndex(), beans);
                KnowledgeFlowApp.this.m_groupB.setEnabled(false);
                if (this.getSelectedBeans().size() > 0 && !this.getExecuting() && KnowledgeFlowApp.this.groupable(selected = KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans(), inputs = BeanConnection.inputs(selected, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()), outputs = BeanConnection.outputs(selected, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()))) {
                    KnowledgeFlowApp.this.m_groupB.setEnabled(true);
                }
                KnowledgeFlowApp.this.m_cutB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_copyB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
                KnowledgeFlowApp.this.m_deleteB.setEnabled(this.getSelectedBeans().size() > 0 && !this.getExecuting());
            }
        }

        public synchronized void setSelectedBeans(int index, Vector<Object> beans) {
            if (index < this.getNumTabs() && index >= 0) {
                BeanInstance temp;
                int i;
                for (i = 0; i < this.m_selectedBeans.get(index).size(); ++i) {
                    temp = (BeanInstance)this.m_selectedBeans.get(index).elementAt(i);
                    if (temp.getBean() instanceof Visible) {
                        ((Visible)temp.getBean()).getVisual().setDisplayConnectors(false);
                        continue;
                    }
                    if (!(temp.getBean() instanceof Note)) continue;
                    ((Note)temp.getBean()).setHighlighted(false);
                }
                this.m_selectedBeans.set(index, beans);
                for (i = 0; i < beans.size(); ++i) {
                    temp = (BeanInstance)beans.elementAt(i);
                    if (temp.getBean() instanceof Visible) {
                        ((Visible)temp.getBean()).getVisual().setDisplayConnectors(true);
                        continue;
                    }
                    if (!(temp.getBean() instanceof Note)) continue;
                    ((Note)temp.getBean()).setHighlighted(true);
                }
            }
        }

        public synchronized Environment getEnvironmentSettings() {
            if (this.getNumTabs() > 0) {
                return this.getEnvironmentSettings(this.getCurrentTabIndex());
            }
            return null;
        }

        public synchronized Environment getEnvironmentSettings(int index) {
            if (index < this.getNumTabs() && index >= 0) {
                return this.m_environmentSettings.get(index);
            }
            return null;
        }

        @Override
        public void setInstances(Instances insts) {
        }

        @Override
        public boolean acceptsInstances() {
            return false;
        }

        @Override
        public String getPerspectiveTitle() {
            return "Data mining processes";
        }

        @Override
        public String getPerspectiveTipText() {
            return "Knowledge Flow processes";
        }

        @Override
        public Icon getPerspectiveIcon() {
            Image wekaI = KnowledgeFlowApp.this.loadImage("weka/gui/weka_icon_new.png");
            ImageIcon icon = new ImageIcon(wekaI);
            double width = icon.getIconWidth();
            double height = icon.getIconHeight();
            wekaI = wekaI.getScaledInstance((int)(width *= 0.035), (int)(height *= 0.035), 4);
            icon = new ImageIcon(wekaI);
            return icon;
        }

        /*
         * WARNING - void declaration
         */
        private void setUpToolsAndJTree() {
            JPanel toolBarPanel = new JPanel();
            toolBarPanel.setLayout(new BorderLayout());
            if (KnowledgeFlowApp.this.m_showFileMenu) {
                AbstractAction closeAction = new AbstractAction("Close"){
                    private static final long serialVersionUID = 4762166880144590384L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex() >= 0) {
                            KnowledgeFlowApp.this.m_mainKFPerspective.removeTab(MainKFPerspective.this.getCurrentTabIndex());
                        }
                    }
                };
                KeyStroke closeKey = KeyStroke.getKeyStroke(87, 128);
                this.getActionMap().put("Close", closeAction);
                this.getInputMap(2).put(closeKey, "Close");
                JToolBar fixedTools = new JToolBar();
                fixedTools.setOrientation(0);
                KnowledgeFlowApp.this.m_groupB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/bricks.png")));
                KnowledgeFlowApp.this.m_groupB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_groupB.setToolTipText("Group selected (Ctrl+Z)");
                KnowledgeFlowApp.this.m_cutB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/cut.png")));
                KnowledgeFlowApp.this.m_cutB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_cutB.setToolTipText("Cut selected (Ctrl+X)");
                KnowledgeFlowApp.this.m_copyB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/page_copy.png")));
                KnowledgeFlowApp.this.m_copyB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_copyB.setToolTipText("Copy selected (Ctrl+C)");
                KnowledgeFlowApp.this.m_pasteB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/paste_plain.png")));
                KnowledgeFlowApp.this.m_pasteB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_pasteB.setToolTipText("Paste from clipboard (Ctrl+V)");
                KnowledgeFlowApp.this.m_deleteB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/delete.png")));
                KnowledgeFlowApp.this.m_deleteB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_deleteB.setToolTipText("Delete selected (DEL)");
                KnowledgeFlowApp.this.m_snapToGridB = new JToggleButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/shape_handles.png")));
                KnowledgeFlowApp.this.m_snapToGridB.setToolTipText("Snap to grid (Ctrl+G)");
                KnowledgeFlowApp.this.m_saveB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/disk.png")));
                KnowledgeFlowApp.this.m_saveB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_saveB.setToolTipText("Save layout (Ctrl+S)");
                KnowledgeFlowApp.this.m_saveBB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/disk_multiple.png")));
                KnowledgeFlowApp.this.m_saveBB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_saveBB.setToolTipText("Save layout with new name");
                KnowledgeFlowApp.this.m_loadB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/folder_add.png")));
                KnowledgeFlowApp.this.m_loadB.setToolTipText("Open (Ctrl+O)");
                KnowledgeFlowApp.this.m_loadB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_newB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/page_add.png")));
                KnowledgeFlowApp.this.m_newB.setToolTipText("New layout (Ctrl+N)");
                KnowledgeFlowApp.this.m_newB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_newB.setEnabled(KnowledgeFlowApp.this.getAllowMultipleTabs());
                KnowledgeFlowApp.this.m_helpB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/help.png")));
                KnowledgeFlowApp.this.m_helpB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_helpB.setToolTipText("Display help (Ctrl+H)");
                KnowledgeFlowApp.this.m_togglePerspectivesB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/cog_go.png")));
                KnowledgeFlowApp.this.m_togglePerspectivesB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_togglePerspectivesB.setToolTipText("Show/hide perspectives toolbar (Ctrl+P)");
                KnowledgeFlowApp.this.m_templatesB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/application_view_tile.png")));
                KnowledgeFlowApp.this.m_templatesB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_templatesB.setToolTipText("Load a template layout");
                KnowledgeFlowApp.this.m_noteB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/note_add.png")));
                KnowledgeFlowApp.this.m_noteB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_noteB.setToolTipText("Add a note to the layout (Ctrl+I)");
                KnowledgeFlowApp.this.m_selectAllB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/shape_group.png")));
                KnowledgeFlowApp.this.m_selectAllB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_selectAllB.setToolTipText("Select all (Ctrl+A)");
                KnowledgeFlowApp.this.m_zoomInB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/zoom_in.png")));
                KnowledgeFlowApp.this.m_zoomInB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_zoomInB.setToolTipText("Zoom in (Ctrl++)");
                KnowledgeFlowApp.this.m_zoomOutB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/zoom_out.png")));
                KnowledgeFlowApp.this.m_zoomOutB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_zoomOutB.setToolTipText("Zoom out (Ctrl+-)");
                KnowledgeFlowApp.this.m_undoB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/arrow_undo.png")));
                KnowledgeFlowApp.this.m_undoB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
                KnowledgeFlowApp.this.m_undoB.setToolTipText("Undo (Ctrl+U)");
                fixedTools.add(KnowledgeFlowApp.this.m_zoomInB);
                fixedTools.add(KnowledgeFlowApp.this.m_zoomOutB);
                fixedTools.addSeparator();
                fixedTools.add(KnowledgeFlowApp.this.m_selectAllB);
                fixedTools.add(KnowledgeFlowApp.this.m_groupB);
                fixedTools.add(KnowledgeFlowApp.this.m_cutB);
                fixedTools.add(KnowledgeFlowApp.this.m_copyB);
                fixedTools.add(KnowledgeFlowApp.this.m_deleteB);
                fixedTools.add(KnowledgeFlowApp.this.m_pasteB);
                fixedTools.add(KnowledgeFlowApp.this.m_undoB);
                fixedTools.add(KnowledgeFlowApp.this.m_noteB);
                fixedTools.addSeparator();
                fixedTools.add(KnowledgeFlowApp.this.m_snapToGridB);
                fixedTools.addSeparator();
                fixedTools.add(KnowledgeFlowApp.this.m_newB);
                fixedTools.add(KnowledgeFlowApp.this.m_saveB);
                fixedTools.add(KnowledgeFlowApp.this.m_saveBB);
                fixedTools.add(KnowledgeFlowApp.this.m_loadB);
                fixedTools.add(KnowledgeFlowApp.this.m_templatesB);
                fixedTools.addSeparator();
                fixedTools.add(KnowledgeFlowApp.this.m_togglePerspectivesB);
                fixedTools.add(KnowledgeFlowApp.this.m_helpB);
                Dimension d = KnowledgeFlowApp.this.m_undoB.getPreferredSize();
                Dimension d2 = fixedTools.getMinimumSize();
                Dimension d3 = new Dimension(d2.width, d.height + 4);
                fixedTools.setPreferredSize(d3);
                fixedTools.setMaximumSize(d3);
                final AbstractAction saveAction = new AbstractAction("Save"){
                    private static final long serialVersionUID = 5182044142154404706L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex() >= 0) {
                            KnowledgeFlowApp.this.saveLayout(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex(), false);
                        }
                    }
                };
                KeyStroke saveKey = KeyStroke.getKeyStroke(83, 128);
                this.getActionMap().put("Save", saveAction);
                this.getInputMap(2).put(saveKey, "Save");
                KnowledgeFlowApp.this.m_saveB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        saveAction.actionPerformed(e);
                    }
                });
                KnowledgeFlowApp.this.m_saveBB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.saveLayout(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex(), true);
                    }
                });
                final AbstractAction openAction = new AbstractAction("Open"){
                    private static final long serialVersionUID = -5106547209818805444L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.m_flowEnvironment = new Environment();
                        KnowledgeFlowApp.this.loadLayout();
                    }
                };
                KeyStroke openKey = KeyStroke.getKeyStroke(79, 128);
                this.getActionMap().put("Open", openAction);
                this.getInputMap(2).put(openKey, "Open");
                KnowledgeFlowApp.this.m_loadB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        openAction.actionPerformed(e);
                    }
                });
                final AbstractAction newAction = new AbstractAction("New"){
                    private static final long serialVersionUID = 8002244400334262966L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.clearLayout();
                    }
                };
                KeyStroke newKey = KeyStroke.getKeyStroke(78, 128);
                this.getActionMap().put("New", newAction);
                this.getInputMap(2).put(newKey, "New");
                KnowledgeFlowApp.this.m_newB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        newAction.actionPerformed(ae);
                    }
                });
                final AbstractAction selectAllAction = new AbstractAction("SelectAll"){
                    private static final long serialVersionUID = -8086754050844707658L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (BeanInstance.getBeanInstances(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()).size() > 0) {
                            Vector<Object> allBeans = BeanInstance.getBeanInstances(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                            Vector<Object> newSelected = new Vector<Object>();
                            for (int i = 0; i < allBeans.size(); ++i) {
                                newSelected.add(allBeans.get(i));
                            }
                            if (newSelected.size() == KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans().size()) {
                                KnowledgeFlowApp.this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
                            } else {
                                KnowledgeFlowApp.this.m_mainKFPerspective.setSelectedBeans(newSelected);
                            }
                        }
                        MainKFPerspective.this.revalidate();
                        MainKFPerspective.this.repaint();
                        KnowledgeFlowApp.this.notifyIsDirty();
                    }
                };
                KeyStroke selectAllKey = KeyStroke.getKeyStroke(65, 128);
                this.getActionMap().put("SelectAll", selectAllAction);
                this.getInputMap(2).put(selectAllKey, "SelectAll");
                KnowledgeFlowApp.this.m_selectAllB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        selectAllAction.actionPerformed(e);
                    }
                });
                final AbstractAction zoomInAction = new AbstractAction("ZoomIn"){
                    private static final long serialVersionUID = 1348383794897269484L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.m_layoutZoom = KnowledgeFlowApp.this.m_layoutZoom + 25;
                        KnowledgeFlowApp.this.m_zoomOutB.setEnabled(true);
                        if (KnowledgeFlowApp.this.m_layoutZoom >= 200) {
                            KnowledgeFlowApp.this.m_layoutZoom = 200;
                            KnowledgeFlowApp.this.m_zoomInB.setEnabled(false);
                        }
                        KnowledgeFlowApp.this.m_mainKFPerspective.setCurrentZoomSetting(KnowledgeFlowApp.this.m_layoutZoom);
                        MainKFPerspective.this.revalidate();
                        MainKFPerspective.this.repaint();
                        KnowledgeFlowApp.this.notifyIsDirty();
                    }
                };
                KeyStroke zoomInKey = KeyStroke.getKeyStroke(61, 128);
                this.getActionMap().put("ZoomIn", zoomInAction);
                this.getInputMap(2).put(zoomInKey, "ZoomIn");
                KnowledgeFlowApp.this.m_zoomInB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        zoomInAction.actionPerformed(e);
                    }
                });
                final AbstractAction zoomOutAction = new AbstractAction("ZoomOut"){
                    private static final long serialVersionUID = -1120096894263455918L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.m_layoutZoom = KnowledgeFlowApp.this.m_layoutZoom - 25;
                        KnowledgeFlowApp.this.m_zoomInB.setEnabled(true);
                        if (KnowledgeFlowApp.this.m_layoutZoom <= 50) {
                            KnowledgeFlowApp.this.m_layoutZoom = 50;
                            KnowledgeFlowApp.this.m_zoomOutB.setEnabled(false);
                        }
                        KnowledgeFlowApp.this.m_mainKFPerspective.setCurrentZoomSetting(KnowledgeFlowApp.this.m_layoutZoom);
                        MainKFPerspective.this.revalidate();
                        MainKFPerspective.this.repaint();
                        KnowledgeFlowApp.this.notifyIsDirty();
                    }
                };
                KeyStroke zoomOutKey = KeyStroke.getKeyStroke(45, 128);
                this.getActionMap().put("ZoomOut", zoomOutAction);
                this.getInputMap(2).put(zoomOutKey, "ZoomOut");
                KnowledgeFlowApp.this.m_zoomOutB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        zoomOutAction.actionPerformed(e);
                    }
                });
                final AbstractAction groupAction = new AbstractAction("Group"){
                    private static final long serialVersionUID = -5752742619180091435L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Vector<Object> selected = KnowledgeFlowApp.this.m_mainKFPerspective.getSelectedBeans();
                        Vector<Object> inputs = BeanConnection.inputs(selected, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                        Vector<Object> outputs = BeanConnection.outputs(selected, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
                        KnowledgeFlowApp.this.groupSubFlow(selected, inputs, outputs);
                    }
                };
                KeyStroke groupKey = KeyStroke.getKeyStroke(90, 128);
                this.getActionMap().put("Group", groupAction);
                this.getInputMap(2).put(groupKey, "Group");
                KnowledgeFlowApp.this.m_groupB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        groupAction.actionPerformed(e);
                    }
                });
                final AbstractAction cutAction = new AbstractAction("Cut"){
                    private static final long serialVersionUID = -4955878102742013040L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (KnowledgeFlowApp.this.copyToClipboard()) {
                            KnowledgeFlowApp.this.deleteSelectedBeans();
                        }
                    }
                };
                KeyStroke cutKey = KeyStroke.getKeyStroke(88, 128);
                this.getActionMap().put("Cut", cutAction);
                this.getInputMap(2).put(cutKey, "Cut");
                KnowledgeFlowApp.this.m_cutB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        cutAction.actionPerformed(e);
                    }
                });
                final AbstractAction deleteAction = new AbstractAction("Delete"){
                    private static final long serialVersionUID = 4621688037874199553L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.deleteSelectedBeans();
                    }
                };
                KeyStroke deleteKey = KeyStroke.getKeyStroke(127, 0);
                this.getActionMap().put("Delete", deleteAction);
                this.getInputMap(2).put(deleteKey, "Delete");
                KnowledgeFlowApp.this.m_deleteB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        deleteAction.actionPerformed(e);
                    }
                });
                final AbstractAction copyAction = new AbstractAction("Copy"){
                    private static final long serialVersionUID = 117010390180468707L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.copyToClipboard();
                        KnowledgeFlowApp.this.m_mainKFPerspective.setSelectedBeans(new Vector<Object>());
                    }
                };
                KeyStroke copyKey = KeyStroke.getKeyStroke(67, 128);
                this.getActionMap().put("Copy", copyAction);
                this.getInputMap(2).put(copyKey, "Copy");
                KnowledgeFlowApp.this.m_copyB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        copyAction.actionPerformed(e);
                    }
                });
                final AbstractAction pasteAction = new AbstractAction("Paste"){
                    private static final long serialVersionUID = 5935121051028929455L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(1));
                        KnowledgeFlowApp.this.m_mode = 5;
                    }
                };
                KeyStroke pasteKey = KeyStroke.getKeyStroke(86, 128);
                this.getActionMap().put("Paste", pasteAction);
                this.getInputMap(2).put(pasteKey, "Paste");
                KnowledgeFlowApp.this.m_pasteB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pasteAction.actionPerformed(e);
                    }
                });
                AbstractAction snapAction = new AbstractAction("Snap"){
                    private static final long serialVersionUID = 7820689847829357449L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KnowledgeFlowApp.this.m_snapToGridB.setSelected(!KnowledgeFlowApp.this.m_snapToGridB.isSelected());
                        if (KnowledgeFlowApp.this.m_snapToGridB.isSelected()) {
                            KnowledgeFlowApp.this.snapSelectedToGrid();
                        }
                    }
                };
                KeyStroke keyStroke = KeyStroke.getKeyStroke(71, 128);
                this.getActionMap().put("Snap", snapAction);
                this.getInputMap(2).put(keyStroke, "Snap");
                KnowledgeFlowApp.this.m_snapToGridB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (KnowledgeFlowApp.this.m_snapToGridB.isSelected()) {
                            KnowledgeFlowApp.this.snapSelectedToGrid();
                        }
                    }
                });
                fixedTools.setFloatable(false);
                toolBarPanel.add((Component)fixedTools, "East");
            }
            final AbstractAction noteAction = new AbstractAction("Note"){
                private static final long serialVersionUID = 2991743619130024875L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Note n = new Note();
                    KnowledgeFlowApp.this.m_toolBarBean = n;
                    KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(1));
                    KnowledgeFlowApp.this.m_mode = 3;
                }
            };
            KeyStroke noteKey = KeyStroke.getKeyStroke(73, 128);
            this.getActionMap().put("Note", noteAction);
            this.getInputMap(2).put(noteKey, "Note");
            KnowledgeFlowApp.this.m_noteB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    noteAction.actionPerformed(e);
                }
            });
            final AbstractAction undoAction = new AbstractAction("Undo"){
                private static final long serialVersionUID = 7248362305594881263L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Stack<File> undo = KnowledgeFlowApp.this.m_mainKFPerspective.getUndoBuffer();
                    if (undo.size() > 0) {
                        File undoF = undo.pop();
                        if (undo.size() == 0) {
                            KnowledgeFlowApp.this.m_undoB.setEnabled(false);
                        }
                        KnowledgeFlowApp.this.loadLayout(undoF, false, true);
                    }
                }
            };
            KeyStroke undoKey = KeyStroke.getKeyStroke(85, 128);
            this.getActionMap().put("Undo", undoAction);
            this.getInputMap(2).put(undoKey, "Undo");
            KnowledgeFlowApp.this.m_undoB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    undoAction.actionPerformed(e);
                }
            });
            KnowledgeFlowApp.this.m_playB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/resultset_next.png")));
            KnowledgeFlowApp.this.m_playB.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            KnowledgeFlowApp.this.m_playB.setToolTipText("Run this flow (all start points launched in parallel)");
            KnowledgeFlowApp.this.m_playB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BeanInstance.getBeanInstances(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()).size() == 0) {
                        return;
                    }
                    boolean proceed = true;
                    if (m_Memory.memoryIsLow()) {
                        proceed = m_Memory.showMemoryIsLow();
                    }
                    if (proceed) {
                        KnowledgeFlowApp.this.runFlow(false);
                    }
                }
            });
            KnowledgeFlowApp.this.m_playBB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/resultset_last.png")));
            KnowledgeFlowApp.this.m_playBB.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            KnowledgeFlowApp.this.m_playBB.setToolTipText("Run this flow (start points launched sequentially)");
            KnowledgeFlowApp.this.m_playBB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BeanInstance.getBeanInstances(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex()).size() == 0) {
                        return;
                    }
                    if (!Utils.getDontShowDialog("weka.gui.beans.KnowledgeFlow.SequentialRunInfo")) {
                        JCheckBox dontShow = new JCheckBox("Do not show this message again");
                        Object[] stuff = new Object[]{"The order that data sources are launched in can be\nspecified by setting a custom name for each data source that\nthat includes a number. E.g. \"1:MyArffLoader\". To set a name,\nright-click over a data source and select \"Set name\"\n\nIf the prefix is not specified, then the order of execution\nwill correspond to the order that the components were added\nto the layout. Note that it is also possible to prevent a data\nsource from executing by prefixing its name with a \"!\". E.g\n\"!:MyArffLoader\"", dontShow};
                        JOptionPane.showMessageDialog(KnowledgeFlowApp.this, stuff, "Sequential execution information", 0);
                        if (dontShow.isSelected()) {
                            try {
                                Utils.setDontShowDialog("weka.gui.beans.KnowledgeFlow.SequentialRunInfo");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    boolean proceed = true;
                    if (m_Memory.memoryIsLow()) {
                        proceed = m_Memory.showMemoryIsLow();
                    }
                    if (proceed) {
                        KnowledgeFlowApp.this.runFlow(true);
                    }
                }
            });
            KnowledgeFlowApp.this.m_stopB = new JButton(new ImageIcon(KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/shape_square.png")));
            KnowledgeFlowApp.this.m_stopB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
            KnowledgeFlowApp.this.m_stopB.setToolTipText("Stop all execution");
            Image tempI = KnowledgeFlowApp.this.loadImage("weka/gui/beans/icons/cursor.png");
            KnowledgeFlowApp.this.m_pointerB = new JButton(new ImageIcon(tempI));
            KnowledgeFlowApp.this.m_pointerB.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            KnowledgeFlowApp.this.m_pointerB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.m_toolBarBean = null;
                    KnowledgeFlowApp.this.m_mode = 0;
                    KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(0));
                    KnowledgeFlowApp.this.m_componentTree.clearSelection();
                }
            });
            JToolBar fixedTools2 = new JToolBar();
            fixedTools2.setOrientation(0);
            fixedTools2.setFloatable(false);
            fixedTools2.add(KnowledgeFlowApp.this.m_pointerB);
            fixedTools2.add(KnowledgeFlowApp.this.m_playB);
            fixedTools2.add(KnowledgeFlowApp.this.m_playBB);
            fixedTools2.add(KnowledgeFlowApp.this.m_stopB);
            Dimension d = KnowledgeFlowApp.this.m_playB.getPreferredSize();
            Dimension d2 = fixedTools2.getMinimumSize();
            Dimension d3 = new Dimension(d2.width, d.height + 4);
            fixedTools2.setPreferredSize(d3);
            fixedTools2.setMaximumSize(d3);
            toolBarPanel.add((Component)fixedTools2, "West");
            KnowledgeFlowApp.this.m_stopB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|Attempting to stop all components...");
                    KnowledgeFlowApp.this.stopFlow();
                    KnowledgeFlowApp.this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|OK.");
                }
            });
            final AbstractAction helpAction = new AbstractAction("Help"){
                private static final long serialVersionUID = 3301809940717051925L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.popupHelp();
                }
            };
            KeyStroke helpKey = KeyStroke.getKeyStroke(72, 128);
            this.getActionMap().put("Help", helpAction);
            this.getInputMap(2).put(helpKey, "Help");
            KnowledgeFlowApp.this.m_helpB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    helpAction.actionPerformed(ae);
                }
            });
            KnowledgeFlowApp.this.m_templatesB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.createTemplateMenuPopup();
                }
            });
            KnowledgeFlowApp.this.m_templatesB.setEnabled(BeansProperties.TEMPLATE_PATHS.size() > 0);
            final AbstractAction togglePerspectivesAction = new AbstractAction("Toggle perspectives"){
                private static final long serialVersionUID = 5394622655137498495L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KnowledgeFlowApp.this.m_firstUserComponentOpp) {
                        KnowledgeFlowApp.this.installWindowListenerForSavingUserStuff();
                        KnowledgeFlowApp.this.m_firstUserComponentOpp = false;
                    }
                    if (!Utils.getDontShowDialog("weka.gui.beans.KnowledgeFlow.PerspectiveInfo")) {
                        JCheckBox dontShow = new JCheckBox("Do not show this message again");
                        Object[] stuff = new Object[]{"Perspectives are environments that take over the\nKnowledge Flow UI and provide major additional functionality.\nMany perspectives will operate on a set of instances. Instances\nCan be sent to a perspective by placing a DataSource on the\nlayout canvas, configuring it and then selecting \"Send to perspective\"\nfrom the contextual popup menu that appears when you right-click on\nit. Several perspectives are built in to the Knowledge Flow, others\ncan be installed via the package manager.\n", dontShow};
                        JOptionPane.showMessageDialog(KnowledgeFlowApp.this, stuff, "Perspective information", 0);
                        if (dontShow.isSelected()) {
                            try {
                                Utils.setDontShowDialog("weka.gui.beans.KnowledgeFlow.PerspectiveInfo");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (KnowledgeFlowApp.this.m_configAndPerspectivesVisible) {
                        KnowledgeFlowApp.this.remove(KnowledgeFlowApp.this.m_configAndPerspectives);
                        KnowledgeFlowApp.this.m_configAndPerspectivesVisible = false;
                    } else {
                        KnowledgeFlowApp.this.add((Component)KnowledgeFlowApp.this.m_configAndPerspectives, "North");
                        KnowledgeFlowApp.this.m_configAndPerspectivesVisible = true;
                    }
                    MainKFPerspective.this.revalidate();
                    MainKFPerspective.this.repaint();
                    KnowledgeFlowApp.this.notifyIsDirty();
                }
            };
            KeyStroke togglePerspectivesKey = KeyStroke.getKeyStroke(80, 128);
            this.getActionMap().put("Toggle perspectives", togglePerspectivesAction);
            this.getInputMap(2).put(togglePerspectivesKey, "Toggle perspectives");
            KnowledgeFlowApp.this.m_togglePerspectivesB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    togglePerspectivesAction.actionPerformed(e);
                }
            });
            boolean standard_toolset = false;
            boolean wrapper_toolset = true;
            boolean toolBarType = false;
            DefaultMutableTreeNode jtreeRoot = new DefaultMutableTreeNode("Weka");
            for (int i = 0; i < TOOLBARS.size(); ++i) {
                Hashtable hpps;
                HierarchyPropertyParser hpp;
                String rootPackage;
                String tempBeanCompName;
                InvisibleNode subTreeNode;
                Vector tempBarSpecs;
                block42: {
                    tempBarSpecs = (Vector)TOOLBARS.elementAt(i);
                    String tempToolSetName = (String)tempBarSpecs.elementAt(0);
                    subTreeNode = new InvisibleNode(tempToolSetName);
                    jtreeRoot.add(subTreeNode);
                    tempBeanCompName = (String)tempBarSpecs.elementAt(1);
                    rootPackage = "";
                    hpp = null;
                    hpps = null;
                    if (tempBeanCompName.compareTo("null") != 0) {
                        toolBarType = true;
                        rootPackage = (String)tempBarSpecs.elementAt(2);
                        hpps = (Hashtable)tempBarSpecs.elementAt(3);
                        try {
                            WekaPackageClassLoaderManager.objectForName(tempBeanCompName);
                            break block42;
                        }
                        catch (Exception ex) {
                            Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] Failed to instantiate: " + tempBeanCompName);
                            break;
                        }
                    }
                    toolBarType = false;
                }
                int z = 2;
                if (toolBarType) {
                    Enumeration enm = hpps.keys();
                    while (enm.hasMoreElements()) {
                        String[] primaryPackages;
                        String root = (String)enm.nextElement();
                        hpp = (HierarchyPropertyParser)hpps.get(root);
                        if (!hpp.goTo(rootPackage)) {
                            // empty if block
                        }
                        for (String primaryPackage : primaryPackages = hpp.childrenValues()) {
                            hpp.goToChild(primaryPackage);
                            if (hpp.isLeafReached()) {
                                String algName;
                                Object visibleCheck = KnowledgeFlowApp.this.instantiateBean(toolBarType, tempBeanCompName, algName = hpp.fullValue());
                                if (visibleCheck != null) {
                                    void var37_65;
                                    BeanVisual bv;
                                    if (visibleCheck instanceof BeanContextChild) {
                                        KnowledgeFlowApp.this.m_bcSupport.add(visibleCheck);
                                    }
                                    Object var37_63 = null;
                                    if (visibleCheck instanceof Visible && (bv = ((Visible)visibleCheck).getVisual()) != null) {
                                        ImageIcon imageIcon = new ImageIcon(bv.scale(0.33));
                                    }
                                    String toolTip = "";
                                    try {
                                        Object wrappedA = WekaPackageClassLoaderManager.objectForName(algName);
                                        toolTip = KnowledgeFlowApp.getGlobalInfo(wrappedA);
                                    }
                                    catch (Exception wrappedA) {
                                        // empty catch block
                                    }
                                    JTreeLeafDetails leafData = new JTreeLeafDetails(tempBeanCompName, algName, (Icon)var37_65);
                                    if (toolTip != null && toolTip.length() > 0) {
                                        leafData.setToolTipText(toolTip);
                                    }
                                    InvisibleNode leafAlgo = new InvisibleNode(leafData);
                                    subTreeNode.add(leafAlgo);
                                    this.m_nodeTextIndex.put(algName.toLowerCase() + " " + (toolTip != null ? toolTip.toLowerCase() + " " : ""), leafAlgo);
                                }
                                hpp.goToParent();
                                continue;
                            }
                            InvisibleNode firstLevelOfMainAlgoType = new InvisibleNode(primaryPackage);
                            subTreeNode.add(firstLevelOfMainAlgoType);
                            KnowledgeFlowApp.this.processPackage(tempBeanCompName, hpp, firstLevelOfMainAlgoType, this.m_nodeTextIndex);
                        }
                    }
                    continue;
                }
                for (int j = z; j < tempBarSpecs.size(); ++j) {
                    void var31_46;
                    BeanVisual bv;
                    Object visibleCheck = KnowledgeFlowApp.this.instantiateBean(toolBarType, tempBeanCompName = (String)tempBarSpecs.elementAt(j), "");
                    if (visibleCheck == null) continue;
                    String treeName = tempBeanCompName;
                    if (treeName.lastIndexOf(46) > 0) {
                        treeName = treeName.substring(treeName.lastIndexOf(46) + 1, treeName.length());
                    }
                    if (visibleCheck instanceof BeanContextChild) {
                        KnowledgeFlowApp.this.m_bcSupport.add(visibleCheck);
                    }
                    Object var31_44 = null;
                    if (visibleCheck instanceof Visible && (bv = ((Visible)visibleCheck).getVisual()) != null) {
                        ImageIcon imageIcon = new ImageIcon(bv.scale(0.33));
                    }
                    String tipText = null;
                    tipText = KnowledgeFlowApp.getGlobalInfo(visibleCheck);
                    Class<?> compClass = visibleCheck.getClass();
                    Annotation[] annotations = compClass.getDeclaredAnnotations();
                    String category = null;
                    DefaultMutableTreeNode targetFolder = null;
                    block10: for (Annotation ann : annotations) {
                        if (!(ann instanceof KFStep)) continue;
                        tipText = "<html><font color=blue>" + ((KFStep)ann).toolTipText() + "</font></html>";
                        category = ((KFStep)ann).category();
                        Enumeration<TreeNode> children = jtreeRoot.children();
                        while (children.hasMoreElements()) {
                            TreeNode child = children.nextElement();
                            if (!(child instanceof DefaultMutableTreeNode) || !((DefaultMutableTreeNode)child).getUserObject().toString().equals(category)) continue;
                            targetFolder = (DefaultMutableTreeNode)child;
                            break block10;
                        }
                        break;
                    }
                    JTreeLeafDetails jTreeLeafDetails = new JTreeLeafDetails(tempBeanCompName, "", (Icon)var31_46);
                    if (tipText != null) {
                        jTreeLeafDetails.setToolTipText(tipText);
                    }
                    InvisibleNode fixedLeafNode = new InvisibleNode(jTreeLeafDetails);
                    if (targetFolder != null) {
                        targetFolder.add(fixedLeafNode);
                    } else {
                        subTreeNode.add(fixedLeafNode);
                    }
                    this.m_nodeTextIndex.put(tempBeanCompName.toLowerCase() + " " + (tipText != null ? tipText.toLowerCase() : ""), fixedLeafNode);
                }
            }
            if (BeansProperties.BEAN_PLUGINS_PROPERTIES != null && BeansProperties.BEAN_PLUGINS_PROPERTIES.size() > 0) {
                boolean pluginBeans = false;
                DefaultMutableTreeNode userSubTree = null;
                for (int i = 0; i < BeansProperties.BEAN_PLUGINS_PROPERTIES.size(); ++i) {
                    String perspectives;
                    Properties tempP = BeansProperties.BEAN_PLUGINS_PROPERTIES.get(i);
                    String components = tempP.getProperty("weka.gui.beans.KnowledgeFlow.Plugins");
                    if (components != null && components.length() > 0) {
                        StringTokenizer st2 = new StringTokenizer(components, ", ");
                        while (st2.hasMoreTokens()) {
                            BeanVisual bv;
                            Object visibleCheck;
                            String tempBeanCompName = st2.nextToken().trim();
                            String treeName = tempBeanCompName;
                            if (treeName.lastIndexOf(46) > 0) {
                                treeName = treeName.substring(treeName.lastIndexOf(46) + 1, treeName.length());
                            }
                            if ((visibleCheck = KnowledgeFlowApp.this.instantiateBean(toolBarType, tempBeanCompName, "")) instanceof BeanContextChild) {
                                KnowledgeFlowApp.this.m_bcSupport.add(visibleCheck);
                            }
                            ImageIcon scaledForTree = null;
                            if (visibleCheck instanceof Visible && (bv = ((Visible)visibleCheck).getVisual()) != null) {
                                scaledForTree = new ImageIcon(bv.scale(0.33));
                            }
                            String tipText = null;
                            tipText = KnowledgeFlowApp.getGlobalInfo(visibleCheck);
                            Class<?> compClass = visibleCheck.getClass();
                            Annotation[] annotationArray = compClass.getDeclaredAnnotations();
                            DefaultMutableTreeNode targetFolder = null;
                            String category = null;
                            block14: for (Annotation annotation : annotationArray) {
                                if (!(annotation instanceof KFStep)) continue;
                                category = ((KFStep)annotation).category();
                                tipText = "<html><font color=red>" + ((KFStep)annotation).toolTipText() + "</font></html>";
                                Enumeration<TreeNode> children = jtreeRoot.children();
                                while (children.hasMoreElements()) {
                                    TreeNode child = children.nextElement();
                                    if (!(child instanceof DefaultMutableTreeNode) || !((DefaultMutableTreeNode)child).getUserObject().toString().equals(category)) continue;
                                    targetFolder = (DefaultMutableTreeNode)child;
                                    break block14;
                                }
                                break;
                            }
                            JTreeLeafDetails leafData = new JTreeLeafDetails(tempBeanCompName, "", (Icon)scaledForTree);
                            if (tipText != null) {
                                leafData.setToolTipText(tipText);
                            }
                            InvisibleNode pluginLeaf = new InvisibleNode(leafData);
                            this.m_nodeTextIndex.put(tempBeanCompName.toLowerCase() + (tipText != null ? " " + tipText.toLowerCase() : ""), pluginLeaf);
                            if (targetFolder != null) {
                                targetFolder.add(pluginLeaf);
                                continue;
                            }
                            if (category != null) {
                                InvisibleNode newCategoryNode = new InvisibleNode(category);
                                jtreeRoot.add(newCategoryNode);
                                newCategoryNode.add(pluginLeaf);
                                continue;
                            }
                            if (!pluginBeans) {
                                userSubTree = new InvisibleNode("Plugins");
                                jtreeRoot.add(userSubTree);
                                pluginBeans = true;
                            }
                            userSubTree.add(pluginLeaf);
                        }
                    }
                    if ((perspectives = tempP.getProperty("weka.gui.beans.KnowledgeFlow.Perspectives")) == null || perspectives.length() <= 0) continue;
                    StringTokenizer st2 = new StringTokenizer(perspectives, ",");
                    while (st2.hasMoreTokens()) {
                        String className = st2.nextToken();
                        try {
                            Object p;
                            if (PluginManager.isInDisabledList(className) || !((p = WekaPackageClassLoaderManager.objectForName(className)) instanceof KFPerspective) || !(p instanceof JPanel)) continue;
                            String title = ((KFPerspective)p).getPerspectiveTitle();
                            Logger.log(Logger.Level.INFO, "[KnowledgeFlow] loaded perspective: " + title);
                            KnowledgeFlowApp.this.m_pluginPerspectiveLookup.put(className, title);
                            ((KFPerspective)p).setLoaded(false);
                            if (!BeansProperties.VISIBLE_PERSPECTIVES.contains(className)) continue;
                            KnowledgeFlowApp.this.m_perspectiveCache.put(className, (KFPerspective)p);
                        }
                        catch (Exception ex) {
                            if (KnowledgeFlowApp.this.m_logPanel != null) {
                                KnowledgeFlowApp.this.m_logPanel.logMessage("[KnowledgeFlow] WARNING: unable to instantiate perspective \"" + className + "\"");
                                ex.printStackTrace();
                                continue;
                            }
                            System.err.println("[KnowledgeFlow] WARNING: unable to instantiate perspective \"" + className + "\"");
                            ex.printStackTrace();
                        }
                    }
                }
            }
            KnowledgeFlowApp.this.m_togglePerspectivesB.setEnabled(KnowledgeFlowApp.this.m_pluginPerspectiveLookup.keySet().size() > 0);
            this.add((Component)toolBarPanel, "North");
            InvisibleTreeModel model = new InvisibleTreeModel(jtreeRoot);
            model.activateFilter(true);
            KnowledgeFlowApp.this.m_componentTree = new JTree(model){
                private static final long serialVersionUID = 6628795889296634120L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    DefaultMutableTreeNode node;
                    if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
                        return null;
                    }
                    TreePath currPath = this.getPathForLocation(e.getX(), e.getY());
                    if (currPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)currPath.getLastPathComponent()).isLeaf()) {
                        JTreeLeafDetails leaf = (JTreeLeafDetails)node.getUserObject();
                        return leaf.getToolTipText();
                    }
                    return null;
                }
            };
            KnowledgeFlowApp.this.m_componentTree.setEnabled(true);
            KnowledgeFlowApp.this.m_componentTree.setToolTipText("");
            KnowledgeFlowApp.this.m_componentTree.setRootVisible(false);
            KnowledgeFlowApp.this.m_componentTree.setShowsRootHandles(true);
            KnowledgeFlowApp.this.m_componentTree.setCellRenderer(new BeanIconRenderer());
            DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            KnowledgeFlowApp.this.m_componentTree.setSelectionModel(selectionModel);
            KnowledgeFlowApp.this.m_componentTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Object userObject;
                    DefaultMutableTreeNode tNode;
                    TreePath p;
                    boolean clearSelection;
                    if (((e.getModifiers() & 0x10) != 16 || e.isAltDown()) && (clearSelection = true)) {
                        KnowledgeFlowApp.this.m_toolBarBean = null;
                        KnowledgeFlowApp.this.m_mode = 0;
                        KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(0));
                        KnowledgeFlowApp.this.m_componentTree.clearSelection();
                    }
                    if ((p = KnowledgeFlowApp.this.m_componentTree.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).isLeaf() && (userObject = tNode.getUserObject()) instanceof JTreeLeafDetails) {
                        if ((e.getModifiers() & 1) != 0 && ((JTreeLeafDetails)userObject).isMetaBean()) {
                            if (KnowledgeFlowApp.this.m_firstUserComponentOpp) {
                                KnowledgeFlowApp.this.installWindowListenerForSavingUserStuff();
                                KnowledgeFlowApp.this.m_firstUserComponentOpp = false;
                            }
                            Vector<Object> toRemove = ((JTreeLeafDetails)userObject).getMetaBean();
                            DefaultTreeModel model = (DefaultTreeModel)KnowledgeFlowApp.this.m_componentTree.getModel();
                            MutableTreeNode userRoot = (MutableTreeNode)tNode.getParent();
                            model.removeNodeFromParent(tNode);
                            KnowledgeFlowApp.this.m_userComponents.remove(toRemove);
                            if (KnowledgeFlowApp.this.m_userComponents.size() == 0) {
                                model.removeNodeFromParent(userRoot);
                                KnowledgeFlowApp.this.m_userCompNode = null;
                            }
                        } else {
                            ((JTreeLeafDetails)userObject).instantiateBean();
                        }
                    }
                }
            });
        }

        public MainKFPerspective() {
            this.setLayout(new BorderLayout());
            this.setUpToolsAndJTree();
            JScrollPane treeView = new JScrollPane(KnowledgeFlowApp.this.m_componentTree);
            JPanel treeHolder = new JPanel();
            treeHolder.setLayout(new BorderLayout());
            treeHolder.setBorder(BorderFactory.createTitledBorder("Design"));
            treeHolder.add((Component)treeView, "Center");
            final JTextField searchField = new JTextField();
            treeHolder.add((Component)searchField, "North");
            searchField.setToolTipText("Search (clear field to reset)");
            searchField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    String searchTerm = searchField.getText();
                    ArrayList<DefaultMutableTreeNode> nonhits = new ArrayList<DefaultMutableTreeNode>();
                    ArrayList<DefaultMutableTreeNode> hits = new ArrayList<DefaultMutableTreeNode>();
                    DefaultTreeModel model = (DefaultTreeModel)KnowledgeFlowApp.this.m_componentTree.getModel();
                    model.reload();
                    for (Map.Entry<String, DefaultMutableTreeNode> entry : MainKFPerspective.this.m_nodeTextIndex.entrySet()) {
                        if (entry.getValue() instanceof InvisibleNode) {
                            ((InvisibleNode)entry.getValue()).setVisible(true);
                        }
                        if (searchTerm == null || searchTerm.length() <= 0) continue;
                        if (entry.getKey().contains(searchTerm.toLowerCase())) {
                            hits.add(entry.getValue());
                            continue;
                        }
                        nonhits.add(entry.getValue());
                    }
                    if (searchTerm == null || searchTerm.length() == 0) {
                        model.reload();
                    }
                    if (hits.size() > 0) {
                        for (DefaultMutableTreeNode h : nonhits) {
                            if (!(h instanceof InvisibleNode)) continue;
                            ((InvisibleNode)h).setVisible(false);
                        }
                        model.reload();
                        for (DefaultMutableTreeNode h : hits) {
                            Object[] path = model.getPathToRoot(h);
                            TreePath tpath = new TreePath(path);
                            tpath = tpath.getParentPath();
                            KnowledgeFlowApp.this.m_componentTree.expandPath(tpath);
                        }
                    }
                }
            });
            JSplitPane p2 = new JSplitPane(1, treeHolder, this.m_flowTabs);
            p2.setOneTouchExpandable(true);
            this.add((Component)p2, "Center");
            Dimension d = treeView.getPreferredSize();
            d = new Dimension((int)(d.getWidth() * 1.5), (int)d.getHeight());
            treeView.setPreferredSize(d);
            treeView.setMinimumSize(d);
            this.m_flowTabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    int sel = MainKFPerspective.this.m_flowTabs.getSelectedIndex();
                    MainKFPerspective.this.setActiveTab(sel);
                }
            });
        }

        public synchronized void removeTab(int tabIndex) {
            if (tabIndex < 0 || tabIndex >= this.getNumTabs()) {
                return;
            }
            if (this.m_editedList.get(tabIndex).booleanValue()) {
                String tabTitle = this.m_flowTabs.getTitleAt(tabIndex);
                String message = "\"" + tabTitle + "\" has been modified. Save changes before closing?";
                int result = JOptionPane.showConfirmDialog(KnowledgeFlowApp.this, message, "Save changes", 1);
                if (result == 0) {
                    KnowledgeFlowApp.this.saveLayout(tabIndex, false);
                } else if (result == 2) {
                    return;
                }
            }
            BeanLayout bl = this.m_beanLayouts.get(tabIndex);
            BeanInstance.removeBeanInstances(bl, tabIndex);
            BeanConnection.removeConnectionList(tabIndex);
            this.m_beanLayouts.remove(tabIndex);
            this.m_zoomSettings.remove(tabIndex);
            this.m_logPanels.remove(tabIndex);
            this.m_editedList.remove(tabIndex);
            this.m_environmentSettings.remove(tabIndex);
            this.m_selectedBeans.remove(tabIndex);
            bl = null;
            this.m_flowTabs.remove(tabIndex);
            if (this.getCurrentTabIndex() < 0) {
                KnowledgeFlowApp.this.m_beanLayout = null;
                KnowledgeFlowApp.this.m_logPanel = null;
                KnowledgeFlowApp.this.m_saveB.setEnabled(false);
            }
        }

        public synchronized void addTab(String tabTitle) {
            BeanInstance.addBeanInstances(new Vector<Object>(), null);
            BeanConnection.addConnections(new Vector<BeanConnection>());
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout());
            BeanLayout tabBeanLayout = new BeanLayout();
            JScrollPane js = new JScrollPane(tabBeanLayout);
            p1.add((Component)js, "Center");
            js.getVerticalScrollBar().setUnitIncrement(KnowledgeFlowApp.this.m_ScrollBarIncrementLayout);
            js.getHorizontalScrollBar().setUnitIncrement(KnowledgeFlowApp.this.m_ScrollBarIncrementLayout);
            KnowledgeFlowApp.this.configureBeanLayout(tabBeanLayout);
            this.m_beanLayouts.add(tabBeanLayout);
            tabBeanLayout.setSize(KnowledgeFlowApp.this.m_FlowWidth, KnowledgeFlowApp.this.m_FlowHeight);
            Dimension d = tabBeanLayout.getPreferredSize();
            tabBeanLayout.setMinimumSize(d);
            tabBeanLayout.setPreferredSize(d);
            this.m_zoomSettings.add(new Integer(100));
            KFLogPanel tabLogPanel = new KFLogPanel();
            KnowledgeFlowApp.this.setUpLogPanel(tabLogPanel);
            Dimension d2 = new Dimension(100, 170);
            tabLogPanel.setPreferredSize(d2);
            tabLogPanel.setMinimumSize(d2);
            this.m_logPanels.add(tabLogPanel);
            this.m_environmentSettings.add(new Environment());
            this.m_filePaths.add(new File("-NONE-"));
            JSplitPane p2 = new JSplitPane(0, p1, tabLogPanel);
            p2.setOneTouchExpandable(true);
            p2.setDividerLocation(0.7);
            p2.setResizeWeight(1.0);
            JPanel splitHolder = new JPanel();
            splitHolder.setLayout(new BorderLayout());
            splitHolder.add((Component)p2, "Center");
            this.m_editedList.add(new Boolean(false));
            this.m_executingList.add(new Boolean(false));
            this.m_executionThreads.add(null);
            this.m_selectedBeans.add(new Vector());
            this.m_undoBufferList.add(new Stack());
            this.m_flowTabs.addTab(tabTitle, splitHolder);
            int tabIndex = this.getNumTabs() - 1;
            this.m_flowTabs.setTabComponentAt(tabIndex, new CloseableTabTitle(this.m_flowTabs));
            this.setActiveTab(this.getNumTabs() - 1);
            KnowledgeFlowApp.this.m_saveB.setEnabled(true);
        }
    }

    public static interface KFPerspective {
        public void setInstances(Instances var1) throws Exception;

        public boolean acceptsInstances();

        public String getPerspectiveTitle();

        public String getPerspectiveTipText();

        public Icon getPerspectiveIcon();

        public void setActive(boolean var1);

        public void setLoaded(boolean var1);

        public void setMainKFPerspective(MainKFPerspective var1);
    }

    protected class BeanLayout
    extends PrintablePanel {
        private static final long serialVersionUID = -146377012429662757L;

        protected BeanLayout() {
        }

        @Override
        public void paintComponent(Graphics gx) {
            double lz = (double)KnowledgeFlowApp.this.m_layoutZoom / 100.0;
            ((Graphics2D)gx).scale(lz, lz);
            if (KnowledgeFlowApp.this.m_layoutZoom < 100) {
                ((Graphics2D)gx).setStroke(new BasicStroke(2.0f));
            }
            super.paintComponent(gx);
            ((Graphics2D)gx).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)gx).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            BeanInstance.paintLabels(gx, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
            BeanConnection.paintConnections(gx, KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
            if (KnowledgeFlowApp.this.m_mode == 2) {
                gx.drawLine(KnowledgeFlowApp.this.m_startX, KnowledgeFlowApp.this.m_startY, KnowledgeFlowApp.this.m_oldX, KnowledgeFlowApp.this.m_oldY);
            } else if (KnowledgeFlowApp.this.m_mode == 4) {
                gx.drawRect(KnowledgeFlowApp.this.m_startX < KnowledgeFlowApp.this.m_oldX ? KnowledgeFlowApp.this.m_startX : KnowledgeFlowApp.this.m_oldX, KnowledgeFlowApp.this.m_startY < KnowledgeFlowApp.this.m_oldY ? KnowledgeFlowApp.this.m_startY : KnowledgeFlowApp.this.m_oldY, Math.abs(KnowledgeFlowApp.this.m_oldX - KnowledgeFlowApp.this.m_startX), Math.abs(KnowledgeFlowApp.this.m_oldY - KnowledgeFlowApp.this.m_startY));
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Vector<Object> comps = BeanInstance.getBeanInstances(KnowledgeFlowApp.this.m_mainKFPerspective.getCurrentTabIndex());
            for (int i = 0; i < comps.size(); ++i) {
                BeanInstance bi = (BeanInstance)comps.elementAt(i);
                JComponent c = (JComponent)bi.getBean();
                Dimension d = c.getPreferredSize();
                c.setBounds(bi.getX(), bi.getY(), d.width, d.height);
                c.revalidate();
            }
        }
    }

    protected class JTreeLeafDetails
    implements Serializable {
        private static final long serialVersionUID = 6197221540272931626L;
        protected String m_fullyQualifiedCompName = "";
        protected String m_leafLabel = "";
        protected String m_wekaAlgoName = "";
        protected transient Icon m_scaledIcon = null;
        protected Vector<Object> m_metaBean = null;
        protected boolean m_isMeta = false;
        protected String m_toolTipText = null;

        protected JTreeLeafDetails(String fullName, Icon icon) {
            this(fullName, "", icon);
        }

        protected JTreeLeafDetails(String name, Vector<Object> serializedMeta, Icon icon) {
            this(name, "", icon);
            this.m_metaBean = serializedMeta;
            this.m_isMeta = true;
            this.m_toolTipText = "Hold down shift and click to remove";
        }

        protected JTreeLeafDetails(String fullName, String wekaAlgoName, Icon icon) {
            this.m_fullyQualifiedCompName = fullName;
            this.m_wekaAlgoName = wekaAlgoName;
            String string = this.m_leafLabel = wekaAlgoName.length() > 0 ? wekaAlgoName : this.m_fullyQualifiedCompName;
            if (this.m_leafLabel.lastIndexOf(46) > 0) {
                this.m_leafLabel = this.m_leafLabel.substring(this.m_leafLabel.lastIndexOf(46) + 1, this.m_leafLabel.length());
            }
            this.m_scaledIcon = icon;
        }

        protected String getToolTipText() {
            return this.m_toolTipText;
        }

        protected void setToolTipText(String tipText) {
            this.m_toolTipText = tipText;
        }

        public String toString() {
            return this.m_leafLabel;
        }

        protected Icon getIcon() {
            return this.m_scaledIcon;
        }

        protected void setIcon(Icon icon) {
            this.m_scaledIcon = icon;
        }

        protected boolean isWrappedAlgorithm() {
            return this.m_wekaAlgoName != null && this.m_wekaAlgoName.length() > 0;
        }

        protected boolean isMetaBean() {
            return this.m_metaBean != null;
        }

        protected Vector<Object> getMetaBean() {
            return this.m_metaBean;
        }

        protected void instantiateBean() {
            try {
                if (this.isMetaBean()) {
                    KnowledgeFlowApp.this.m_toolBarBean = this.m_metaBean.get(1);
                } else {
                    KnowledgeFlowApp.this.m_toolBarBean = WekaPackageClassLoaderManager.objectForName(this.m_fullyQualifiedCompName);
                    if (this.isWrappedAlgorithm()) {
                        Object algo = WekaPackageClassLoaderManager.objectForName(this.m_wekaAlgoName);
                        ((WekaWrapper)KnowledgeFlowApp.this.m_toolBarBean).setWrappedAlgorithm(algo);
                    }
                }
                KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(1));
                KnowledgeFlowApp.this.m_mode = 3;
                KnowledgeFlowApp.this.m_pasteB.setEnabled(false);
            }
            catch (Exception ex) {
                System.err.println("Problem instantiating bean \"" + this.m_fullyQualifiedCompName + "\" (JTreeLeafDetails.instantiateBean()");
                ex.printStackTrace();
            }
        }
    }

    protected class InvisibleTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 6940101211275068260L;
        protected boolean m_filterIsActive;

        public InvisibleTreeModel(TreeNode root) {
            this(root, false);
        }

        public InvisibleTreeModel(TreeNode root, boolean asksAllowsChildren) {
            this(root, false, false);
        }

        public InvisibleTreeModel(TreeNode root, boolean asksAllowsChildren, boolean filterIsActive) {
            super(root, asksAllowsChildren);
            this.m_filterIsActive = filterIsActive;
        }

        public void activateFilter(boolean newValue) {
            this.m_filterIsActive = newValue;
        }

        public boolean isActivatedFilter() {
            return this.m_filterIsActive;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (this.m_filterIsActive && parent instanceof InvisibleNode) {
                return ((InvisibleNode)parent).getChildAt(index, this.m_filterIsActive);
            }
            return ((TreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (this.m_filterIsActive && parent instanceof InvisibleNode) {
                return ((InvisibleNode)parent).getChildCount(this.m_filterIsActive);
            }
            return ((TreeNode)parent).getChildCount();
        }
    }

    protected class InvisibleNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -9064396835384819887L;
        protected boolean m_isVisible;

        public InvisibleNode() {
            this(null);
        }

        public InvisibleNode(Object userObject) {
            this(userObject, true, true);
        }

        public InvisibleNode(Object userObject, boolean allowsChildren, boolean isVisible) {
            super(userObject, allowsChildren);
            this.m_isVisible = isVisible;
        }

        public TreeNode getChildAt(int index, boolean filterIsActive) {
            if (!filterIsActive) {
                return super.getChildAt(index);
            }
            if (this.children == null) {
                throw new ArrayIndexOutOfBoundsException("node has no children");
            }
            int realIndex = -1;
            int visibleIndex = -1;
            WekaEnumeration e = new WekaEnumeration(this.children);
            while (e.hasMoreElements()) {
                InvisibleNode node = (InvisibleNode)e.nextElement();
                if (node.isVisible()) {
                    ++visibleIndex;
                }
                ++realIndex;
                if (visibleIndex != index) continue;
                return (TreeNode)this.children.elementAt(realIndex);
            }
            throw new ArrayIndexOutOfBoundsException("index unmatched");
        }

        public int getChildCount(boolean filterIsActive) {
            if (!filterIsActive) {
                return super.getChildCount();
            }
            if (this.children == null) {
                return 0;
            }
            int count = 0;
            WekaEnumeration e = new WekaEnumeration(this.children);
            while (e.hasMoreElements()) {
                InvisibleNode node = (InvisibleNode)e.nextElement();
                if (!node.isVisible()) continue;
                ++count;
            }
            return count;
        }

        public void setVisible(boolean visible) {
            this.m_isVisible = visible;
        }

        public boolean isVisible() {
            return this.m_isVisible;
        }
    }

    protected class BeanIconRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -4488876734500244945L;

        protected BeanIconRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Icon i;
            Object userO;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf && (userO = ((DefaultMutableTreeNode)value).getUserObject()) instanceof JTreeLeafDetails && (i = ((JTreeLeafDetails)userO).getIcon()) != null) {
                this.setIcon(i);
            }
            return this;
        }
    }
}

