/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.PluginManager;
import weka.core.Range;
import weka.core.Utils;
import weka.core.converters.CSVLoader;
import weka.experiment.CSVResultListener;
import weka.experiment.DatabaseResultListener;
import weka.experiment.Experiment;
import weka.experiment.InstanceQuery;
import weka.experiment.PairedCorrectedTTester;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;
import weka.experiment.Tester;
import weka.gui.DatabaseConnectionDialog;
import weka.gui.ExtensionFileFilter;
import weka.gui.ListSelectorDialog;
import weka.gui.Perspective;
import weka.gui.PropertyDialog;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.WekaFileChooser;
import weka.gui.experiment.ExperimenterDefaults;
import weka.gui.experiment.OutputFormatDialog;
import weka.gui.explorer.Explorer;

public class ResultsPanel
extends JPanel {
    private static final long serialVersionUID = -4913007978534178569L;
    protected static final String NO_SOURCE = "No source";
    protected JButton m_FromFileBut = new JButton("File...");
    protected JButton m_FromDBaseBut = new JButton("Database...");
    protected JButton m_FromExpBut = new JButton("Experiment");
    protected JLabel m_FromLab = new JLabel("No source");
    private static String[] FOR_JFC_1_1_DCBM_BUG = new String[]{""};
    protected DefaultComboBoxModel m_DatasetModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
    protected DefaultComboBoxModel m_CompareModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
    protected DefaultComboBoxModel m_SortModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
    protected DefaultListModel m_TestsModel = new DefaultListModel();
    protected DefaultListModel m_DisplayedModel = new DefaultListModel();
    protected JLabel m_TesterClassesLabel = new JLabel("Testing with", 4);
    protected Perspective m_mainPerspective;
    protected DefaultComboBoxModel m_TesterClassesModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
    protected static Vector<Class<?>> m_Testers = null;
    protected JComboBox m_TesterClasses;
    protected JLabel m_DatasetAndResultKeysLabel = new JLabel("Select rows and cols", 4);
    protected JPanel m_PanelDatasetResultKeys = new JPanel(new GridLayout(1, 3));
    protected JButton m_DatasetKeyBut = new JButton("Rows");
    protected DefaultListModel m_DatasetKeyModel = new DefaultListModel();
    protected JList m_DatasetKeyList = new JList(this.m_DatasetKeyModel);
    protected JButton m_ResultKeyBut = new JButton("Cols");
    protected JButton m_SwapDatasetKeyAndResultKeyBut = new JButton("Swap");
    protected DefaultListModel m_ResultKeyModel = new DefaultListModel();
    protected JList m_ResultKeyList = new JList(this.m_ResultKeyModel);
    protected JButton m_TestsButton = new JButton("Select");
    protected JButton m_DisplayedButton = new JButton("Select");
    protected JList m_TestsList = new JList(this.m_TestsModel);
    protected JList m_DisplayedList = new JList(this.m_DisplayedModel);
    protected JComboBox m_CompareCombo = new JComboBox(this.m_CompareModel);
    protected JComboBox m_SortCombo = new JComboBox(this.m_SortModel);
    protected JTextField m_SigTex = new JTextField("" + ExperimenterDefaults.getSignificance());
    protected JCheckBox m_ShowStdDevs = new JCheckBox("");
    protected JButton m_OutputFormatButton = new JButton("Select");
    protected JButton m_Explorer = new JButton("Open Explorer...");
    protected JButton m_PerformBut = new JButton("Perform test");
    protected JButton m_SaveOutBut = new JButton("Save output");
    SaveBuffer m_SaveOut = new SaveBuffer(null, this);
    protected JTextArea m_OutText = new JTextArea();
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected WekaFileChooser m_FileChooser = new WekaFileChooser(new File(System.getProperty("user.dir")));
    protected ExtensionFileFilter m_csvFileFilter = new ExtensionFileFilter(CSVLoader.FILE_EXTENSION, "CSV data files");
    protected ExtensionFileFilter m_arffFileFilter = new ExtensionFileFilter(".arff", "Arff data files");
    protected Tester m_TTester = new PairedCorrectedTTester();
    protected Instances m_Instances;
    protected InstanceQuery m_InstanceQuery;
    protected Thread m_LoadThread;
    protected Experiment m_Exp;
    private final Dimension COMBO_SIZE;
    protected ResultMatrix m_ResultMatrix;

    public ResultsPanel() {
        this.COMBO_SIZE = new Dimension(210, this.m_ResultKeyBut.getPreferredSize().height);
        this.m_ResultMatrix = new ResultMatrixPlainText();
        List<String> classes = PluginManager.getPluginNamesOfTypeList(Tester.class.getName());
        m_Testers = new Vector();
        this.m_TesterClassesModel = new DefaultComboBoxModel();
        for (int i = 0; i < classes.size(); ++i) {
            try {
                Class<?> cls = Class.forName(classes.get(i).toString());
                Tester tester = (Tester)cls.newInstance();
                m_Testers.add(cls);
                this.m_TesterClassesModel.addElement(tester.getDisplayName());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_TesterClasses = new JComboBox(this.m_TesterClassesModel);
        this.m_TTester.setSignificanceLevel(ExperimenterDefaults.getSignificance());
        this.m_TTester.setShowStdDevs(ExperimenterDefaults.getShowStdDevs());
        this.m_ResultMatrix = ExperimenterDefaults.getOutputFormat();
        this.m_ResultMatrix.setShowStdDev(ExperimenterDefaults.getShowStdDevs());
        this.m_ResultMatrix.setMeanPrec(ExperimenterDefaults.getMeanPrecision());
        this.m_ResultMatrix.setStdDevPrec(ExperimenterDefaults.getStdDevPrecision());
        this.m_ResultMatrix.setRemoveFilterName(ExperimenterDefaults.getRemoveFilterClassnames());
        this.m_ResultMatrix.setShowAverage(ExperimenterDefaults.getShowAverage());
        this.m_FileChooser.addChoosableFileFilter(this.m_csvFileFilter);
        this.m_FileChooser.addChoosableFileFilter(this.m_arffFileFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_FromExpBut.setEnabled(false);
        this.m_FromExpBut.setMnemonic('E');
        this.m_FromExpBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ResultsPanel.this.m_LoadThread == null) {
                    ResultsPanel.this.m_LoadThread = new Thread(){

                        @Override
                        public void run() {
                            ResultsPanel.this.setInstancesFromExp(ResultsPanel.this.m_Exp);
                            ResultsPanel.this.m_LoadThread = null;
                        }
                    };
                    ResultsPanel.this.m_LoadThread.start();
                }
            }
        });
        this.m_FromDBaseBut.setMnemonic('D');
        this.m_FromDBaseBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ResultsPanel.this.m_LoadThread == null) {
                    ResultsPanel.this.m_LoadThread = new Thread(){

                        @Override
                        public void run() {
                            ResultsPanel.this.setInstancesFromDBaseQuery();
                            ResultsPanel.this.m_LoadThread = null;
                        }
                    };
                    ResultsPanel.this.m_LoadThread.start();
                }
            }
        });
        this.m_FromFileBut.setMnemonic('F');
        this.m_FromFileBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = ResultsPanel.this.m_FileChooser.showOpenDialog(ResultsPanel.this);
                if (returnVal == 0) {
                    final File selected = ResultsPanel.this.m_FileChooser.getSelectedFile();
                    if (ResultsPanel.this.m_LoadThread == null) {
                        ResultsPanel.this.m_LoadThread = new Thread(){

                            @Override
                            public void run() {
                                ResultsPanel.this.setInstancesFromFile(selected);
                                ResultsPanel.this.m_LoadThread = null;
                            }
                        };
                        ResultsPanel.this.m_LoadThread.start();
                    }
                }
            }
        });
        this.setComboSizes();
        this.m_TesterClasses.setEnabled(false);
        this.m_DatasetKeyBut.setEnabled(false);
        this.m_DatasetKeyBut.setToolTipText("For selecting the keys that are shown as rows.");
        this.m_DatasetKeyBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setDatasetKeyFromDialog();
            }
        });
        this.m_DatasetKeyList.setSelectionMode(2);
        this.m_ResultKeyBut.setEnabled(false);
        this.m_ResultKeyBut.setToolTipText("For selecting the keys that are shown as columns.");
        this.m_ResultKeyBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setResultKeyFromDialog();
            }
        });
        this.m_ResultKeyList.setSelectionMode(2);
        this.m_SwapDatasetKeyAndResultKeyBut.setEnabled(false);
        this.m_SwapDatasetKeyAndResultKeyBut.setToolTipText("Swaps the keys for selecting rows and columns.");
        this.m_SwapDatasetKeyAndResultKeyBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.swapDatasetKeyAndResultKey();
            }
        });
        this.m_CompareCombo.setEnabled(false);
        this.m_SortCombo.setEnabled(false);
        this.m_SigTex.setEnabled(false);
        this.m_TestsButton.setEnabled(false);
        this.m_TestsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setTestBaseFromDialog();
            }
        });
        this.m_DisplayedButton.setEnabled(false);
        this.m_DisplayedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setDisplayedFromDialog();
            }
        });
        this.m_ShowStdDevs.setEnabled(false);
        this.m_ShowStdDevs.setSelected(ExperimenterDefaults.getShowStdDevs());
        this.m_OutputFormatButton.setEnabled(false);
        this.m_OutputFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setOutputFormatFromDialog();
            }
        });
        this.m_Explorer.setEnabled(false);
        this.m_Explorer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.openExplorer();
            }
        });
        this.m_PerformBut.setEnabled(false);
        this.m_PerformBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.performTest();
                ResultsPanel.this.m_SaveOutBut.setEnabled(true);
            }
        });
        this.m_PerformBut.setToolTipText(this.m_TTester.getToolTipText());
        this.m_SaveOutBut.setEnabled(false);
        this.m_SaveOutBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.saveBuffer();
            }
        });
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.setEditable(false);
        this.m_History.setBorder(BorderFactory.createTitledBorder("Result list"));
        JPanel sourceAndButsHolder = new JPanel();
        sourceAndButsHolder.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createTitledBorder("Source"));
        sourceAndButsHolder.add((Component)p1, "North");
        JPanel p2 = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        p2.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        p2.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        p2.add((Component)this.m_FromFileBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        p2.add((Component)this.m_FromDBaseBut, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        p2.add((Component)this.m_FromExpBut, constraints);
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_FromLab, "Center");
        p1.add((Component)p2, "East");
        JPanel newButHolder = new JPanel();
        newButHolder.setLayout(new BorderLayout());
        newButHolder.setBorder(BorderFactory.createTitledBorder("Actions"));
        sourceAndButsHolder.add((Component)newButHolder, "South");
        JPanel p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder("Configure test"));
        GridBagLayout gbL = new GridBagLayout();
        p3.setLayout(gbL);
        int y = 0;
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_TesterClassesLabel, gbC);
        this.m_TesterClassesLabel.setDisplayedMnemonic('w');
        this.m_TesterClassesLabel.setLabelFor(this.m_TesterClasses);
        p3.add(this.m_TesterClassesLabel);
        gbC = new GridBagConstraints();
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbC.fill = 2;
        gbL.setConstraints(this.m_TesterClasses, gbC);
        p3.add(this.m_TesterClasses);
        this.m_TesterClasses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.setTester();
            }
        });
        this.setSelectedItem(this.m_TesterClasses, ExperimenterDefaults.getTester());
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(this.m_DatasetAndResultKeysLabel, gbC);
        this.m_DatasetAndResultKeysLabel.setDisplayedMnemonic('R');
        this.m_DatasetAndResultKeysLabel.setLabelFor(this.m_DatasetKeyBut);
        p3.add(this.m_DatasetAndResultKeysLabel);
        this.m_PanelDatasetResultKeys.add(this.m_DatasetKeyBut);
        this.m_PanelDatasetResultKeys.add(this.m_ResultKeyBut);
        this.m_PanelDatasetResultKeys.add(this.m_SwapDatasetKeyAndResultKeyBut);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_PanelDatasetResultKeys, gbC);
        p3.add(this.m_PanelDatasetResultKeys);
        JLabel lab = new JLabel("Comparison field", 4);
        lab.setDisplayedMnemonic('m');
        lab.setLabelFor(this.m_CompareCombo);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbC.fill = 2;
        gbL.setConstraints(this.m_CompareCombo, gbC);
        p3.add(this.m_CompareCombo);
        lab = new JLabel("Significance", 4);
        lab.setDisplayedMnemonic('g');
        lab.setLabelFor(this.m_SigTex);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbL.setConstraints(this.m_SigTex, gbC);
        p3.add(this.m_SigTex);
        lab = new JLabel("Sorting (asc.) by", 4);
        lab.setDisplayedMnemonic('S');
        lab.setLabelFor(this.m_SortCombo);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_SortCombo, gbC);
        p3.add(this.m_SortCombo);
        lab = new JLabel("Test base", 4);
        lab.setDisplayedMnemonic('b');
        lab.setLabelFor(this.m_TestsButton);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_TestsButton, gbC);
        p3.add(this.m_TestsButton);
        lab = new JLabel("Displayed Columns", 4);
        lab.setDisplayedMnemonic('i');
        lab.setLabelFor(this.m_DisplayedButton);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.fill = 2;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_DisplayedButton, gbC);
        p3.add(this.m_DisplayedButton);
        lab = new JLabel("Show std. deviations", 4);
        lab.setDisplayedMnemonic('a');
        lab.setLabelFor(this.m_ShowStdDevs);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = y++;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_ShowStdDevs, gbC);
        p3.add(this.m_ShowStdDevs);
        lab = new JLabel("Output Format", 4);
        lab.setDisplayedMnemonic('O');
        lab.setLabelFor(this.m_OutputFormatButton);
        gbC = new GridBagConstraints();
        gbC.anchor = 13;
        gbC.gridy = y;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 10, 2, 10);
        gbL.setConstraints(lab, gbC);
        p3.add(lab);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = y;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.insets = new Insets(5, 0, 5, 0);
        gbL.setConstraints(this.m_OutputFormatButton, gbC);
        p3.add(this.m_OutputFormatButton);
        JPanel output = new JPanel();
        output.setLayout(new BorderLayout());
        output.setBorder(BorderFactory.createTitledBorder("Test output"));
        output.add((Component)new JScrollPane(this.m_OutText), "Center");
        JPanel mondo = new JPanel();
        gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        gbC = new GridBagConstraints();
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        JPanel bts = new JPanel();
        this.m_PerformBut.setMnemonic('t');
        this.m_SaveOutBut.setMnemonic('S');
        bts.setLayout(new GridLayout(1, 3, 5, 5));
        bts.add(this.m_PerformBut);
        bts.add(this.m_SaveOutBut);
        bts.add(this.m_Explorer);
        newButHolder.add((Component)bts, "West");
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(this.m_History, gbC);
        mondo.add(this.m_History);
        JSplitPane splitPane = new JSplitPane(1, mondo, output);
        splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)sourceAndButsHolder, "North");
        this.add((Component)splitPane, "Center");
    }

    protected void setMainPerspective(Perspective mainPerspective) {
        this.m_mainPerspective = mainPerspective;
        if (this.m_mainPerspective.acceptsInstances()) {
            this.m_Explorer.setText("Send to " + mainPerspective.getPerspectiveTitle());
        }
    }

    protected void setComboSizes() {
        this.m_TesterClasses.setPreferredSize(this.COMBO_SIZE);
        this.m_PanelDatasetResultKeys.setPreferredSize(this.COMBO_SIZE);
        this.m_CompareCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_SigTex.setPreferredSize(this.COMBO_SIZE);
        this.m_SortCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_TesterClasses.setMaximumSize(this.COMBO_SIZE);
        this.m_PanelDatasetResultKeys.setMaximumSize(this.COMBO_SIZE);
        this.m_CompareCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_SigTex.setMaximumSize(this.COMBO_SIZE);
        this.m_SortCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_TesterClasses.setMinimumSize(this.COMBO_SIZE);
        this.m_PanelDatasetResultKeys.setMinimumSize(this.COMBO_SIZE);
        this.m_CompareCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_SigTex.setMinimumSize(this.COMBO_SIZE);
        this.m_SortCombo.setMinimumSize(this.COMBO_SIZE);
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_FromExpBut.setEnabled(exp != null);
    }

    protected void setInstancesFromDBaseQuery() {
        try {
            int result;
            if (this.m_InstanceQuery == null) {
                this.m_InstanceQuery = new InstanceQuery();
            }
            String dbaseURL = this.m_InstanceQuery.getDatabaseURL();
            String username = this.m_InstanceQuery.getUsername();
            String passwd = this.m_InstanceQuery.getPassword();
            DatabaseConnectionDialog dbd = new DatabaseConnectionDialog((Frame)SwingUtilities.getWindowAncestor(this), dbaseURL, username);
            dbd.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
            dbd.setVisible(true);
            if (dbd.getReturnValue() == -1) {
                this.m_FromLab.setText("Cancelled");
                return;
            }
            dbaseURL = dbd.getURL();
            username = dbd.getUsername();
            passwd = dbd.getPassword();
            this.m_InstanceQuery.setDatabaseURL(dbaseURL);
            this.m_InstanceQuery.setUsername(username);
            this.m_InstanceQuery.setPassword(passwd);
            this.m_InstanceQuery.setDebug(dbd.getDebug());
            this.m_InstanceQuery.connectToDatabase();
            if (!this.m_InstanceQuery.experimentIndexExists()) {
                System.err.println("not found");
                this.m_FromLab.setText("No experiment index");
                this.m_InstanceQuery.disconnectFromDatabase();
                return;
            }
            System.err.println("found");
            this.m_FromLab.setText("Getting experiment index");
            Instances index = this.m_InstanceQuery.retrieveInstances("SELECT * FROM Experiment_index");
            if (index.numInstances() == 0) {
                this.m_FromLab.setText("No experiments available");
                this.m_InstanceQuery.disconnectFromDatabase();
                return;
            }
            this.m_FromLab.setText("Got experiment index");
            DefaultListModel<String> lm = new DefaultListModel<String>();
            for (int i = 0; i < index.numInstances(); ++i) {
                lm.addElement(index.instance(i).toString());
            }
            JList jl = new JList(lm);
            jl.setSelectedIndex(0);
            if (jl.getModel().getSize() != 1) {
                ListSelectorDialog jd = new ListSelectorDialog(SwingUtilities.getWindowAncestor(this), jl);
                result = jd.showDialog();
            } else {
                result = 0;
            }
            if (result != 0) {
                this.m_FromLab.setText("Cancelled");
                this.m_InstanceQuery.disconnectFromDatabase();
                return;
            }
            Instance selInst = index.instance(jl.getSelectedIndex());
            Attribute tableAttr = index.attribute("Result_table");
            String table = "Results" + selInst.toString(tableAttr);
            this.setInstancesFromDatabaseTable(table);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_FromLab.setText("Problem reading database: '" + ex.getMessage() + "'");
        }
    }

    protected void setInstancesFromExp(Experiment exp) {
        if (exp.getResultListener() instanceof CSVResultListener) {
            File resultFile = ((CSVResultListener)exp.getResultListener()).getOutputFile();
            if (resultFile == null) {
                this.m_FromLab.setText("No result file");
            } else {
                this.setInstancesFromFile(resultFile);
            }
        } else if (exp.getResultListener() instanceof DatabaseResultListener) {
            String dbaseURL = ((DatabaseResultListener)exp.getResultListener()).getDatabaseURL();
            try {
                if (this.m_InstanceQuery == null) {
                    this.m_InstanceQuery = new InstanceQuery();
                }
                this.m_InstanceQuery.setDatabaseURL(dbaseURL);
                this.m_InstanceQuery.connectToDatabase();
                String tableName = this.m_InstanceQuery.getResultsTableName(exp.getResultProducer());
                this.setInstancesFromDatabaseTable(tableName);
            }
            catch (Exception ex) {
                this.m_FromLab.setText("Problem reading database");
            }
        } else {
            this.m_FromLab.setText("Can't get results from experiment");
        }
    }

    protected void setInstancesFromDatabaseTable(String tableName) {
        try {
            this.m_FromLab.setText("Reading from database, please wait...");
            final Instances i = this.m_InstanceQuery.retrieveInstances("SELECT * FROM " + tableName);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ResultsPanel.this.setInstances(i);
                }
            });
            this.m_InstanceQuery.disconnectFromDatabase();
        }
        catch (Exception ex) {
            this.m_FromLab.setText(ex.getMessage());
        }
    }

    protected void setInstancesFromFile(File f) {
        block5: {
            String fileType = f.getName();
            try {
                this.m_FromLab.setText("Reading from file...");
                if (f.getName().toLowerCase().endsWith(".arff")) {
                    fileType = "arff";
                    BufferedReader r = new BufferedReader(new FileReader(f));
                    this.setInstances(new Instances(r));
                    ((Reader)r).close();
                    break block5;
                }
                if (f.getName().toLowerCase().endsWith(CSVLoader.FILE_EXTENSION)) {
                    fileType = "csv";
                    CSVLoader cnv = new CSVLoader();
                    cnv.setSource(f);
                    Instances inst = cnv.getDataSet();
                    this.setInstances(inst);
                    break block5;
                }
                throw new Exception("Unrecognized file type");
            }
            catch (Exception ex) {
                this.m_FromLab.setText("File '" + f.getName() + "' not recognised as an " + fileType + " file.");
                if (JOptionPane.showOptionDialog(this, "File '" + f.getName() + "' not recognised as an " + fileType + " file.\nReason:\n" + ex.getMessage(), "Load Instances", 0, 0, null, new String[]{"OK"}, null) == 1) {
                    // empty if block
                }
            }
        }
    }

    protected Vector<String> determineColumnNames(String list, String defaultList, Instances inst) {
        Vector<String> atts = new Vector<String>();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            atts.add(inst.attribute(i).name().toLowerCase());
        }
        Vector<String> result = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(list, ",");
        while (tok.hasMoreTokens()) {
            String item = tok.nextToken().toLowerCase();
            if (atts.contains(item)) {
                result.add(item);
                continue;
            }
            result.clear();
            break;
        }
        if (result.size() == 0) {
            tok = new StringTokenizer(defaultList, ",");
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken().toLowerCase());
            }
        }
        return result;
    }

    public void setInstances(Instances newInstances) {
        this.m_Instances = newInstances;
        this.m_TTester.setInstances(this.m_Instances);
        this.m_FromLab.setText("Got " + this.m_Instances.numInstances() + " results");
        Vector<String> rows = this.determineColumnNames(ExperimenterDefaults.getRow(), "Key_Dataset", this.m_Instances);
        Vector<String> cols = this.determineColumnNames(ExperimenterDefaults.getColumn(), "Key_Scheme,Key_Scheme_options,Key_Scheme_version_ID", this.m_Instances);
        this.m_DatasetKeyModel.removeAllElements();
        this.m_ResultKeyModel.removeAllElements();
        this.m_CompareModel.removeAllElements();
        this.m_SortModel.removeAllElements();
        this.m_SortModel.addElement("<default>");
        this.m_TTester.setSortColumn(-1);
        String selectedList = "";
        String selectedListDataset = "";
        boolean comparisonFieldSet = false;
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            String name = this.m_Instances.attribute(i).name();
            if (name.toLowerCase().startsWith("key_", 0)) {
                this.m_DatasetKeyModel.addElement(name.substring(4));
                this.m_ResultKeyModel.addElement(name.substring(4));
                this.m_CompareModel.addElement(name.substring(4));
            } else {
                this.m_DatasetKeyModel.addElement(name);
                this.m_ResultKeyModel.addElement(name);
                this.m_CompareModel.addElement(name);
                if (this.m_Instances.attribute(i).isNumeric()) {
                    this.m_SortModel.addElement(name);
                }
            }
            if (rows.contains(name.toLowerCase())) {
                this.m_DatasetKeyList.addSelectionInterval(i, i);
                selectedListDataset = selectedListDataset + "," + (i + 1);
                continue;
            }
            if (name.toLowerCase().equals("key_run")) {
                this.m_TTester.setRunColumn(i);
                continue;
            }
            if (name.toLowerCase().equals("key_fold")) {
                this.m_TTester.setFoldColumn(i);
                continue;
            }
            if (cols.contains(name.toLowerCase())) {
                this.m_ResultKeyList.addSelectionInterval(i, i);
                selectedList = selectedList + "," + (i + 1);
                continue;
            }
            if (name.toLowerCase().indexOf(ExperimenterDefaults.getComparisonField()) != -1) {
                this.m_CompareCombo.setSelectedIndex(i);
                comparisonFieldSet = true;
                continue;
            }
            if (name.toLowerCase().indexOf("root_relative_squared_error") == -1 || comparisonFieldSet) continue;
            this.m_CompareCombo.setSelectedIndex(i);
            comparisonFieldSet = true;
        }
        this.m_TesterClasses.setEnabled(true);
        this.m_DatasetKeyBut.setEnabled(true);
        this.m_ResultKeyBut.setEnabled(true);
        this.m_SwapDatasetKeyAndResultKeyBut.setEnabled(true);
        this.m_CompareCombo.setEnabled(true);
        this.m_SortCombo.setEnabled(true);
        if (ExperimenterDefaults.getSorting().length() != 0) {
            this.setSelectedItem(this.m_SortCombo, ExperimenterDefaults.getSorting());
        }
        Range generatorRange = new Range();
        if (selectedList.length() != 0) {
            try {
                generatorRange.setRanges(selectedList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex.getMessage());
            }
        }
        this.m_TTester.setResultsetKeyColumns(generatorRange);
        generatorRange = new Range();
        if (selectedListDataset.length() != 0) {
            try {
                generatorRange.setRanges(selectedListDataset);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex.getMessage());
            }
        }
        this.m_TTester.setDatasetKeyColumns(generatorRange);
        this.m_SigTex.setEnabled(true);
        this.setTTester();
    }

    protected void setSelectedItem(JComboBox cb, String item) {
        for (int i = 0; i < cb.getItemCount(); ++i) {
            if (!cb.getItemAt(i).toString().equals(item)) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    protected void setTTester() {
        int i;
        this.m_TTester.setDisplayedResultsets(null);
        String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date()) + "Available resultsets";
        StringBuffer outBuff = new StringBuffer();
        outBuff.append("Available resultsets\n" + this.m_TTester.resultsetKey() + "\n\n");
        this.m_History.addResult(name, outBuff);
        this.m_History.setSingle(name);
        this.m_TestsModel.removeAllElements();
        for (i = 0; i < this.m_TTester.getNumResultsets(); ++i) {
            String tname = this.m_TTester.getResultsetName(i);
            this.m_TestsModel.addElement(tname);
        }
        this.m_DisplayedModel.removeAllElements();
        for (i = 0; i < this.m_TestsModel.size(); ++i) {
            this.m_DisplayedModel.addElement(this.m_TestsModel.elementAt(i));
        }
        this.m_TestsModel.addElement("Summary");
        this.m_TestsModel.addElement("Ranking");
        this.m_TestsList.setSelectedIndex(0);
        this.m_DisplayedList.setSelectionInterval(0, this.m_DisplayedModel.size() - 1);
        this.m_TestsButton.setEnabled(true);
        this.m_DisplayedButton.setEnabled(true);
        this.m_ShowStdDevs.setEnabled(true);
        this.m_OutputFormatButton.setEnabled(true);
        this.m_PerformBut.setEnabled(true);
        this.m_Explorer.setEnabled(true);
    }

    protected void performTest() {
        String sigStr = this.m_SigTex.getText();
        if (sigStr.length() != 0) {
            this.m_TTester.setSignificanceLevel(new Double(sigStr));
        } else {
            this.m_TTester.setSignificanceLevel(ExperimenterDefaults.getSignificance());
        }
        this.m_TTester.setShowStdDevs(this.m_ShowStdDevs.isSelected());
        if (this.m_Instances.attribute(this.m_SortCombo.getSelectedItem().toString()) != null) {
            this.m_TTester.setSortColumn(this.m_Instances.attribute(this.m_SortCombo.getSelectedItem().toString()).index());
        } else {
            this.m_TTester.setSortColumn(-1);
        }
        int compareCol = this.m_CompareCombo.getSelectedIndex();
        int tType = this.m_TestsList.getSelectedIndex();
        this.m_TTester.setResultMatrix(this.m_ResultMatrix);
        String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date()) + (String)this.m_CompareCombo.getSelectedItem() + " - " + (String)this.m_TestsList.getSelectedValue();
        StringBuffer outBuff = new StringBuffer();
        outBuff.append(this.m_TTester.header(compareCol));
        outBuff.append("\n");
        this.m_History.addResult(name, outBuff);
        this.m_History.setSingle(name);
        this.m_TTester.setDisplayedResultsets(this.m_DisplayedList.getSelectedIndices());
        try {
            if (tType < this.m_TTester.getNumResultsets()) {
                outBuff.append(this.m_TTester.multiResultsetFull(tType, compareCol));
            } else if (tType == this.m_TTester.getNumResultsets()) {
                outBuff.append(this.m_TTester.multiResultsetSummary(compareCol));
            } else {
                outBuff.append(this.m_TTester.multiResultsetRanking(compareCol));
            }
            outBuff.append("\n");
        }
        catch (Exception ex) {
            outBuff.append(ex.getMessage() + "\n");
        }
        this.m_History.updateResult(name);
    }

    public void setResultKeyFromDialog() {
        ListSelectorDialog jd = new ListSelectorDialog(SwingUtilities.getWindowAncestor(this), this.m_ResultKeyList);
        int result = jd.showDialog();
        if (result == 0) {
            int[] selected = this.m_ResultKeyList.getSelectedIndices();
            String selectedList = "";
            for (int element : selected) {
                selectedList = selectedList + "," + (element + 1);
            }
            Range generatorRange = new Range();
            if (selectedList.length() != 0) {
                try {
                    generatorRange.setRanges(selectedList);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println(ex.getMessage());
                }
            }
            this.m_TTester.setResultsetKeyColumns(generatorRange);
            this.setTTester();
        }
    }

    public void setDatasetKeyFromDialog() {
        ListSelectorDialog jd = new ListSelectorDialog(SwingUtilities.getWindowAncestor(this), this.m_DatasetKeyList);
        int result = jd.showDialog();
        if (result == 0) {
            int[] selected = this.m_DatasetKeyList.getSelectedIndices();
            String selectedList = "";
            for (int element : selected) {
                selectedList = selectedList + "," + (element + 1);
            }
            Range generatorRange = new Range();
            if (selectedList.length() != 0) {
                try {
                    generatorRange.setRanges(selectedList);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println(ex.getMessage());
                }
            }
            this.m_TTester.setDatasetKeyColumns(generatorRange);
            this.setTTester();
        }
    }

    protected void swapDatasetKeyAndResultKey() {
        int[] tmpSelected = this.m_DatasetKeyList.getSelectedIndices();
        this.m_DatasetKeyList.setSelectedIndices(this.m_ResultKeyList.getSelectedIndices());
        this.m_ResultKeyList.setSelectedIndices(tmpSelected);
        Range tmpRange = this.m_TTester.getDatasetKeyColumns();
        this.m_TTester.setDatasetKeyColumns(this.m_TTester.getResultsetKeyColumns());
        this.m_TTester.setResultsetKeyColumns(tmpRange);
        this.setTTester();
    }

    public void setTestBaseFromDialog() {
        ListSelectorDialog jd = new ListSelectorDialog(SwingUtilities.getWindowAncestor(this), this.m_TestsList);
        jd.showDialog();
    }

    public void setDisplayedFromDialog() {
        ListSelectorDialog jd = new ListSelectorDialog(SwingUtilities.getWindowAncestor(this), this.m_DisplayedList);
        jd.showDialog();
    }

    public void setOutputFormatFromDialog() {
        OutputFormatDialog dialog = new OutputFormatDialog(PropertyDialog.getParentFrame(this));
        this.m_ResultMatrix.setShowStdDev(this.m_ShowStdDevs.isSelected());
        dialog.setResultMatrix(this.m_ResultMatrix);
        dialog.setLocationRelativeTo(this);
        if (dialog.showDialog() == 0) {
            this.m_ResultMatrix = dialog.getResultMatrix();
            this.m_ShowStdDevs.setSelected(this.m_ResultMatrix.getShowStdDev());
        }
    }

    protected void saveBuffer() {
        StringBuffer sb = this.m_History.getSelectedBuffer();
        if (sb != null) {
            if (this.m_SaveOut.save(sb)) {
                JOptionPane.showMessageDialog(this, "File saved", "Results", 1);
            }
        } else {
            this.m_SaveOutBut.setEnabled(false);
        }
    }

    protected void setTester() {
        if (this.m_TesterClasses.getSelectedItem() == null) {
            return;
        }
        Tester tester = null;
        try {
            for (int i = 0; i < m_Testers.size(); ++i) {
                Tester t = (Tester)m_Testers.get(i).newInstance();
                if (!t.getDisplayName().equals(this.m_TesterClasses.getSelectedItem())) continue;
                tester = t;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tester == null) {
            tester = new PairedCorrectedTTester();
            this.m_TesterClasses.setSelectedItem(tester.getDisplayName());
        }
        tester.assign(this.m_TTester);
        this.m_TTester = tester;
        this.m_PerformBut.setToolTipText(this.m_TTester.getToolTipText());
        System.out.println("Tester set to: " + this.m_TTester.getClass().getName());
    }

    protected synchronized void openExplorer() {
        if (this.m_Instances != null) {
            if (this.m_mainPerspective == null || !this.m_mainPerspective.acceptsInstances()) {
                final Explorer exp = new Explorer();
                exp.getPreprocessPanel().setInstances(this.m_Instances);
                final JFrameWrapper jf = new JFrameWrapper();
                jf.m_Frame = Utils.getWekaJFrame("Weka Explorer", this);
                jf.m_Frame.getContentPane().setLayout(new BorderLayout());
                jf.m_Frame.getContentPane().add((Component)exp, "Center");
                jf.m_Frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        exp.terminate();
                        jf.m_Frame.dispose();
                        jf.m_Frame = null;
                    }
                });
                jf.m_Frame.pack();
                jf.m_Frame.setSize(1024, 768);
                jf.m_Frame.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this));
                jf.m_Frame.setVisible(true);
            } else {
                this.m_mainPerspective.setInstances(this.m_Instances);
                this.m_mainPerspective.getMainApplication().getPerspectiveManager().setActivePerspective(this.m_mainPerspective.getPerspectiveID());
            }
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Experiment: Results Analysis");
            jf.getContentPane().setLayout(new BorderLayout());
            ResultsPanel sp = new ResultsPanel();
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(700, 550);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    protected class JFrameWrapper {
        protected JFrame m_Frame;

        protected JFrameWrapper() {
        }
    }
}

