/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.selection.SelectionOperator;

public abstract class AbstractCoralReefsOptimization<S, R>
implements Algorithm<R> {
    protected List<S> population;
    protected List<Coordinate> coordinates;
    protected SelectionOperator<List<S>, S> selectionOperator;
    protected CrossoverOperator<S> crossoverOperator;
    protected MutationOperator<S> mutationOperator;
    protected Comparator<S> comparator;
    private int N;
    private int M;
    private double rho;
    private double Fbs;
    private double Fbr;
    private double Fa;
    private double Fd;
    private double Pd;
    private int attemptsToSettle;

    public List<S> getPopulation() {
        return this.population;
    }

    public int getPopulationSize() {
        return this.population.size();
    }

    public List<Coordinate> getCoordinates() {
        return this.coordinates;
    }

    public void setPopulation(List<S> population) {
        this.population = population;
    }

    public void setCoordinates(List<Coordinate> coordinates) {
        this.coordinates = coordinates;
    }

    public int getN() {
        return this.N;
    }

    public int getM() {
        return this.M;
    }

    public double getRho() {
        return this.rho;
    }

    public double getFbs() {
        return this.Fbs;
    }

    public double getFbr() {
        return this.Fbr;
    }

    public double getFa() {
        return this.Fa;
    }

    public double getFd() {
        return this.Fd;
    }

    public double getPd() {
        return this.Pd;
    }

    public int getAttemptsToSettle() {
        return this.attemptsToSettle;
    }

    public AbstractCoralReefsOptimization(Comparator<S> comparator, SelectionOperator<List<S>, S> selectionOperator, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, int n, int m, double rho, double fbs, double fa, double pd, int attemptsToSettle) {
        this.comparator = comparator;
        this.selectionOperator = selectionOperator;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.N = n;
        this.M = m;
        this.rho = rho;
        this.Fbs = fbs;
        this.Fbr = 1.0 - fbs;
        this.Fa = fa;
        this.Fd = fa;
        this.Pd = pd;
        this.attemptsToSettle = attemptsToSettle;
    }

    protected abstract void initProgress();

    protected abstract void updateProgress();

    protected abstract boolean isStoppingConditionReached();

    protected abstract List<S> createInitialPopulation();

    protected abstract List<Coordinate> generateCoordinates();

    protected abstract List<S> evaluatePopulation(List<S> var1);

    protected abstract List<S> selectBroadcastSpawners(List<S> var1);

    protected abstract List<S> sexualReproduction(List<S> var1);

    protected abstract List<S> asexualReproduction(List<S> var1);

    protected abstract List<S> larvaeSettlementPhase(List<S> var1, List<S> var2, List<Coordinate> var3);

    protected abstract List<S> depredation(List<S> var1, List<Coordinate> var2);

    @Override
    public void run() {
        this.population = this.createInitialPopulation();
        this.population = this.evaluatePopulation(this.population);
        this.coordinates = this.generateCoordinates();
        this.initProgress();
        while (!this.isStoppingConditionReached()) {
            List<S> broadcastSpawners = this.selectBroadcastSpawners(this.population);
            ArrayList<S> brooders = new ArrayList<S>((int)(this.Fbr * (double)this.population.size()));
            for (S coral : this.population) {
                if (broadcastSpawners.contains(coral)) continue;
                brooders.add(coral);
            }
            List<Object> larvae = this.sexualReproduction(broadcastSpawners);
            larvae = this.evaluatePopulation(larvae);
            this.population = this.larvaeSettlementPhase(larvae, this.population, this.coordinates);
            larvae = this.asexualReproduction(brooders);
            larvae = this.evaluatePopulation(larvae);
            this.population = this.larvaeSettlementPhase(larvae, this.population, this.coordinates);
            Collections.sort(this.population, this.comparator);
            ArrayList<S> budders = new ArrayList<S>(this.population.subList(0, (int)this.Fa * this.population.size()));
            this.population = this.larvaeSettlementPhase(budders, this.population, this.coordinates);
            Collections.sort(this.population, this.comparator);
            this.population = this.depredation(this.population, this.coordinates);
            this.updateProgress();
        }
    }

    @Override
    public abstract R getResult();

    public static class Coordinate
    implements Comparable<Coordinate> {
        private int x;
        private int y;

        public Coordinate(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        @Override
        public int compareTo(Coordinate arg0) {
            int diffX = Math.abs(arg0.x - this.x);
            int diffY = Math.abs(arg0.y - this.y);
            double result = Math.sqrt(diffX * diffX + diffY * diffY);
            return Integer.parseInt(Double.toString(result));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Coordinate other = (Coordinate)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }
    }
}

