/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class Epsilon
extends QualityIndicator {
    public Epsilon() {
    }

    public Epsilon(double[][] referenceFront) {
        super(referenceFront);
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }

    @Override
    public double compute(double[][] front) {
        Check.notNull(front);
        return this.epsilon(front, this.referenceFront);
    }

    private double epsilon(double[][] front, double[][] referenceFront) throws JMetalException {
        int numberOfObjectives = front[0].length;
        double eps = Double.MIN_VALUE;
        double epsJ = 0.0;
        double epsK = 0.0;
        for (int i = 0; i < referenceFront.length; ++i) {
            for (int j = 0; j < front.length; ++j) {
                for (int k = 0; k < numberOfObjectives; ++k) {
                    double epsTemp = front[j][k] - referenceFront[i][k];
                    if (k == 0) {
                        epsK = epsTemp;
                        continue;
                    }
                    if (!(epsK < epsTemp)) continue;
                    epsK = epsTemp;
                }
                if (j == 0) {
                    epsJ = epsK;
                    continue;
                }
                if (!(epsJ > epsK)) continue;
                epsJ = epsK;
            }
            if (i == 0) {
                eps = epsJ;
                continue;
            }
            if (!(eps < epsJ)) continue;
            eps = epsJ;
        }
        return eps;
    }

    @Override
    public String getDescription() {
        return "Additive Epsilon quality indicator";
    }

    @Override
    public String getName() {
        return "EP";
    }
}

