/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.permutationsolution.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.IntStream;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;

public class IntegerPermutationSolution
extends AbstractSolution<Integer>
implements PermutationSolution<Integer> {
    public IntegerPermutationSolution(int permutationLength, int numberOfObjectives) {
        super(permutationLength, numberOfObjectives);
        ArrayList<Integer> randomSequence = new ArrayList<Integer>(permutationLength);
        for (int j = 0; j < permutationLength; ++j) {
            randomSequence.add(j);
        }
        Collections.shuffle(randomSequence);
        IntStream.range(0, permutationLength).forEach(i -> this.variables().set(i, (Integer)randomSequence.get(i)));
    }

    public IntegerPermutationSolution(IntegerPermutationSolution solution) {
        super(solution.getLength(), solution.objectives().length);
        Arrays.setAll(this.objectives(), i -> solution.objectives()[i]);
        for (int i2 = 0; i2 < this.variables().size(); ++i2) {
            this.variables().set(i2, (Integer)solution.variables().get(i2));
        }
        Arrays.setAll(this.constraints(), i -> solution.constraints()[i]);
        this.attributes = new HashMap(solution.attributes);
    }

    public IntegerPermutationSolution copy() {
        return new IntegerPermutationSolution(this);
    }

    @Override
    public int getLength() {
        return this.variables().size();
    }
}

