/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.aggregationfunction.impl;

import org.uma.jmetal.util.aggregationfunction.AggregationFunction;
import org.uma.jmetal.util.point.impl.NadirPoint;

public class InvertedPenaltyBoundaryIntersection
implements AggregationFunction {
    private NadirPoint nadirPoint = null;
    private final double theta;

    public InvertedPenaltyBoundaryIntersection() {
        this(5.0);
    }

    public InvertedPenaltyBoundaryIntersection(double theta) {
        this.theta = theta;
    }

    @Override
    public double compute(double[] vector, double[] weightVector) {
        int i;
        double nl = 0.0;
        double d2 = 0.0;
        double d1 = 0.0;
        for (i = 0; i < vector.length; ++i) {
            d1 += (this.nadirPoint.value(i) - vector[i]) * weightVector[i];
            nl += Math.pow(weightVector[i], 2.0);
        }
        nl = Math.sqrt(nl);
        d1 = Math.abs(d1) / nl;
        for (i = 0; i < vector.length; ++i) {
            d2 += Math.pow(this.nadirPoint.value(i) - vector[i] - d1 * (weightVector[i] / nl), 2.0);
        }
        d2 = Math.sqrt(d2);
        return d1 - this.theta * d2;
    }

    @Override
    public void update(double[] vector) {
        if (this.nadirPoint == null) {
            this.nadirPoint = new NadirPoint(vector.length);
        }
        this.nadirPoint.update(vector);
    }
}

