/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.aggregationfunction.impl;

import org.uma.jmetal.util.aggregationfunction.AggregationFunction;
import org.uma.jmetal.util.point.impl.IdealPoint;

public class ModifiedTschebyscheff
implements AggregationFunction {
    private IdealPoint idealPoint = null;

    @Override
    public double compute(double[] vector, double[] weightVector) {
        double maxFun = -1.0E30;
        for (int n = 0; n < vector.length; ++n) {
            double diff = Math.abs(vector[n] - this.idealPoint.value(n));
            double feval = weightVector[n] == 0.0 ? 1.0E-7 * diff : diff * 1.0 / weightVector[n];
            if (!(feval > maxFun)) continue;
            maxFun = feval;
        }
        return maxFun;
    }

    @Override
    public void update(double[] vector) {
        if (this.idealPoint == null) {
            this.idealPoint = new IdealPoint(vector.length);
        }
        this.idealPoint.update(vector);
    }
}

