/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.densityestimator.DensityEstimator;

public class GenericBoundedArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> comparator;
    private DensityEstimator<S> densityEstimator;

    public GenericBoundedArchive(int maxSize, DensityEstimator<S> densityEstimator) {
        super(maxSize);
        this.densityEstimator = densityEstimator;
        this.comparator = densityEstimator.getComparator();
    }

    @Override
    public void prune() {
        if (this.solutions().size() > this.maximumSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.solutions(), this.comparator);
            this.solutions().remove(worst);
        }
    }

    @Override
    public Comparator<S> comparator() {
        return this.comparator;
    }

    @Override
    public void computeDensityEstimator() {
        this.densityEstimator.compute(this.solutions());
    }
}

