/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.artificialdecisionmaker;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.artificialdecisionmaker.InteractiveAlgorithm;

public abstract class ArtificialDecisionMaker<S, R>
implements Algorithm<R> {
    protected InteractiveAlgorithm<S, R> algorithm;
    protected Problem<S> problem;
    protected List<Integer> indexOfRelevantObjectiveFunctions;
    protected List<S> paretoOptimalSolutions;

    public ArtificialDecisionMaker(Problem<S> problem, InteractiveAlgorithm<S, R> algorithm) {
        this.problem = problem;
        this.algorithm = algorithm;
        this.indexOfRelevantObjectiveFunctions = new ArrayList<Integer>();
        this.paretoOptimalSolutions = new ArrayList<S>();
    }

    protected abstract List<Double> generatePreferenceInformation();

    protected abstract boolean isStoppingConditionReached();

    protected abstract void initProgress();

    protected abstract void updateProgress();

    protected abstract List<Integer> relevantObjectiveFunctions(R var1);

    protected abstract List<Double> calculateReferencePoints(List<Integer> var1, R var2, List<S> var3);

    protected abstract void updateParetoOptimal(R var1, List<S> var2);

    public abstract List<Double> getReferencePoints();

    public abstract List<Double> getDistances();

    @Override
    public void run() {
        List<Double> initialReferencePoints;
        List<Double> interestingPoint = initialReferencePoints = this.generatePreferenceInformation();
        this.initProgress();
        while (!this.isStoppingConditionReached()) {
            this.algorithm.updatePointOfInterest(interestingPoint);
            this.algorithm.run();
            Object front = this.algorithm.getResult();
            this.updateParetoOptimal(front, this.paretoOptimalSolutions);
            this.indexOfRelevantObjectiveFunctions = this.relevantObjectiveFunctions(front);
            interestingPoint = this.calculateReferencePoints(this.indexOfRelevantObjectiveFunctions, front, this.paretoOptimalSolutions);
            this.updateProgress();
        }
    }

    @Override
    public R getResult() {
        return (R)this.algorithm.getResult();
    }

    @Override
    public String getName() {
        return "ArtificialDecisionMaker";
    }

    @Override
    public String getDescription() {
        return "ArtificialDecisionMaker";
    }
}

