/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.densityestimator.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.dominanceComparator.impl.DominanceWithConstraintsComparator;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.errorchecking.Check;

public class StrenghtRawFitnessDensityEstimator<S extends Solution<?>>
implements DensityEstimator<S> {
    private final String attributeId = this.getClass().getName();
    private int k;
    private static final Comparator<Solution<?>> DOMINANCE_COMPARATOR = new DominanceWithConstraintsComparator();

    public StrenghtRawFitnessDensityEstimator(int k) {
        this.k = k;
    }

    @Override
    public void compute(List<S> solutionList) {
        int i;
        double[][] distance = SolutionListUtils.distanceMatrix(solutionList);
        double[] strength = new double[solutionList.size()];
        double[] rawFitness = new double[solutionList.size()];
        for (i = 0; i < solutionList.size(); ++i) {
            for (Solution solution : solutionList) {
                if (DOMINANCE_COMPARATOR.compare((Solution)solutionList.get(i), solution) != -1) continue;
                int n = i;
                strength[n] = strength[n] + 1.0;
            }
        }
        for (i = 0; i < solutionList.size(); ++i) {
            for (int j = 0; j < solutionList.size(); ++j) {
                if (DOMINANCE_COMPARATOR.compare((Solution)solutionList.get(i), (Solution)solutionList.get(j)) != 1) continue;
                int n = i;
                rawFitness[n] = rawFitness[n] + strength[j];
            }
        }
        for (i = 0; i < distance.length; ++i) {
            Arrays.sort(distance[i]);
            double kDistance = 1.0 / (distance[i][this.k] + 2.0);
            ((Solution)solutionList.get(i)).attributes().put(this.attributeId, rawFitness[i] + kDistance);
        }
    }

    @Override
    public Double getValue(S solution) {
        Check.notNull(solution);
        Double result = 0.0;
        if (solution.attributes().get(this.attributeId) != null) {
            result = (Double)solution.attributes().get(this.attributeId);
        }
        return result;
    }

    @Override
    public Comparator<S> getComparator() {
        return Comparator.comparing(this::getValue);
    }
}

