/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.distance.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.distance.Distance;

public class DistanceBetweenSolutionAndKNearestNeighbors<S extends Solution<?>>
implements Distance<S, List<S>> {
    private final int k;
    private Distance<S, S> distance;

    public DistanceBetweenSolutionAndKNearestNeighbors(int k, Distance<S, S> distance) {
        this.k = k;
        this.distance = distance;
    }

    @Override
    public double compute(S solution, List<S> solutionList) {
        List<Double> listOfDistances = this.knnDistances(solution, solutionList);
        listOfDistances.sort(Comparator.naturalOrder());
        int limit = Math.min(this.k, listOfDistances.size());
        double result = limit == 0 ? 0.0 : listOfDistances.get(limit - 1);
        return result;
    }

    private List<Double> knnDistances(S solution, List<S> solutionList) {
        ArrayList<Double> listOfDistances = new ArrayList<Double>();
        for (int i = 0; i < solutionList.size(); ++i) {
            double distanceBetweenSolutions = this.distance.compute(solution, (Solution)solutionList.get(i));
            if (distanceBetweenSolutions == 0.0) continue;
            listOfDistances.add(distanceBetweenSolutions);
        }
        return listOfDistances;
    }
}

