/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.grouping.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.grouping.impl.ListGrouping;

public class ListLinearGrouping<C extends Comparable<C>>
extends ListGrouping<C> {
    private int lastListSize = 0;

    public ListLinearGrouping(int numberOfGroups) {
        super(numberOfGroups);
    }

    @Override
    public void computeGroups(List<C> list) {
        Check.notNull(list);
        if (this.lastListSize != list.size()) {
            this.indices = new ArrayList(list.size());
            IntStream.range(0, list.size()).forEach(i -> this.indices.add(i));
            this.createGroups();
            this.lastListSize = list.size();
        }
    }
}

