/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.impl;

import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.HypervolumeContributionComparator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.legacy.front.Front;
import org.uma.jmetal.util.legacy.front.impl.ArrayFront;
import org.uma.jmetal.util.legacy.front.util.FrontNormalizer;
import org.uma.jmetal.util.legacy.front.util.FrontUtils;
import org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.Hypervolume;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.solutionattribute.impl.HypervolumeContributionAttribute;

@Deprecated
public class PISAHypervolume<S extends Solution<?>>
extends Hypervolume<S> {
    private static final double DEFAULT_OFFSET = 100.0;
    private double offset = 100.0;

    public PISAHypervolume() {
    }

    public PISAHypervolume(double[] referencePoint) {
        super(referencePoint);
    }

    public PISAHypervolume(String referenceParetoFrontFile) throws FileNotFoundException {
        super(referenceParetoFrontFile);
    }

    public PISAHypervolume(Front referenceParetoFront) {
        super(referenceParetoFront);
    }

    @Override
    public Double evaluate(List<S> paretoFrontApproximation) {
        Check.notNull(paretoFrontApproximation);
        return this.hypervolume(new ArrayFront(paretoFrontApproximation), this.referenceParetoFront);
    }

    private boolean dominates(double[] point1, double[] point2, int noObjectives) {
        int i;
        int betterInAnyObjective = 0;
        for (i = 0; i < noObjectives && point1[i] >= point2[i]; ++i) {
            if (!(point1[i] > point2[i])) continue;
            betterInAnyObjective = 1;
        }
        return i >= noObjectives && betterInAnyObjective > 0;
    }

    private void swap(double[][] front, int i, int j) {
        double[] temp = front[i];
        front[i] = front[j];
        front[j] = temp;
    }

    private int filterNondominatedSet(double[][] front, int noPoints, int noObjectives) {
        int n = noPoints;
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (this.dominates(front[i], front[j], noObjectives)) {
                    this.swap(front, j, --n);
                    continue;
                }
                if (this.dominates(front[j], front[i], noObjectives)) {
                    this.swap(front, i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return n;
    }

    private double surfaceUnchangedTo(double[][] front, int noPoints, int objective) {
        if (noPoints < 1) {
            new JMetalException("run-time error");
        }
        double minValue = front[0][objective];
        for (int i = 1; i < noPoints; ++i) {
            double value = front[i][objective];
            if (!(value < minValue)) continue;
            minValue = value;
        }
        return minValue;
    }

    private int reduceNondominatedSet(double[][] front, int noPoints, int objective, double threshold) {
        int n = noPoints;
        for (int i = 0; i < n; ++i) {
            if (!(front[i][objective] <= threshold)) continue;
            this.swap(front, i, --n);
        }
        return n;
    }

    public double calculateHypervolume(double[][] front, int noPoints, int noObjectives) {
        double volume = 0.0;
        double distance = 0.0;
        int n = noPoints;
        while (n > 0) {
            double tempVolume;
            int nonDominatedPoints = this.filterNondominatedSet(front, n, noObjectives - 1);
            if (noObjectives < 3) {
                if (nonDominatedPoints < 1) {
                    new JMetalException("run-time error");
                }
                tempVolume = front[0][0];
            } else {
                tempVolume = this.calculateHypervolume(front, nonDominatedPoints, noObjectives - 1);
            }
            double tempDistance = this.surfaceUnchangedTo(front, n, noObjectives - 1);
            volume += tempVolume * (tempDistance - distance);
            distance = tempDistance;
            n = this.reduceNondominatedSet(front, n, noObjectives - 1, distance);
        }
        return volume;
    }

    private double hypervolume(Front front, Front referenceFront) {
        Front invertedFront = FrontUtils.getInvertedFront(front);
        int numberOfObjectives = referenceFront.getPoint(0).dimension();
        return this.calculateHypervolume(FrontUtils.convertFrontToArray(invertedFront), invertedFront.getNumberOfPoints(), numberOfObjectives);
    }

    @Override
    public String getDescription() {
        return "PISA implementation of the hypervolume quality indicator";
    }

    @Override
    public void setOffset(double offset) {
        this.offset = offset;
    }

    @Override
    public List<S> computeHypervolumeContribution(List<S> solutionList, List<S> referenceFrontList) {
        if (solutionList.size() > 1) {
            ArrayFront front = new ArrayFront(solutionList);
            ArrayFront referenceFront = new ArrayFront(referenceFrontList);
            double[] maximumValues = FrontUtils.getMaximumValues(referenceFront);
            double[] minimumValues = FrontUtils.getMinimumValues(referenceFront);
            FrontNormalizer frontNormalizer = new FrontNormalizer(minimumValues, maximumValues);
            Front normalizedFront = frontNormalizer.normalize(front);
            double[] offsets = new double[maximumValues.length];
            for (int i = 0; i < maximumValues.length; ++i) {
                offsets[i] = this.offset / (maximumValues[i] - minimumValues[i]);
            }
            Front invertedFront = FrontUtils.getInvertedFront(normalizedFront);
            for (int i = 0; i < invertedFront.getNumberOfPoints(); ++i) {
                Point point = invertedFront.getPoint(i);
                for (int j = 0; j < point.dimension(); ++j) {
                    point.value(j, point.value(j) + offsets[j]);
                }
            }
            HypervolumeContributionAttribute<Solution> hvContribution = new HypervolumeContributionAttribute<Solution>();
            double[] contributions = this.hvContributions(FrontUtils.convertFrontToArray(invertedFront));
            for (int i = 0; i < contributions.length; ++i) {
                hvContribution.setAttribute((Solution)solutionList.get(i), contributions[i]);
            }
            Collections.sort(solutionList, new HypervolumeContributionComparator());
        }
        return solutionList;
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    private double[] hvContributions(double[][] front) {
        int numberOfObjectives = front[0].length;
        double[] contributions = new double[front.length];
        double[][] frontSubset = new double[front.length - 1][front[0].length];
        LinkedList<double[]> frontCopy = new LinkedList<double[]>();
        Collections.addAll(frontCopy, front);
        double[][] totalFront = (double[][])frontCopy.toArray((T[])frontSubset);
        double totalVolume = this.calculateHypervolume(totalFront, totalFront.length, numberOfObjectives);
        for (int i = 0; i < front.length; ++i) {
            double contribution;
            double[] evaluatedPoint = (double[])frontCopy.remove(i);
            frontSubset = (double[][])frontCopy.toArray((T[])frontSubset);
            double hv = this.calculateHypervolume(frontSubset, frontSubset.length, numberOfObjectives);
            contributions[i] = contribution = totalVolume - hv;
            frontCopy.add(i, evaluatedPoint);
        }
        return contributions;
    }
}

