/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.WeakHashMap;

public class EditDistance {
    private static final WeakHashMap<AbstractMap.SimpleEntry<String, String>, Integer> CACHE = new WeakHashMap();
    private int[] cost;
    private int[] back;
    private final String a;
    private final String b;

    public static int editDistance(String a2, String b2) {
        AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(a2, b2);
        Integer result = null;
        if (CACHE.containsKey(entry)) {
            result = CACHE.get(entry);
        }
        if (result == null) {
            result = new EditDistance(a2, b2).calc();
            CACHE.put(entry, result);
        }
        return result;
    }

    public static String findNearest(String key, String[] group) {
        return EditDistance.findNearest(key, Arrays.asList(group));
    }

    public static String findNearest(String key, Collection<String> group) {
        int c2 = Integer.MAX_VALUE;
        String r = null;
        for (String s : group) {
            int ed = EditDistance.editDistance(key, s);
            if (c2 <= ed) continue;
            c2 = ed;
            r = s;
        }
        return r;
    }

    private EditDistance(String a2, String b2) {
        this.a = a2;
        this.b = b2;
        this.cost = new int[a2.length() + 1];
        this.back = new int[a2.length() + 1];
        for (int i = 0; i <= a2.length(); ++i) {
            this.cost[i] = i;
        }
    }

    private void flip() {
        int[] t = this.cost;
        this.cost = this.back;
        this.back = t;
    }

    private int min(int a2, int b2, int c2) {
        return Math.min(a2, Math.min(b2, c2));
    }

    private int calc() {
        for (int j = 0; j < this.b.length(); ++j) {
            this.flip();
            this.cost[0] = j + 1;
            for (int i = 0; i < this.a.length(); ++i) {
                int match = this.a.charAt(i) == this.b.charAt(j) ? 0 : 1;
                this.cost[i + 1] = this.min(this.back[i] + match, this.cost[i] + 1, this.back[i + 1] + 1);
            }
        }
        return this.cost[this.a.length()];
    }
}

