/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Formatter;
import java.util.Iterator;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;

public abstract class AbstractMatrix
implements Matrix {
    protected int numRows;
    protected int numColumns;

    protected AbstractMatrix(int numRows, int numColumns) {
        if (numRows < 0 || numColumns < 0) {
            throw new IndexOutOfBoundsException("Matrix size cannot be negative");
        }
        this.numRows = numRows;
        this.numColumns = numColumns;
    }

    protected AbstractMatrix(Matrix A) {
        this(A.numRows(), A.numColumns());
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public boolean isSquare() {
        return this.numRows == this.numColumns;
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int row, int column, double value) {
        this.set(row, column, value + this.get(row, column));
    }

    @Override
    public double get(int row, int column) {
        throw new UnsupportedOperationException();
    }

    protected void check(int row, int column) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("row index is negative (" + row + ")");
        }
        if (column < 0) {
            throw new IndexOutOfBoundsException("column index is negative (" + column + ")");
        }
        if (row >= this.numRows) {
            throw new IndexOutOfBoundsException("row index >= numRows (" + row + " >= " + this.numRows + ")");
        }
        if (column >= this.numColumns) {
            throw new IndexOutOfBoundsException("column index >= numColumns (" + column + " >= " + this.numColumns + ")");
        }
    }

    @Override
    public Matrix copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix zero() {
        for (MatrixEntry e2 : this) {
            e2.set(0.0);
        }
        return this;
    }

    @Override
    public Vector mult(Vector x, Vector y) {
        return this.mult(1.0, x, y);
    }

    @Override
    public Vector mult(double alpha, Vector x, Vector y) {
        return this.multAdd(alpha, x, y.zero());
    }

    @Override
    public Vector multAdd(Vector x, Vector y) {
        return this.multAdd(1.0, x, y);
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        this.checkMultAdd(x, y);
        if (alpha != 0.0) {
            for (MatrixEntry e2 : this) {
                y.add(e2.row(), alpha * e2.get() * x.get(e2.column()));
            }
        }
        return y;
    }

    protected void checkMultAdd(Vector x, Vector y) {
        if (this.numColumns != x.size()) {
            throw new IndexOutOfBoundsException("A.numColumns != x.size (" + this.numColumns + " != " + x.size() + ")");
        }
        if (this.numRows != y.size()) {
            throw new IndexOutOfBoundsException("A.numRows != y.size (" + this.numRows + " != " + y.size() + ")");
        }
    }

    @Override
    public Vector transMult(Vector x, Vector y) {
        return this.transMult(1.0, x, y);
    }

    @Override
    public Vector transMult(double alpha, Vector x, Vector y) {
        return this.transMultAdd(alpha, x, y.zero());
    }

    @Override
    public Vector transMultAdd(Vector x, Vector y) {
        return this.transMultAdd(1.0, x, y);
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        this.checkTransMultAdd(x, y);
        if (alpha != 0.0) {
            for (MatrixEntry e2 : this) {
                y.add(e2.column(), alpha * e2.get() * x.get(e2.row()));
            }
        }
        return y;
    }

    protected void checkTransMultAdd(Vector x, Vector y) {
        if (this.numRows != x.size()) {
            throw new IndexOutOfBoundsException("A.numRows != x.size (" + this.numRows + " != " + x.size() + ")");
        }
        if (this.numColumns != y.size()) {
            throw new IndexOutOfBoundsException("A.numColumns != y.size (" + this.numColumns + " != " + y.size() + ")");
        }
    }

    @Override
    public Vector solve(Vector b2, Vector x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector transSolve(Vector b2, Vector x) {
        throw new UnsupportedOperationException();
    }

    protected void checkSolve(Vector b2, Vector x) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (this.numRows != b2.size()) {
            throw new IndexOutOfBoundsException("numRows != b.size (" + this.numRows + " != " + b2.size() + ")");
        }
        if (this.numColumns != x.size()) {
            throw new IndexOutOfBoundsException("numColumns != x.size (" + this.numColumns + " != " + x.size() + ")");
        }
    }

    @Override
    public Matrix rank1(Vector x) {
        return this.rank1(1.0, x);
    }

    @Override
    public Matrix rank1(double alpha, Vector x) {
        return this.rank1(alpha, x, x);
    }

    @Override
    public Matrix rank1(Vector x, Vector y) {
        return this.rank1(1.0, x, y);
    }

    @Override
    public Matrix rank1(double alpha, Vector x, Vector y) {
        this.checkRank1(x, y);
        if (alpha == 0.0) {
            return this;
        }
        for (VectorEntry ei : x) {
            if (ei.get() == 0.0) continue;
            for (VectorEntry ej : y) {
                if (ej.get() == 0.0) continue;
                this.add(ei.index(), ej.index(), alpha * ei.get() * ej.get());
            }
        }
        return this;
    }

    protected void checkRank1(Vector x, Vector y) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (x.size() != this.numRows) {
            throw new IndexOutOfBoundsException("x.size != A.numRows (" + x.size() + " != " + this.numRows + ")");
        }
        if (y.size() != this.numColumns) {
            throw new IndexOutOfBoundsException("y.size != A.numColumns (" + y.size() + " != " + this.numColumns + ")");
        }
    }

    @Override
    public Matrix rank2(Vector x, Vector y) {
        return this.rank2(1.0, x, y);
    }

    @Override
    public Matrix rank2(double alpha, Vector x, Vector y) {
        this.checkRank2(x, y);
        if (alpha == 0.0) {
            return this;
        }
        for (VectorEntry ei : x) {
            for (VectorEntry ej : y) {
                this.add(ei.index(), ej.index(), alpha * ei.get() * ej.get());
                this.add(ej.index(), ei.index(), alpha * ei.get() * ej.get());
            }
        }
        return this;
    }

    protected void checkRank2(Vector x, Vector y) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (x.size() != this.numRows) {
            throw new IndexOutOfBoundsException("x.size != A.numRows (" + x.size() + " != " + this.numRows + ")");
        }
        if (y.size() != this.numRows) {
            throw new IndexOutOfBoundsException("y.size != A.numRows (" + y.size() + " != " + this.numRows + ")");
        }
    }

    @Override
    public Matrix mult(Matrix B, Matrix C) {
        return this.mult(1.0, B, C);
    }

    @Override
    public Matrix mult(double alpha, Matrix B, Matrix C) {
        return this.multAdd(alpha, B, C.zero());
    }

    @Override
    public Matrix multAdd(Matrix B, Matrix C) {
        return this.multAdd(1.0, B, C);
    }

    @Override
    public Matrix multAdd(double alpha, Matrix B, Matrix C) {
        this.checkMultAdd(B, C);
        if (alpha != 0.0) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < C.numColumns(); ++j) {
                    double dot = 0.0;
                    for (int k = 0; k < this.numColumns; ++k) {
                        dot += this.get(i, k) * B.get(k, j);
                    }
                    C.add(i, j, alpha * dot);
                }
            }
        }
        return C;
    }

    protected void checkMultAdd(Matrix B, Matrix C) {
        if (this.numRows != C.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != C.numRows (" + this.numRows + " != " + C.numRows() + ")");
        }
        if (this.numColumns != B.numRows()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numRows (" + this.numColumns + " != " + B.numRows() + ")");
        }
        if (B.numColumns() != C.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != C.numColumns (" + B.numRows() + " != " + C.numColumns() + ")");
        }
    }

    @Override
    public Matrix transAmult(Matrix B, Matrix C) {
        return this.transAmult(1.0, B, C);
    }

    @Override
    public Matrix transAmult(double alpha, Matrix B, Matrix C) {
        return this.transAmultAdd(alpha, B, C.zero());
    }

    @Override
    public Matrix transAmultAdd(Matrix B, Matrix C) {
        return this.transAmultAdd(1.0, B, C);
    }

    @Override
    public Matrix transAmultAdd(double alpha, Matrix B, Matrix C) {
        this.checkTransAmultAdd(B, C);
        if (alpha != 0.0) {
            for (int i = 0; i < this.numColumns; ++i) {
                for (int j = 0; j < C.numColumns(); ++j) {
                    double dot = 0.0;
                    for (int k = 0; k < this.numRows; ++k) {
                        dot += this.get(k, i) * B.get(k, j);
                    }
                    C.add(i, j, alpha * dot);
                }
            }
        }
        return C;
    }

    protected void checkTransAmultAdd(Matrix B, Matrix C) {
        if (this.numRows != B.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numRows (" + this.numRows + " != " + B.numRows() + ")");
        }
        if (this.numColumns != C.numRows()) {
            throw new IndexOutOfBoundsException("A.numColumns != C.numRows (" + this.numColumns + " != " + C.numRows() + ")");
        }
        if (B.numColumns() != C.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != C.numColumns (" + B.numColumns() + " != " + C.numColumns() + ")");
        }
    }

    @Override
    public Matrix transBmult(Matrix B, Matrix C) {
        return this.transBmult(1.0, B, C);
    }

    @Override
    public Matrix transBmult(double alpha, Matrix B, Matrix C) {
        return this.transBmultAdd(alpha, B, C.zero());
    }

    @Override
    public Matrix transBmultAdd(Matrix B, Matrix C) {
        return this.transBmultAdd(1.0, B, C);
    }

    @Override
    public Matrix transBmultAdd(double alpha, Matrix B, Matrix C) {
        this.checkTransBmultAdd(B, C);
        if (alpha != 0.0) {
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < C.numColumns(); ++j) {
                    double dot = 0.0;
                    for (int k = 0; k < this.numColumns; ++k) {
                        dot += this.get(i, k) * B.get(j, k);
                    }
                    C.add(i, j, alpha * dot);
                }
            }
        }
        return C;
    }

    protected void checkTransBmultAdd(Matrix B, Matrix C) {
        if (this.numColumns != B.numColumns()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numColumns (" + this.numColumns + " != " + B.numColumns() + ")");
        }
        if (this.numRows != C.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != C.numRows (" + this.numRows + " != " + C.numRows() + ")");
        }
        if (B.numRows() != C.numColumns()) {
            throw new IndexOutOfBoundsException("B.numRows != C.numColumns (" + B.numRows() + " != " + C.numColumns() + ")");
        }
    }

    @Override
    public Matrix transABmult(Matrix B, Matrix C) {
        return this.transABmult(1.0, B, C);
    }

    @Override
    public Matrix transABmult(double alpha, Matrix B, Matrix C) {
        return this.transABmultAdd(alpha, B, C.zero());
    }

    @Override
    public Matrix transABmultAdd(Matrix B, Matrix C) {
        return this.transABmultAdd(1.0, B, C);
    }

    @Override
    public Matrix transABmultAdd(double alpha, Matrix B, Matrix C) {
        this.checkTransABmultAdd(B, C);
        if (alpha != 0.0) {
            for (int i = 0; i < this.numColumns; ++i) {
                for (int j = 0; j < C.numColumns(); ++j) {
                    double dot = 0.0;
                    for (int k = 0; k < this.numRows; ++k) {
                        dot += this.get(k, i) * B.get(j, k);
                    }
                    C.add(i, j, alpha * dot);
                }
            }
        }
        return C;
    }

    protected void checkTransABmultAdd(Matrix B, Matrix C) {
        if (this.numRows != B.numColumns()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numColumns (" + this.numRows + " != " + B.numColumns() + ")");
        }
        if (this.numColumns != C.numRows()) {
            throw new IndexOutOfBoundsException("A.numColumns != C.numRows (" + this.numColumns + " != " + C.numRows() + ")");
        }
        if (B.numRows() != C.numColumns()) {
            throw new IndexOutOfBoundsException("B.numRows != C.numColumns (" + B.numRows() + " != " + C.numColumns() + ")");
        }
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X) {
        throw new UnsupportedOperationException();
    }

    protected void checkSolve(Matrix B, Matrix X) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (B.numRows() != this.numRows) {
            throw new IndexOutOfBoundsException("B.numRows != A.numRows (" + B.numRows() + " != " + this.numRows + ")");
        }
        if (B.numColumns() != X.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != X.numColumns (" + B.numColumns() + " != " + X.numColumns() + ")");
        }
        if (X.numRows() != this.numColumns) {
            throw new IndexOutOfBoundsException("X.numRows != A.numColumns (" + X.numRows() + " != " + this.numColumns + ")");
        }
    }

    @Override
    public Matrix rank1(Matrix C) {
        return this.rank1(1.0, C);
    }

    @Override
    public Matrix rank1(double alpha, Matrix C) {
        this.checkRank1(C);
        if (alpha == 0.0) {
            return this;
        }
        return C.transBmultAdd(alpha, C, this);
    }

    protected void checkRank1(Matrix C) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (this.numRows != C.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != C.numRows (" + this.numRows + " != " + C.numRows() + ")");
        }
    }

    @Override
    public Matrix transRank1(Matrix C) {
        return this.transRank1(1.0, C);
    }

    @Override
    public Matrix transRank1(double alpha, Matrix C) {
        this.checkTransRank1(C);
        if (alpha == 0.0) {
            return this;
        }
        return C.transAmultAdd(alpha, C, this);
    }

    protected void checkTransRank1(Matrix C) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (this.numRows != C.numColumns()) {
            throw new IndexOutOfBoundsException("A.numRows != C.numColumns (" + this.numRows + " != " + C.numColumns() + ")");
        }
    }

    @Override
    public Matrix rank2(Matrix B, Matrix C) {
        return this.rank2(1.0, B, C);
    }

    @Override
    public Matrix rank2(double alpha, Matrix B, Matrix C) {
        this.checkRank2(B, C);
        if (alpha == 0.0) {
            return this;
        }
        return B.transBmultAdd(alpha, C, C.transBmultAdd(alpha, B, this));
    }

    protected void checkRank2(Matrix B, Matrix C) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (B.numRows() != C.numRows()) {
            throw new IndexOutOfBoundsException("B.numRows != C.numRows (" + B.numRows() + " != " + C.numRows() + ")");
        }
        if (B.numColumns() != C.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != C.numColumns (" + B.numColumns() + " != " + C.numColumns() + ")");
        }
    }

    @Override
    public Matrix transRank2(Matrix B, Matrix C) {
        return this.transRank2(1.0, B, C);
    }

    @Override
    public Matrix transRank2(double alpha, Matrix B, Matrix C) {
        this.checkTransRank2(B, C);
        if (alpha == 0.0) {
            return this;
        }
        return B.transAmultAdd(alpha, C, C.transAmultAdd(alpha, B, this));
    }

    protected void checkTransRank2(Matrix B, Matrix C) {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
        if (this.numRows != B.numColumns()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numColumns (" + this.numRows + " != " + B.numColumns() + ")");
        }
        if (B.numRows() != C.numRows()) {
            throw new IndexOutOfBoundsException("B.numRows != C.numRows (" + B.numRows() + " != " + C.numRows() + ")");
        }
        if (B.numColumns() != C.numColumns()) {
            throw new IndexOutOfBoundsException("B.numColumns != C.numColumns (" + B.numColumns() + " != " + C.numColumns() + ")");
        }
    }

    @Override
    public Matrix scale(double alpha) {
        if (alpha == 1.0) {
            return this;
        }
        if (alpha == 0.0) {
            return this.zero();
        }
        for (MatrixEntry e2 : this) {
            e2.set(alpha * e2.get());
        }
        return this;
    }

    @Override
    public Matrix set(Matrix B) {
        return this.set(1.0, B);
    }

    @Override
    public Matrix set(double alpha, Matrix B) {
        this.checkSize(B);
        if (alpha == 0.0) {
            return this.zero();
        }
        if (B == this) {
            return this.scale(alpha);
        }
        this.zero();
        for (MatrixEntry e2 : B) {
            if (e2.get() == 0.0) continue;
            this.set(e2.row(), e2.column(), alpha * e2.get());
        }
        return this;
    }

    @Override
    public Matrix add(Matrix B) {
        return this.add(1.0, B);
    }

    @Override
    public Matrix add(double alpha, Matrix B) {
        this.checkSize(B);
        if (alpha != 0.0) {
            for (MatrixEntry e2 : B) {
                this.add(e2.row(), e2.column(), alpha * e2.get());
            }
        }
        return this;
    }

    protected void checkSize(Matrix B) {
        if (this.numRows != B.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numRows (" + this.numRows + " != " + B.numRows() + ")");
        }
        if (this.numColumns != B.numColumns()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numColumns (" + this.numColumns + " != " + B.numColumns() + ")");
        }
    }

    @Override
    public Matrix transpose() {
        this.checkTranspose();
        for (int j = 0; j < this.numColumns; ++j) {
            for (int i = j + 1; i < this.numRows; ++i) {
                double value = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, value);
            }
        }
        return this;
    }

    protected void checkTranspose() {
        if (!this.isSquare()) {
            throw new IndexOutOfBoundsException("!A.isSquare");
        }
    }

    @Override
    public Matrix transpose(Matrix B) {
        this.checkTranspose(B);
        if (B == this) {
            return this.transpose();
        }
        B.zero();
        for (MatrixEntry e2 : this) {
            B.set(e2.column(), e2.row(), e2.get());
        }
        return B;
    }

    protected void checkTranspose(Matrix B) {
        if (this.numRows != B.numColumns()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numColumns (" + this.numRows + " != " + B.numColumns() + ")");
        }
        if (this.numColumns != B.numRows()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numRows (" + this.numColumns + " != " + B.numRows() + ")");
        }
    }

    @Override
    public double norm(Matrix.Norm type) {
        if (type == Matrix.Norm.One) {
            return this.norm1();
        }
        if (type == Matrix.Norm.Frobenius) {
            return this.normF();
        }
        if (type == Matrix.Norm.Infinity) {
            return this.normInf();
        }
        return this.max();
    }

    protected double norm1() {
        double[] rowSum = new double[this.numRows];
        for (MatrixEntry e2 : this) {
            int n = e2.row();
            rowSum[n] = rowSum[n] + Math.abs(e2.get());
        }
        return this.max(rowSum);
    }

    protected double normF() {
        double scale = 0.0;
        double ssq = 1.0;
        for (MatrixEntry e2 : this) {
            double Aval = e2.get();
            if (Aval == 0.0) continue;
            double absxi = Math.abs(Aval);
            if (scale < absxi) {
                ssq = 1.0 + ssq * Math.pow(scale / absxi, 2.0);
                scale = absxi;
                continue;
            }
            ssq += Math.pow(absxi / scale, 2.0);
        }
        return scale * Math.sqrt(ssq);
    }

    protected double normInf() {
        double[] columnSum = new double[this.numColumns];
        for (MatrixEntry e2 : this) {
            int n = e2.column();
            columnSum[n] = columnSum[n] + Math.abs(e2.get());
        }
        return this.max(columnSum);
    }

    protected double max() {
        double max = 0.0;
        for (MatrixEntry e2 : this) {
            max = Math.max(Math.abs(e2.get()), max);
        }
        return max;
    }

    protected double max(double[] x) {
        double max = 0.0;
        for (int i = 0; i < x.length; ++i) {
            max = Math.max(x[i], max);
        }
        return max;
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format("%10d %10d %19d\n", this.numRows, this.numColumns, Matrices.cardinality(this));
        int i = 0;
        for (MatrixEntry e2 : this) {
            if (e2.get() != 0.0) {
                out.format("%10d %10d % .12e\n", e2.row() + 1, e2.column() + 1, e2.get());
            }
            if (++i != 100) continue;
            out.format("...\n", new Object[0]);
            break;
        }
        return out.toString();
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new RefMatrixIterator();
    }

    class RefMatrixEntry
    implements MatrixEntry {
        private int row;
        private int column;

        RefMatrixEntry() {
        }

        public void update(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public double get() {
            return AbstractMatrix.this.get(this.row, this.column);
        }

        @Override
        public void set(double value) {
            AbstractMatrix.this.set(this.row, this.column, value);
        }
    }

    class RefMatrixIterator
    implements Iterator<MatrixEntry> {
        int row;
        int column;
        final RefMatrixEntry entry;

        RefMatrixIterator() {
            this.entry = new RefMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.row < AbstractMatrix.this.numRows && this.column < AbstractMatrix.this.numColumns;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (this.row < AbstractMatrix.this.numRows - 1) {
                ++this.row;
            } else {
                ++this.column;
                this.row = 0;
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

