/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import java.util.Arrays;
import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.Vector;
import org.netlib.util.intW;

public class BandMatrix
extends AbstractBandMatrix {
    public BandMatrix(int n, int kl, int ku) {
        super(n, kl, ku);
    }

    public BandMatrix(Matrix A, int kl, int ku) {
        super(A, kl, ku);
    }

    public BandMatrix(Matrix A, int kl, int ku, boolean deep) {
        super(A, kl, ku, deep);
    }

    @Override
    public BandMatrix copy() {
        return new BandMatrix(this, this.kl, this.ku);
    }

    @Override
    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgbmv(Transpose.NoTranspose.netlib(), this.numRows, this.numColumns, this.kl, this.ku, alpha, this.data, this.kl + this.ku + 1, xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgbmv(Transpose.Transpose.netlib(), this.numRows, this.numColumns, this.kl, this.ku, alpha, this.data, this.kl + this.ku + 1, xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        BandMatrix Af = new BandMatrix(this, this.kl, this.ku + this.kl);
        int[] ipiv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dgbsv(this.numRows, this.kl, this.ku, X.numColumns(), Af.getData(), Matrices.ld(2 * this.kl + this.ku + 1), ipiv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Vector solve(Vector b2, Vector x) {
        DenseMatrix B = new DenseMatrix(b2, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transpose() {
        this.checkTranspose();
        if (this.kl != this.ku) {
            throw new IllegalArgumentException("kl != ku");
        }
        for (int j = 0; j < this.numColumns; ++j) {
            for (int i = j + 1; i < Math.min(j + this.kl + 1, this.numRows); ++i) {
                double value = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, value);
            }
        }
        return this;
    }
}

