/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.basic.BasicPanelUI;
import org.bounce.QPanel;

public class BouncePanelUI
extends BasicPanelUI {
    private static final String PREVIOUS_GRADIENT_IMAGE_KEY = "BouncePanelUI.previousGradientImage";
    private static final String PREVIOUS_SIZE_KEY = "BouncePanelUI.previousSize";
    private static PanelUI panelUI;

    public static ComponentUI createUI(JComponent c2) {
        if (panelUI == null) {
            panelUI = new BouncePanelUI();
        }
        return panelUI;
    }

    public void installUI(JComponent c2) {
        JPanel p = (JPanel)c2;
        super.installUI(p);
    }

    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
    }

    public void paint(Graphics g, JComponent c2) {
        ImageIcon icon;
        QPanel panel = (QPanel)c2;
        if (panel.isGradientBackground()) {
            Dimension previousSize = (Dimension)c2.getClientProperty(PREVIOUS_SIZE_KEY);
            if (previousSize == null || !panel.getSize().equals(previousSize)) {
                c2.putClientProperty(PREVIOUS_SIZE_KEY, panel.getSize());
                c2.putClientProperty(PREVIOUS_GRADIENT_IMAGE_KEY, this.calculateGradientImage(c2));
            }
            g.drawImage((Image)c2.getClientProperty(PREVIOUS_GRADIENT_IMAGE_KEY), 0, 0, c2);
        }
        if ((icon = panel.getBackgroundImage()) != null) {
            int panelWidth = panel.getSize().width;
            int panelHeight = panel.getSize().height;
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            int xPos = 0;
            int yPos = 0;
            switch (panel.getBackgroundImageMode()) {
                case 0: {
                    xPos = (panelWidth - iconWidth) / 2;
                    yPos = (panelHeight - iconHeight) / 2;
                    g.drawImage(icon.getImage(), xPos, yPos, panel);
                    break;
                }
                case 1: {
                    xPos = 0;
                    yPos = 0;
                    g.drawImage(icon.getImage(), xPos, yPos, panel);
                    break;
                }
                case 2: {
                    xPos = panelWidth - iconWidth;
                    yPos = 0;
                    g.drawImage(icon.getImage(), xPos, yPos, panel);
                    break;
                }
                case 3: {
                    xPos = 0;
                    yPos = panelHeight - iconHeight;
                    g.drawImage(icon.getImage(), xPos, yPos, panel);
                    break;
                }
                case 4: {
                    xPos = panelWidth - iconWidth;
                    yPos = panelHeight - iconHeight;
                    g.drawImage(icon.getImage(), xPos, yPos, panel);
                    break;
                }
                case 6: {
                    g.drawImage(icon.getImage(), 0, 0, panelWidth, panelHeight, panel);
                    break;
                }
                case 5: {
                    for (int j = 0; j < panelHeight; j += iconHeight) {
                        for (int i = 0; i < panelWidth; i += iconWidth) {
                            g.drawImage(icon.getImage(), i, j, panel);
                        }
                    }
                    break;
                }
            }
        }
    }

    private Image calculateGradientImage(JComponent component) {
        QPanel panel = (QPanel)component;
        Color background = component.getBackground();
        int width = component.getSize().width;
        int height = component.getSize().height;
        int[] pixels = new int[width * height];
        int index = 0;
        int defaultRGB = -16777216;
        int color = background.getRGB();
        int startRed = background.getRed();
        int startBlue = background.getBlue();
        int startGreen = background.getGreen();
        Color finalColor = panel.getGradientColor();
        if (finalColor == null) {
            finalColor = background.darker();
        }
        int finalRed = finalColor.getRed();
        int finalBlue = finalColor.getBlue();
        int finalGreen = finalColor.getGreen();
        for (int col = 0; col < height; ++col) {
            int val1 = (height - col) * 255 / (height - 1);
            for (int row = 0; row < width; ++row) {
                int val2 = row * 255 / (width - 1);
                int value = val2 - val1;
                if (value >= 0) {
                    int red = this.calculateComponent(startRed, finalRed, value);
                    int blue = this.calculateComponent(startBlue, finalBlue, value);
                    int green = this.calculateComponent(startGreen, finalGreen, value);
                    pixels[index] = defaultRGB | red << 16 | green << 8 | blue << 0;
                } else {
                    pixels[index] = color;
                }
                ++index;
            }
        }
        return component.createImage(new MemoryImageSource(width, height, ColorModel.getRGBdefault(), pixels, 0, width));
    }

    private int calculateComponent(int start, int end, int value) {
        int component = 0;
        component = start < end ? start - (start - end) * value / 255 : start + (end - start) * value / 255;
        if (component < 0) {
            component = 0;
        } else if (component > 255) {
            component = 255;
        }
        return component;
    }
}

