/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class HUXCrossover<S extends BinarySolution>
implements CrossoverOperator<S> {
    private double crossoverProbability;
    private final RandomGenerator<Double> randomGenerator;

    public HUXCrossover(double crossoverProbability) {
        this(crossoverProbability, () -> JMetalRandom.getInstance().nextDouble());
    }

    public HUXCrossover(double crossoverProbability, RandomGenerator<Double> randomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        this.crossoverProbability = crossoverProbability;
        this.randomGenerator = randomGenerator;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    @Override
    public List<S> execute(List<S> parents) {
        Check.that(parents.size() == 2, "HUXCrossover.execute: operator needs two parents");
        return this.doCrossover(this.crossoverProbability, (BinarySolution)parents.get(0), (BinarySolution)parents.get(1));
    }

    public List<S> doCrossover(double probability, S parent1, S parent2) throws JMetalException {
        ArrayList<BinarySolution> offspring = new ArrayList<BinarySolution>();
        offspring.add((BinarySolution)parent1.copy());
        offspring.add((BinarySolution)parent2.copy());
        if (this.randomGenerator.getRandomValue() < probability) {
            for (int var = 0; var < parent1.variables().size(); ++var) {
                BinarySet p1 = (BinarySet)parent1.variables().get(var);
                BinarySet p2 = (BinarySet)parent2.variables().get(var);
                for (int bit = 0; bit < p1.size(); ++bit) {
                    if (p1.get(bit) == p2.get(bit) || !(this.randomGenerator.getRandomValue() < 0.5)) continue;
                    ((BinarySet)((BinarySolution)offspring.get(0)).variables().get(var)).set(bit, p2.get(bit));
                    ((BinarySet)((BinarySolution)offspring.get(1)).variables().get(var)).set(bit, p1.get(bit));
                }
            }
        }
        return offspring;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

