/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.crossover.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class PMXCrossover
implements CrossoverOperator<PermutationSolution<Integer>> {
    private double crossoverProbability = 1.0;
    private BoundedRandomGenerator<Integer> cuttingPointRandomGenerator;
    private RandomGenerator<Double> crossoverRandomGenerator;

    public PMXCrossover(double crossoverProbability) {
        this(crossoverProbability, () -> JMetalRandom.getInstance().nextDouble(), (a2, b2) -> JMetalRandom.getInstance().nextInt((int)a2, (int)b2));
    }

    public PMXCrossover(double crossoverProbability, RandomGenerator<Double> randomGenerator) {
        this(crossoverProbability, randomGenerator, BoundedRandomGenerator.fromDoubleToInteger(randomGenerator));
    }

    public PMXCrossover(double crossoverProbability, RandomGenerator<Double> crossoverRandomGenerator, BoundedRandomGenerator<Integer> cuttingPointRandomGenerator) {
        Check.probabilityIsValid(crossoverProbability);
        this.crossoverProbability = crossoverProbability;
        this.crossoverRandomGenerator = crossoverRandomGenerator;
        this.cuttingPointRandomGenerator = cuttingPointRandomGenerator;
    }

    @Override
    public double crossoverProbability() {
        return this.crossoverProbability;
    }

    public void crossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    @Override
    public List<PermutationSolution<Integer>> execute(List<PermutationSolution<Integer>> parents) {
        Check.notNull(parents);
        Check.that(parents.size() == 2, "There must be two parents instead of " + parents.size());
        return this.doCrossover(this.crossoverProbability, parents);
    }

    public List<PermutationSolution<Integer>> doCrossover(double probability, List<PermutationSolution<Integer>> parents) {
        ArrayList<PermutationSolution<Integer>> offspring = new ArrayList<PermutationSolution<Integer>>(2);
        offspring.add((PermutationSolution)parents.get(0).copy());
        offspring.add((PermutationSolution)parents.get(1).copy());
        int permutationLength = parents.get(0).variables().size();
        if (this.crossoverRandomGenerator.getRandomValue() < probability) {
            int i;
            int cuttingPoint1 = this.cuttingPointRandomGenerator.getRandomValue(0, permutationLength - 1);
            int cuttingPoint2 = this.cuttingPointRandomGenerator.getRandomValue(0, permutationLength - 1);
            while (cuttingPoint2 == cuttingPoint1) {
                cuttingPoint2 = this.cuttingPointRandomGenerator.getRandomValue(0, permutationLength - 1);
            }
            if (cuttingPoint1 > cuttingPoint2) {
                int swap = cuttingPoint1;
                cuttingPoint1 = cuttingPoint2;
                cuttingPoint2 = swap;
            }
            int[] replacement1 = new int[permutationLength];
            int[] replacement2 = new int[permutationLength];
            for (i = 0; i < permutationLength; ++i) {
                replacement2[i] = -1;
                replacement1[i] = -1;
            }
            for (i = cuttingPoint1; i <= cuttingPoint2; ++i) {
                ((PermutationSolution)offspring.get(0)).variables().set(i, (Integer)parents.get(1).variables().get(i));
                ((PermutationSolution)offspring.get(1)).variables().set(i, (Integer)parents.get(0).variables().get(i));
                replacement1[((Integer)parents.get((int)1).variables().get((int)i)).intValue()] = (Integer)parents.get(0).variables().get(i);
                replacement2[((Integer)parents.get((int)0).variables().get((int)i)).intValue()] = (Integer)parents.get(1).variables().get(i);
            }
            for (i = 0; i < permutationLength; ++i) {
                if (i >= cuttingPoint1 && i <= cuttingPoint2) continue;
                int n1 = (Integer)parents.get(0).variables().get(i);
                int m1 = replacement1[n1];
                int n2 = (Integer)parents.get(1).variables().get(i);
                int m2 = replacement2[n2];
                while (m1 != -1) {
                    n1 = m1;
                    m1 = replacement1[m1];
                }
                while (m2 != -1) {
                    n2 = m2;
                    m2 = replacement2[m2];
                }
                ((PermutationSolution)offspring.get(0)).variables().set(i, n1);
                ((PermutationSolution)offspring.get(1)).variables().set(i, n2);
            }
        }
        return offspring;
    }

    @Override
    public int numberOfRequiredParents() {
        return 2;
    }

    @Override
    public int numberOfGeneratedChildren() {
        return 2;
    }
}

