/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.selection.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DifferentialEvolutionSelection
implements SelectionOperator<List<DoubleSolution>, List<DoubleSolution>> {
    private int currentSolutionIndex = Integer.MIN_VALUE;
    private BoundedRandomGenerator<Integer> randomGenerator;
    private int numberOfSolutionsToSelect;
    private boolean selectCurrentSolution;

    public DifferentialEvolutionSelection() {
        this((a2, b2) -> JMetalRandom.getInstance().nextInt((int)a2, (int)b2), 3, false);
    }

    public DifferentialEvolutionSelection(int numberOfSolutionsToSelect, boolean selectCurrentSolution) {
        this((a2, b2) -> JMetalRandom.getInstance().nextInt((int)a2, (int)b2), numberOfSolutionsToSelect, selectCurrentSolution);
    }

    public DifferentialEvolutionSelection(BoundedRandomGenerator<Integer> randomGenerator, int numberOfSolutionsToSelect, boolean selectCurrentSolution) {
        this.randomGenerator = randomGenerator;
        this.numberOfSolutionsToSelect = numberOfSolutionsToSelect;
        this.selectCurrentSolution = selectCurrentSolution;
    }

    public void setIndex(int index) {
        this.currentSolutionIndex = index;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> solutionList) {
        int solutionsToSelect;
        Check.notNull(solutionList);
        Check.that(this.currentSolutionIndex >= 0 && this.currentSolutionIndex <= solutionList.size(), "Index value invalid: " + this.currentSolutionIndex);
        Check.that(solutionList.size() >= this.numberOfSolutionsToSelect, "The population has less than " + this.numberOfSolutionsToSelect + " solutions: " + solutionList.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int n = solutionsToSelect = this.selectCurrentSolution ? this.numberOfSolutionsToSelect - 1 : this.numberOfSolutionsToSelect;
        do {
            int index2;
            if ((index2 = this.randomGenerator.getRandomValue(0, solutionList.size() - 1).intValue()) == this.currentSolutionIndex || indexList.contains(index2)) continue;
            indexList.add(index2);
        } while (indexList.size() < solutionsToSelect);
        if (this.selectCurrentSolution) {
            indexList.add(this.currentSolutionIndex);
        }
        return indexList.stream().map(index -> (DoubleSolution)solutionList.get((int)index)).collect(Collectors.toList());
    }
}

