/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.distance.impl.DominanceDistanceBetweenVectors;
import org.uma.jmetal.util.errorchecking.Check;

public class InvertedGenerationalDistancePlus
extends QualityIndicator {
    public InvertedGenerationalDistancePlus() {
    }

    public InvertedGenerationalDistancePlus(double[][] referenceFront) {
        super(referenceFront);
    }

    @Override
    public double compute(double[][] front) {
        Check.notNull(front);
        return this.invertedGenerationalDistancePlus(front, this.referenceFront);
    }

    public double invertedGenerationalDistancePlus(double[][] front, double[][] referenceFront) {
        double sum = 0.0;
        for (int i = 0; i < referenceFront.length; ++i) {
            sum += VectorUtils.distanceToClosestVector(referenceFront[i], front, new DominanceDistanceBetweenVectors());
        }
        return sum / (double)referenceFront.length;
    }

    @Override
    public String name() {
        return "IGD+";
    }

    @Override
    public String description() {
        return "Inverted Generational Distance+";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

