/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.distance.impl;

import org.uma.jmetal.util.distance.Distance;

public class CosineSimilarityBetweenVectors
implements Distance<double[], double[]> {
    private double[] referencePoint;

    public CosineSimilarityBetweenVectors(double[] referencePoint) {
        this.referencePoint = referencePoint;
    }

    @Override
    public double compute(double[] vector1, double[] vector2) {
        double sum = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            sum += (vector1[i] - this.referencePoint[i]) * (vector2[i] - this.referencePoint[i]);
        }
        return sum / (this.sumOfDistancesToIdealPoint(vector1) * this.sumOfDistancesToIdealPoint(vector2));
    }

    private double sumOfDistancesToIdealPoint(double[] vector) {
        double sum = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            sum += Math.pow(vector[i] - this.referencePoint[i], 2.0);
        }
        return Math.sqrt(sum);
    }
}

