/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.measure.impl;

import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.PullMeasure;
import org.uma.jmetal.util.measure.PushMeasure;
import org.uma.jmetal.util.measure.impl.MeasureFactory;
import org.uma.jmetal.util.measure.impl.SimplePushMeasure;
import org.uma.jmetal.util.naming.DescribedEntity;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class PullPushMeasure<Value>
implements PullMeasure<Value>,
PushMeasure<Value> {
    private final PullMeasure<Value> puller;
    private final PushMeasure<Value> pusher;
    private final DescribedEntity reference;

    public PullPushMeasure(PullMeasure<Value> pull, PushMeasure<Value> push, DescribedEntity reference) {
        this.puller = pull;
        this.pusher = push;
        this.reference = reference;
    }

    public PullPushMeasure(PullMeasure<Value> pull, PushMeasure<Value> push, String name, String description) {
        this(pull, push, new SimpleDescribedEntity(name, description));
    }

    public PullPushMeasure(PushMeasure<Value> push, Value initialValue) {
        this(new MeasureFactory().createPullFromPush(push, initialValue), push, push);
    }

    public PullPushMeasure(String name, String description) {
        this(new SimplePushMeasure(name, description), null);
    }

    @Override
    public void register(MeasureListener<Value> listener) {
        this.pusher.register(listener);
    }

    @Override
    public void unregister(MeasureListener<Value> listener) {
        this.pusher.unregister(listener);
    }

    @Override
    public Value get() {
        return this.puller.get();
    }

    @Override
    public String name() {
        return this.reference.name();
    }

    @Override
    public String description() {
        return this.reference.description();
    }
}

