/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.neighborhood.util;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.neighborhood.Neighborhood;

public class TwoDimensionalMesh<S>
implements Neighborhood<S> {
    private final int rows;
    private final int columns;
    private final int[][] neighborhood;
    private int[][] mesh;

    public TwoDimensionalMesh(int rows, int columns, int[][] neighborhood) {
        this.rows = rows;
        this.columns = columns;
        this.neighborhood = neighborhood;
        this.createMesh();
    }

    private void createMesh() {
        this.mesh = new int[this.rows][this.columns];
        int solution = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                this.mesh[row][column] = solution++;
            }
        }
    }

    private int getRow(int solution) {
        return solution / this.columns;
    }

    private int getColumn(int solution) {
        return solution % this.columns;
    }

    private int getNeighbor(int solution, int[] neighbor) {
        int c2;
        int row = this.getRow(solution);
        int col = this.getColumn(solution);
        int r = (row + neighbor[0]) % this.rows;
        if (r < 0) {
            r = this.rows - 1;
        }
        if ((c2 = (col + neighbor[1]) % this.columns) < 0) {
            c2 = this.columns - 1;
        }
        return this.mesh[r][c2];
    }

    private List<S> findNeighbors(List<S> solutionSet, int solution, int[][] neighborhood) {
        ArrayList<S> neighbors = new ArrayList<S>(neighborhood.length + 1);
        for (int[] neighbor : neighborhood) {
            int index = this.getNeighbor(solution, neighbor);
            neighbors.add(solutionSet.get(index));
        }
        return neighbors;
    }

    @Override
    public List<S> getNeighbors(List<S> solutionList, int solutionPosition) {
        Check.notNull(solutionList);
        Check.collectionIsNotEmpty(solutionList);
        Check.that(solutionPosition >= 0, "The solution position value is negative: " + solutionPosition);
        Check.that(solutionList.size() == this.rows * this.columns, "The solution list size " + solutionList.size() + " is notequal to the grid size: " + this.rows + " * " + this.columns);
        Check.that(solutionPosition < solutionList.size(), "The solution position value " + solutionPosition + " is equal or greater than the solution list size " + solutionList.size());
        return this.findNeighbors(solutionList, solutionPosition, this.neighborhood);
    }
}

