/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.plot;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class SingleValueScatterPlot {
    private final XYChart chart;
    private SwingWrapper<XYChart> swingWrapper;
    private final String legend;
    private final List<Double> listOfXValues = new ArrayList<Double>();
    private final List<Double> listOfYValues = new ArrayList<Double>();
    private boolean firstUpdate = true;
    private long delay = 1000L;

    public SingleValueScatterPlot(String title, String xAxisTitle, String yAxisTitle, String legend) {
        this.chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title(title)).xAxisTitle(xAxisTitle).yAxisTitle(yAxisTitle).build();
        this.legend = legend;
        ((XYStyler)this.chart.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideE);
        ((XYStyler)this.chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
        ((XYStyler)this.chart.getStyler()).setCursorEnabled(true);
    }

    public void delay(long delay) {
        this.delay = delay;
    }

    public void chartTitle(String newTitle) {
        this.chart.setTitle(newTitle);
    }

    public void updateChart(double x, double y) {
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.listOfXValues.add(x);
            this.listOfYValues.add(y);
            this.chart.addSeries(this.legend, this.listOfXValues, this.listOfYValues);
            this.swingWrapper = new SwingWrapper<XYChart>(this.chart);
            this.swingWrapper.displayChart();
        } else {
            try {
                TimeUnit.MILLISECONDS.sleep(this.delay);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            this.listOfXValues.add(x);
            this.listOfYValues.add(y);
            this.chart.updateXYSeries(this.legend, this.listOfXValues, this.listOfYValues, null);
            this.swingWrapper.repaintChart();
        }
    }

    public XYChart chart() {
        return this.chart;
    }
}

