/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.pseudorandom.impl;

import org.uma.jmetal.util.pseudorandom.PseudoRandomGenerator;

public class ExtendedPseudoRandomGenerator
implements PseudoRandomGenerator {
    private final PseudoRandomGenerator randomGenerator;

    public ExtendedPseudoRandomGenerator(PseudoRandomGenerator randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    @Override
    public int nextInt(int lowerBound, int upperBound) {
        return this.randomGenerator.nextInt(lowerBound, upperBound);
    }

    @Override
    public double nextDouble(double lowerBound, double upperBound) {
        return this.randomGenerator.nextDouble(lowerBound, upperBound);
    }

    @Override
    public double nextDouble() {
        return this.randomGenerator.nextDouble();
    }

    @Override
    public void setSeed(long seed) {
        this.randomGenerator.setSeed(seed);
    }

    @Override
    public long getSeed() {
        return this.randomGenerator.getSeed();
    }

    @Override
    public String getName() {
        return this.randomGenerator.getName() + " (extended)";
    }

    public double randNormal(double mean, double standardDeviation) {
        double x2;
        double x1;
        double w;
        while ((w = (x1 = 2.0 * this.randomGenerator.nextDouble() - 1.0) * x1 + (x2 = 2.0 * this.randomGenerator.nextDouble() - 1.0) * x2) >= 1.0) {
        }
        w = Math.sqrt(-2.0 * Math.log(w) / w);
        double y1 = x1 * w;
        y1 = y1 * standardDeviation + mean;
        return y1;
    }

    public double[] randSphere(int dimension) {
        int i;
        int D = dimension;
        double[] x = new double[dimension];
        double length = 0.0;
        for (i = 0; i < dimension; ++i) {
            x[i] = 0.0;
        }
        for (i = 0; i < D; ++i) {
            x[i] = this.randNormal(0.0, 1.0);
            length += x[i] * x[i];
        }
        if ((length = Math.sqrt(length)) > 0.0) {
            double r = this.randomGenerator.nextDouble(0.0, 1.0);
            for (int i2 = 0; i2 < D; ++i2) {
                x[i2] = r * x[i2] / length;
            }
        }
        return x;
    }

    public double[] randSphere(int dimension, double center, double radius) {
        int i;
        int d2 = dimension;
        double[] x = new double[dimension];
        double length = 0.0;
        for (i = 0; i < dimension; ++i) {
            x[i] = 0.0;
        }
        for (i = 0; i < d2; ++i) {
            x[i] = this.randNormal(0.0, 1.0);
            length += length + x[i] * x[i];
        }
        length = Math.sqrt(length);
        double r = this.randomGenerator.nextDouble(0.0, 1.0);
        for (int i2 = 0; i2 < d2; ++i2) {
            x[i2] = center + radius * r * x[i2] / length;
        }
        return x;
    }
}

